@extends('layouts.blank')

@section('content')

<div class="cls-content-sm panel">
    <div class="panel-body">
        <h1 class="h3">{{ translate('Reset Password') }}</h1>
        <p class="pad-btm">{{translate('Enter your email address to recover your password.')}} </p>
        <form method="POST" action="{{ route('password.email') }}">
            @csrf
            <div class="form-group">
                @if (\App\Addon::where('unique_identifier', 'otp_system')->first() != null && \App\Addon::where('unique_identifier', 'otp_system')->first()->activated)
                    <input id="email" type="text" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" required placeholder="{{ translate('Phone Use With Country Code') }}">
                    <div class="form-group">
                                                <button class="btn btn-link p-0" type="button" id="input_change">{{ translate('Use Email Instead') }}</button>
                                            </div>
                @else
                    <input type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" value="{{ old('email') }}" placeholder="{{ translate('Email') }}" name="email">
                @endif

                @if ($errors->has('email'))
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $errors->first('email') }}</strong>
                    </span>
                @endif
            </div>
            <div class="form-group text-right">
                <button class="btn btn-danger btn-lg btn-block" type="submit">
                    {{ translate('Send Password Reset Link') }}
                </button>
            </div>
        </form>
        <div class="pad-top">
            <a href="{{route('user.login')}}" class="btn-link text-bold text-main">{{translate('Back to Login')}}</a>
        </div>
    </div>
</div>


@endsection
<script src="{{ static_asset('frontend/js/vendor/jquery.min.js') }}"></script>
<script type="text/javascript">
$(document).ready(function(){
$("#input_change").click(function(){
    $input_placehoder = $("#email").attr("placeholder");
    if($input_placehoder == "Phone Use With Country Code"){
        $(this).text("Use Phone Instead");
  $("#email").attr("placeholder", "Email");
}else{
    $(this).text("Use Email Instead");
    $("#email").attr("placeholder", "Phone Use With Country Code");
}
});
});
</script>
