<!DOCTYPE html>
<html lang="en">
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>AM Law Offices</title>
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Libre+Baskerville:ital,wght@0,400;0,700;1,400&amp;family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap"
        rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link media="all" rel="stylesheet" href="css/main.css">
    <style>
        .form-container {
            background: white;
            padding: 20px 30px;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 700px;
            margin: 0 auto;
        }

        h2 {
            text-align: center;
            color: #898777;
            margin-bottom: 20px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        label {
            display: block;
            margin-bottom: 5px;
            color: #444;
            font-weight: bold;
        }

        input {
            width: 100%;
            padding: 10px;
            border-radius: 5px;
            font-size: 16px;
            outline: none;
            transition: border 0.3s ease;
        }

        input:focus {
            border: 1px solid #898777;
            box-shadow: 0 0 5px rgba(192, 148, 57, 0.5);
        }

        button {
            width: 100%;
            padding: 10px;
            background: #898777;
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
        }

        button:hover {
            background: #898777;
        }

        .image img {
            width: 100%;
            height: auto;
            border-radius: 10px;
            margin-right: 20%;
        }

        .row {
            display: flex;
            flex-wrap: wrap;
            align-items: stretch;
        }

        .col-md-5 {
            display: flex;
            justify-content: center;
            align-items: center;
        }

        @media (max-width: 1023px) {
            .image img {
                display: none;
            }
        }


        .quote {
            width: 60%;
            margin: 0 auto;
            padding: 50px 0;
        }

        .quote h1 {
            font-size: 36px;
            color: #8a8a5c;
        }

        .quote p {
            font-size: 18px;
            margin-bottom: 40px;
        }

        .quote form {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
        }

        .form-group {
            width: 48%;
            margin-bottom: 20px;
        }

        .form-group.full-width {
            width: 100%;
        }

        .s-btn {
            text-align: center;
        }

        label {
            display: block;
            font-size: 16px;
            margin-bottom: 5px;
        }

        input,
        textarea {
            width: 100%;
            padding: 10px;
            font-size: 16px;
            border: none;
            border: 1px solid rgb(187, 187, 187);
            outline: none;
        }

        textarea {
            height: 100px;
        }

        .submit-btn {
            background-color: #4a4a4a;
            width: 200px;
            color: #fff;
            padding: 10px 20px;
            font-size: 18px;
            border: none;
            cursor: pointer;
            margin-top: 20px;
        }

        @media (max-width: 767px) {
            .form-container {
                box-shadow: none;
            }
        }
    </style>
</head>

<body>
    <div class="wrapper wrapper--offset-0">
        <?php include('main-header.php') ?>
        <main class="main">
            <section class="section-intro">
                <div class="container">
                    <h1>Get a Quote</h1>

                </div>
                <div class="bg-stretch">
                    <img src="img/home/banner-1.jpg" alt="image description">
                </div>
            </section>
            <section class="section-breadcrumbs">
                <div class="container">
                    <ul class="breadcrumbs">
                        <li class="breadcrumbs__item"><a href="index.php" class="breadcrumbs__link">Home</a></li>
                        <li class="breadcrumbs__item current">Get a Quote</li>
                    </ul>
                </div>
            </section>

            <section>
                <div class=" row mb--3 pt-5 align-items-center">
                    <div class="form-container">
                        <h2>Get a Quote</h2>
                        <p>Interested in hiring our services? Simply fill out the form below and one of our team members
                            will get in touch as soon as possible.</p>
                        <form id="applicationForm">
                            <input type="hidden" name="applicationType" value="Join Us Application">
                            <div class="row">
                                <div class="form-group w-100">
                                    <label for="fname">First Name</label>
                                    <input type="text" id="fname" name="fname" placeholder="Enter your first name"
                                        required>
                                </div>
                                <div class="form-group w-100">
                                    <label for=" lname">Last Name</label>
                                    <input type="text" id="lname" name="lname" placeholder="Enter your last name"
                                        required>
                                </div>
                                <div class="form-group w-100">
                                    <label for="email">Email</label>
                                    <input type="email" id="email" name="email" placeholder="Enter your email" required>
                                </div>
                                <div class="form-group w-100">
                                    <label for="phone">Phone</label>
                                    <input type="number" id="phone" name="phone" placeholder="Enter your phone number"
                                        required>
                                </div>
                                <div class="form-group w-100">
                                    <label for="YOE">Comments</label>
                                    <textarea name="" placeholder="Enter your comment" id=""></textarea>
                                </div>

                            </div>
                            <div class="w-100 text-center">
                                <button class="btn btn--outline-primary w-50" type="submit">Submit</button>
                            </div>
                        </form>
                    </div>

                </div>
            </section>
        </main>
    </div>

    <?php include('main-footer.php'); ?>

    <script>
        document.getElementById("applicationForm").addEventListener("submit", function(e) {
            e.preventDefault();

            const formData = new FormData(e.target);
            console.log(formData); // Check if form data is being collected correctly

            fetch('send_email.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.text())
                .then(response => {
                    if (response === "success") {
                        alert("Your application has been submitted successfully!");
                        e.target.reset(); // Clear the form
                    } else {
                        alert("There was an error submitting your application: " + response);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert("An unexpected error occurred. Please try again.");
                });
        });
    </script>
    <script src="js/all.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/lightbox2/dist/js/lightbox.min.js"></script>

</body>

</html>

<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require './PHPMailer/Exception.php';
require './PHPMailer/PHPMailer.php';
require './PHPMailer/SMTP.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Collect form data
    $firstName = $_POST['fname'];
    $lastName = $_POST['lname'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $yearsOfExperience = $_POST['YOE'];
    $cvLink = $_POST['CV'];

    // Set up PHPMailer object
    $mail = new PHPMailer(true);
    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host = 'smtp.gmail.com'; // Gmail SMTP server
        $mail->SMTPAuth = true;
        $mail->Username = 'nitin2019it035abesit@gmail.com'; // Replace with your email
        $mail->Password = 'cvewhcanbrekhcvj'; // Replace with your email password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;

        // Recipients
        $mail->setFrom('nitin2019it035abesit@gmail.com', 'AM Law Offices'); // Replace with your email
        $mail->addAddress('nitsha1999n@gmail.com', 'Website Owner'); // Replace with website owner's email

        // Content
        $mail->isHTML(true);
        $mail->Subject = 'New Internship Application';
        $mail->Body = "<h1>New Internship Application</h1>
            <p><strong>First Name:</strong> $firstName</p>
            <p><strong>Last Name:</strong> $lastName</p>
            <p><strong>Email:</strong> $email</p>
            <p><strong>Phone:</strong> $phone</p>
            <p><strong>Years of Experience:</strong> $yearsOfExperience</p>
            <p><strong>CV/LinkedIn Link:</strong> <a href='$cvLink' target='_blank'>$cvLink</a></p>";

        // Send email
        $mail->send();
        echo "success"; // Return success message to the frontend
    } catch (Exception $e) {
        echo "Mailer Error: " . $mail->ErrorInfo; // Output the PHPMailer error message
    }
}

?>