 <!DOCTYPE html>
 <html lang="en">
 <meta http-equiv="content-type" content="text/html;charset=UTF-8" />

 <head>
     <meta charset="utf-8">
     <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
     <title>Practice Areas - AM Law Offices</title>
     <link rel="preconnect" href="https://fonts.googleapis.com/">
     <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
     <link
         href="https://fonts.googleapis.com/css2?family=Libre+Baskerville:ital,wght@0,400;0,700;1,400&amp;family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap"
         rel="stylesheet">
     <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
         integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
     <link media="all" rel="stylesheet" href="css/main.css">
 </head>

 <body>
     <div class="wrapper wrapper--offset-0">
         <?php include('main-header.php'); ?>
         <main class="main">
             <section class="section-intro">
                 <div class="container">
                     <h1>Our Expertise</h1>
                 </div>
                 <div class="bg-stretch">
                     <img src="img/home/banner-1.jpg" alt="image description">
                 </div>
             </section>
             <section class="section-breadcrumbs">
                 <div class="container">
                     <ul class="breadcrumbs">
                         <li class="breadcrumbs__item"><a href="index.php" class="breadcrumbs__link">Home</a></li>
                         <li class="breadcrumbs__item current">Our Expertise</li>
                     </ul>
                 </div>
             </section>

             <section class="section">
                 <div class="container">
                     <div class="section-headline">
                         <h3>Practices stats</h3>
                         <p>Our lawyers offer clients a range of integrated global
                             capabilities,
                             including
                             some of the
                             world’s most active M&A, real estate, financial services, litigation and corporate risk
                             practices.</p>
                     </div>
                     <div class="row justify-content-center">
                         <div class="col-md-4">
                             <div class="doughnut-chart">
                                 <canvas id="myDonutChart"></canvas>
                             </div>
                         </div>
                         <div class="col-md-7">
                             <ul class="progress-list">
                                 <li>
                                     <div class="progress-tile">
                                         <h5 class="progress-tile__title">Consultation</h5>
                                         <div class="progress-bar"><span class="progress-bar__line animated"
                                                 data-width="25%" style="width: 25%;"></span></div>
                                         <span class="progress-tile__num">25%</span>
                                     </div>
                                 </li>
                                 <li>
                                     <div class="progress-tile">
                                         <h5 class="progress-tile__title">Practice</h5>
                                         <div class="progress-bar"><span class="progress-bar__line animated"
                                                 data-width="60%" style="width: 60%;"></span></div>
                                         <span class="progress-tile__num">60%</span>
                                     </div>
                                 </li>
                                 <li>
                                     <div class="progress-tile">
                                         <h5 class="progress-tile__title">Mediation</h5>
                                         <div class="progress-bar"><span class="progress-bar__line animated"
                                                 data-width="15%" style="width: 15%;"></span></div>
                                         <span class="progress-tile__num">15%</span>
                                     </div>
                                 </li>
                             </ul>
                         </div>

                     </div>
                 </div>
             </section>
             <section class="section bg--light">
                 <div class="container">
                     <div class="section-headline">
                         <h3 class="practices-area">Practices Areas</h3>
                         <p class="practices-area">Our lawyers provide clients with a comprehensive suite of
                             global capabilities. These
                             encompass some of the most active and sought-after practices, including mergers and
                             acquisitions (M&A), real estate, financial services, corporate risk management, and more.
                         </p>
                     </div>
                     <div class="row mb--3 pt-5 align-items-center">
                         <div class=" col-md-5">
                             <img src="img/expertise/Supreme.webp" alt="AM legal office">
                         </div>
                         <div class="  col-md-5 offset-md-1">
                             <h3>Constitutional Law Disputes </h3>
                             <p>We are the top law firm in Lucknow and mainly deal in
                                 Constitutional, civil, real estate
                                 litigation and advisory, Service & employment issues, arbitration, stamp and service
                                 matters: particularly government accountability, corruption, consumer and banking
                                 matters, matrimonial disputes- divorce, domestic violence., You can contact us for
                                 getting a perfect solution to the issues mentioned above. Our team of expert lawyers
                                 Practices in the Supreme Court dealing with complex issues. The best thing about
                                 contacting us is that we provide top-notch services. </p>
                         </div>
                     </div>
                     <div class="row mb--3 pt-5 align-items-center">
                         <div class="col-md-5">
                             <h3>Corporate Law
                             </h3>
                             <p>Our corporate-commercial team has extensive experience in
                                 providing a wide range of
                                 services to corporations, directors, shareholders, partnerships, limited liability
                                 partnerships, trusts, joint ventures, government-owned, government-funded, and other
                                 business entities in a variety of industries, including renewable energy,
                                 infrastructure, information technology and communication, healthcare, chemicals,
                                 pharmaceutical, matrimony-commerce services and trading, investment funding, and so on.
                             </p>
                         </div>
                         <div class="col-md-5  offset-md-1">
                             <img src="img/expertise/Smiling Handshake.webp" alt="AM legal office">
                         </div>
                     </div>

                     <div class="row mb--3 pt-5 align-items-center">
                         <div class=" col-md-5">
                             <img src="img/expertise/Signing a Contract.webp" alt="AM legal office">
                         </div>
                         <div class="col-md-5 offset-md-1">
                             <h3>Real Estate Litigation and Advisory</h3>
                             <p>Includes all disputes and matters related to property and
                                 estate planning. AM law
                                 Offices has a great bunch of advocates among which you can get highly essential legal
                                 assistance. If you think you are in need of a real estate lawyer in Lucknow who can
                                 help you out in grabbing your dream in the national capital, all you need is to get in
                                 touch with AM Law offices.</p>
                         </div>
                     </div>

                     <div class="row mb--3 pt-5 align-items-center">
                         <div class="col-md-5">
                             <h3>Service Related Disputes
                             </h3>
                             <p>AM Law Offices has a team of experts ready to advise our
                                 clients on Service related
                                 disputes related to termination, suspension, promotion, reversion etc.in Lucknow area.
                                 We extend our legal experiences to serve clients of all types and sizes. Give us a call
                                 now.</p>
                         </div>
                         <div class="col-md-5  offset-md-1">
                             <img src="img/expertise/Civil cases.webp" alt="AM legal office">
                         </div>
                     </div>

                     <div class="row mb--3 pt-5 align-items-center">
                         <div class=" col-md-5">
                             <img src="img/expertise/Contract Paper Signing.webp" alt="AM legal office">
                         </div>
                         <div class="col-md-5 offset-md-1">
                             <h3>Tax Law</h3>
                             <p>We advise and assist corporate business entities,
                                 non-corporate entities, and high net
                                 worth individuals in strategizing and meeting their domestic tax obligations. We also
                                 assist our clients in resolving complex disputes with the Revenue authorities. We
                                 provide a variety of indirect tax compliance services to help our clients meet their
                                 statutory obligations. We also advise on complex issues and recommend tax positions
                                 that contribute to tax certainty and efficiency.</p>
                         </div>
                     </div>

                     <div class="row mb--3 pt-5 align-items-center">
                         <div class="col-md-5">
                             <h3>Arbitration and Conciliation Act
                             </h3>
                             <p>ADR, or alternative dispute resolution, includes
                                 arbitration along with other well-known
                                 ADR procedures including conciliation and mediation. The Indian Arbitration and
                                 Conciliation Act governs arbitration in India.</p>
                             <p>AM Law Offices represents its customers in ADR and conducts
                                 both domestic and
                                 international arbitration cases before different boards in regards to all general and
                                 specialised repeating areas. The professionals at our law firm in India have the
                                 necessary skills to handle high stakes arbitration, including those involving supply
                                 agreements, developing and development agreements, and finished projects. We also spend
                                 a lot of time resolving business and commercial conflicts.</p>
                         </div>
                         <div class="col-md-5  offset-md-1">
                             <img src="img/expertise/Arbitration_Agreement.webp" alt="AM legal office">
                         </div>
                     </div>
                     <div class="row mb--3 pt-5 align-items-center">
                         <div class=" col-md-5">
                             <img src="img/expertise/prison-law.webp" alt="AM legal office">
                         </div>
                         <div class="col-md-5 offset-md-1">
                             <h3>Consumer and Banking matters
                             </h3>
                             <p>Our banking and finance services team is cognizant of this
                                 sectoral reality. Our banking
                                 and finance services team is aware of this industry reality and is skilled at handling
                                 a wide range of legal issues arising from borrower-lender relationships. To provide
                                 optimal solutions to our clients, our professionals specialize in anticipating
                                 financial vulnerabilities, geopolitical risks, and associated policy uncertainties.</p>
                         </div>
                     </div>
                     <div class="row mb--3 pt-5 align-items-center">
                         <div class="col-md-5">
                             <h3>Matrimonial Disputes
                             </h3>
                             <p>Adoption, divorce, and child custody are examples of legal
                                 issues relating family
                                 relationships that are addressed under family law. Divorce, child custody, child
                                 support, and other associated legal concerns are normally handled by family lawyers at
                                 AM Law Offices. Adoption, paternity, emancipation, and other family law issues are all
                                 areas of expertise for our family lawyers. States have the authority to establish
                                 "acceptable formal prerequisites" for marriage, such as the age and legal ability of
                                 the parties. </p>

                         </div>
                         <div class="col-md-5  offset-md-1">
                             <img src="img/expertise/family-courts.webp" alt="AM legal office">
                         </div>

                     </div>
                 </div>
             </section>

         </main>
         <?php include 'main-footer.php'; ?>
     </div>
     <script src="js/all.js"></script>
     <script>
         // Get the canvas element

         const ctx = document.getElementById('myDonutChart').getContext('2d');
         const dataValues = [15, 25, 60];
         // Create the donut chart
         const myDonutChart = new Chart(ctx, {
             type: 'doughnut', // Donut chart type
             data: {
                 labels: ['Consultation', 'Mediation', 'Practice'], // Labels for the data
                 datasets: [{
                     data: dataValues, // Values for the chart
                     backgroundColor: [
                         '#F7E7CE', // Colors for each section
                         '#E0CAA6',
                         '#6C6252'
                     ],
                     borderColor: [
                         '#E8D9C0', // Colors for each section
                         '#D2BA95',
                         '#5E5443'
                     ],
                     borderWidth: 1 // Border width of the segments
                 }]
             },
             options: {
                 responsive: true,
                 plugins: {
                     legend: {
                         position: 'top' // Position of the legend
                     },
                     tooltip: {
                         enabled: true // Enable tooltips
                     },
                     datalabels: {
                         formatter: (value, context) => {
                             // Calculate percentage
                             const total = context.dataset.data.reduce((acc, cur) => acc + cur, 0);
                             const percentage = ((value / total) * 100).toFixed(1) + '%';
                             return percentage; // Display percentage
                         },
                         color: '#fff', // Label color
                         font: {
                             weight: 'bold'
                         }
                     }
                 }
             }

         });
     </script>
 </body>

 </html>