<?php
// Start the PHP session if needed
session_start();
?>

<!DOCTYPE html>
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>AM Law Offices</title>
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Libre+Baskerville:ital,wght@0,400;0,700;1,400&amp;family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap"
        rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link media="all" rel="stylesheet" href="css/main.css">
    <style>
        /* Styles for the booking page */
        .back-link {
            display: inline-block;
            margin: 20px;
            color: #000;
            text-decoration: none;
        }

        .booking-details-section {
            padding: 20px;
            text-align: left;
        }

        .booking-content {
            display: flex;
            gap: 40px;
            margin-top: 20px;
        }

        .booking-form-section {
            flex: 1;
            border: 1px solid #ccc;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
        }

        .date-time-selection,
        .service-details {
            flex: 1;
            border: 1px solid #ccc;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
        }

        .service-details-content {
            padding: 20px;
        }

        .calendar-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-weight: bold;
        }

        .calendar {
            display: grid;
            grid-template-columns: repeat(7, 1fr);
            gap: 5px;
            margin-top: 10px;
        }

        .calendar-day {
            padding: 10px;
            text-align: center;
            cursor: pointer;
        }

        .calendar-day.selected {
            background-color: #8A784D;
            color: #fff;
        }

        .inactive {
            opacity: 0.5;
            /* Make inactive days slightly transparent */
            cursor: not-allowed;
            /* Change cursor to indicate they are not selectable */
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            /* Add light shadow */
        }

        .time-slots button {
            margin: 5px;
            padding: 10px;
            border: 1px solid #8A784D;
            background-color: #fff;
            color: #8A784D;
            cursor: pointer;
            border-radius: 4px;
        }

        .next-button {
            width: 200px;
            padding: 12px;
            background-color: #8A784D;
            color: white;
            border: none;
            cursor: pointer;
            border-radius: 4px;
            margin-top: 10px;
        }


        .email-button {
            display: block;
            width: 100%;
            padding: 12px;
            background-color: #8A784D;
            color: white;
            border: none;
            cursor: pointer;
            border-radius: 4px;
            margin-top: 10px;
        }

        input[type=text],
        input[type=email],
        input[type=number],
        input[type=message],
        select {
            width: 100%;
            padding: 12px 20px;
            margin: 8px 0;
            display: inline-block;
            border: 1px solid #ccc;
            border-radius: 4px;
            box-sizing: border-box;
        }

        textarea {
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        .service-details-2 {
            flex: 1;
            border: 1px solid #ccc;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
        }
       
        .service-details-2 h3 {
            font-size: 24px;
            color: #333333;
            text-align: center;
        }
        .service-details-2 p {
            font-size: 16px;
            color: #555555;
            margin: 10px 0;
        }
        .service-details-2 p strong {
            font-weight: 700;
            color: #333333;
        }
        .service-details-2 p span {
            display: block;
            margin-top: 5px;
            color: #777777;
        }

        #prev-month,
        #next-month {
            background: none;
            border: none;
            font-size: 28px;
            color: #8A784D;
        }

        .next-btn {
            margin-top: 20px;
            text-align: center;
        }
    </style>
</head>

<body>
    <div class="wrapper wrapper--offset-0">
        <?php include "main-header.php" ?>
        <main class="main">
            <section class="section-intro">
                <div class="container">
                    <h1>Legal Consultancy</h1>
                    <p>Check out our availability and book the date and time that works for you</p>
                </div>
                <div class="bg-stretch">
                    <img src="img/home/banner-3.jpg" alt="image description">
                </div>
            </section>
            <section class="section-breadcrumbs">
                <div class="container">
                    <ul class="breadcrumbs">
                        <li class="breadcrumbs__item"><a href="./index.php" class="breadcrumbs__link">Home</a></li>
                        <li class="breadcrumbs__item current">Legal Consultancy</li>
                    </ul>
                </div>
            </section>
            <section class="booking-details-section">
                <a href="#" class="back-link" id="back-button">&lt; Back</a>
                <div class="booking-content">
                    <div class="date-time-selection">
                        <h3>Select a Date and Time</h3>
                        <!-- Calendar Header -->
                        <div class="calendar-header">
                            <button id="prev-month">&lt;</button>
                            <span id="month-year"></span>
                            <button id="next-month">&gt;</button>
                        </div>
                        <!-- Calendar Container -->
                        <div class="calendar" id="calendar"></div>
                        <!-- Time Slots Container -->
                        <div class="time-slots" id="time-slots">
                            <p>Select a time slot:</p>
                        </div>
                    </div>
                    <div class="booking-form-section" id="booking-form" style="display: none;">
                        <h3>Appointment Form</h3>
                        <h5>Client Details</h5>
                        <form id="appointment-form" method="post">
                            <div class="form-group">
                                <label for="full-name">Full Name:</label>
                                <input type="text" id="full-name" name="full-name" required placeholder="Your name..">
                            </div>
                            <div class="form-group">
                                <label for="email">Email:</label>
                                <input type="email" id="email" name="email" required placeholder="Enter email..">
                            </div>
                            <div class="form-group">
                                <label for="contact">Contact No.:</label>
                                <input type="number" id="contact" name="contact" required
                                    placeholder="Enter contact number..">
                            </div>
                            <div class="form-group">
                                <label for="message">Add Your Message:</label>
                                <textarea id="message" name="message" rows="4"></textarea>
                            </div>
                            <input type="hidden" id="service-name" name="service-name" value="Legal Consultancy">
                            <input type="hidden" id="service-date" name="service-date">
                            <input type="hidden" id="service-time" name="service-time">
                            <input type="hidden" id="service-location" name="service-location" value="Vipul Khand 6">
                            <input type="hidden" id="service-consultant" name="service-consultant" value="ANAGH MISHRA">
                            <input type="hidden" id="service-duration" name="service-duration" value="1 hr 30 min">
                            <input type="hidden" id="service-price" name="service-price" value="₹10,000">
                            <button type="submit" name="send" class="email-button">Submit</button>
                        </form>
                    </div>

                    <div class="service-details-2">
                        <h3>Service Details</h3>
                        <p id="service-summary" class="service-details-content"><strong>Online Legal Consultancy</strong></p>
                        <p>Date: <span id="selected-date">Not selected</span></p>
                        <p>Time: <span id="selected-time">Not selected</span></p>
                        <p>Location: <span>Vipul Khand 6</span></p>
                        <p>Consultant: <span>ANAGH MISHRA</span></p>
                        <p>Duration: <span>1 hr 30 min</span></p>
                        <p>Price: <span>₹10,000</span></p>
                    </div>

                    <!-- <div class="service-details">
                        <h3>Service Details</h3>
                        <p id="service-summary" class="service-details-content">
                            <span><strong>Legal Consultancy</strong></span><br>
                            <span>Date: <span id="selected-date">Not selected</span></span><br>
                            <span>Time: <span id="selected-time">Not selected</span></span><br>
                            <span>Location: Vipul Khand 6</span> <br>
                            <span>Consultant: ANAGH MISHRA</span><br>
                            <span>Duration: 1 hr 30 min</span><br>
                            <span>Price: ₹10,000</span>
                        </p>

                    </div> -->
                </div>
                <div class="next-btn">
                    <button class="next-button">Next</button>
                </div>
                <button class="email-button" style="display: none;">Submit</button>
            </section>
        </main>
        <?php include 'main-footer.php'; ?>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const calendar = document.getElementById('calendar');
            const monthYearEl = document.getElementById('month-year');
            const prevMonthBtn = document.getElementById('prev-month');
            const nextMonthBtn = document.getElementById('next-month');
            const timeSlots = document.getElementById('time-slots');
            const selectedDateEl = document.getElementById('selected-date');
            const selectedTimeEl = document.getElementById('selected-time');

            let selectedDate = null;
            const daysOfWeek = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
            const months = [
                'January', 'February', 'March', 'April', 'May', 'June',
                'July', 'August', 'September', 'October', 'November', 'December'
            ];

            let currentDate = new Date();
            let currentMonth = currentDate.getMonth();
            let currentYear = currentDate.getFullYear();

            function updateMonthYear() {
                monthYearEl.textContent = `${months[currentMonth]} ${currentYear}`;
            }

            function generateCalendar(month, year) {
                calendar.innerHTML = '';
                updateMonthYear();

                const firstDay = new Date(year, month, 1).getDay();
                const daysInMonth = new Date(year, month + 1, 0).getDate();

                daysOfWeek.forEach(day => {
                    const dayLabel = document.createElement('div');
                    dayLabel.classList.add('calendar-day');
                    dayLabel.style.fontWeight = 'bold';
                    dayLabel.textContent = day;
                    calendar.appendChild(dayLabel);
                });

                for (let i = 0; i < firstDay; i++) {
                    calendar.innerHTML += `<div class="calendar-day inactive"></div>`;
                }

                for (let day = 1; day <= daysInMonth; day++) {
                    const dateDiv = document.createElement('div');
                    dateDiv.className = 'calendar-day';
                    dateDiv.innerText = day;

                    const thisDate = new Date(year, month, day);
                    const today = new Date();
                    today.setHours(0, 0, 0, 0);

                    if (thisDate < today) {
                        dateDiv.classList.add('inactive');
                        dateDiv.style.cursor = 'not-allowed';
                    } else {
                        dateDiv.addEventListener('click', () => {
                            document.querySelectorAll('.calendar-day').forEach(d => d.classList.remove('selected'));
                            dateDiv.classList.add('selected');
                            selectedDate = thisDate;
                            selectedDateEl.innerText = selectedDate.toDateString();
                            displayTimeSlots(selectedDate);
                        });
                    }

                    calendar.appendChild(dateDiv);
                }
            }

            function displayTimeSlots(date) {
                timeSlots.innerHTML = '<p>Select a time slot:</p>';

                const startHour = 10;
                const endHour = 16;
                const interval = 30;

                const now = new Date();

                for (let hour = startHour; hour <= endHour; hour++) {
                    for (let min = 0; min < 60; min += interval) {
                        const slot = new Date(date);
                        slot.setHours(hour, min, 0);

                        if (slot.toDateString() === now.toDateString() && slot <= now) continue;

                        if (hour === endHour && min > 0) break;

                        const slotBtn = document.createElement('button');
                        slotBtn.innerText = slot.toLocaleTimeString([], {
                            hour: '2-digit',
                            minute: '2-digit'
                        });

                        // Add the event listener for selecting a time slot
                        slotBtn.addEventListener('click', () => {
                            document.querySelectorAll('.time-slots button').forEach(b => b.classList.remove('selected'));
                            slotBtn.classList.add('selected');
                            selectedTimeEl.innerText = slotBtn.innerText;

                            // Set the hidden input value for service-time
                            document.getElementById('service-time').value = slotBtn.innerText;

                            // Ensure the date is set before submitting the form
                            if (selectedDate) {
                                document.getElementById('service-date').value = selectedDate.toDateString();
                            }
                        });

                        timeSlots.appendChild(slotBtn);
                    }
                }
            }

            prevMonthBtn.addEventListener('click', () => {
                currentMonth = currentMonth === 0 ? 11 : currentMonth - 1;
                currentYear = currentMonth === 11 ? currentYear - 1 : currentYear;
                generateCalendar(currentMonth, currentYear);
            });

            nextMonthBtn.addEventListener('click', () => {
                currentMonth = currentMonth === 11 ? 0 : currentMonth + 1;
                currentYear = currentMonth === 0 ? currentYear + 1 : currentYear;
                generateCalendar(currentMonth, currentYear);
            });

            generateCalendar(currentMonth, currentYear); // Generate calendar on page load
        });

        // Booking Form
        const nextButton = document.querySelector('.next-button');
        const emailButton = document.querySelector('.email-button');
        const bookingFormSection = document.getElementById('booking-form');
        const dateTimeSelection = document.querySelector('.date-time-selection');

        const backButton = document.getElementById('back-button');

        backButton.addEventListener('click', (event) => {
            event.preventDefault(); // Prevent the default link behavior
            bookingFormSection.style.display = 'none'; // Hide the booking form section
            dateTimeSelection.style.display = 'block'; // Show the date and time selection section
            nextButton.style.display = 'block'; // Show the next button again if needed
            emailButton.style.display = 'none';
        });

        nextButton.addEventListener('click', () => {

            dateTimeSelection.style.display = 'none';
            nextButton.style.display = 'none';
            bookingFormSection.style.display = 'block';
            emailButton.style.display = 'block';
        });


        emailButton.addEventListener('click', () => {
            const fullName = document.getElementById('full-name').value.trim();
            const email = document.getElementById('email').value.trim();
            const contact = document.getElementById('contact').value.trim();
            const serviceDate = document.getElementById('service-date').value.trim();
            const serviceTime = document.getElementById('service-time').value.trim();

            console.log('Full Name:', fullName);
            console.log('Email:', email);
            console.log('Contact:', contact);
            console.log('Service Date:', serviceDate);
            console.log('Service Time:', serviceTime);

            if (!fullName) {
                alert('Please enter your name.');
                return;
            }

            if (!email) {
                alert('Please enter your email.');
                return;
            }

            if (!contact) {
                alert('Please enter your contact number.');
                return;
            }

            if (!serviceDate || !serviceTime) {
                alert('Please select both date and time.');
                return;
            }

            // Populate the hidden form fields with selected values
            document.getElementById('service-date').value = serviceDate;
            document.getElementById('service-time').value = serviceTime;

            // Now submit the form
            document.getElementById('appointment-form').submit();
        });
        // Inside your displayTimeSlots function, when the slot is selected:
        slotBtn.addEventListener('click', () => {
            document.querySelectorAll('.time-slots button').forEach(b => b.classList.remove('selected'));
            slotBtn.classList.add('selected');
            selectedTimeEl.innerText = slotBtn.innerText;

            // Set the hidden input value for service-time
            document.getElementById('service-time').value = slotBtn.innerText;

            // Ensure the date is set before submitting the form
            if (selectedDate) {
                document.getElementById('service-date').value = selectedDate.toDateString();
            }
        });
    </script>

    <script src="js/all.js"></script>
</body>

</html>

<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['send'])) {
    $fullName = htmlspecialchars($_POST['full-name']);
    $email = htmlspecialchars($_POST['email']);
    $contact = htmlspecialchars($_POST['contact']);
    $message = htmlspecialchars($_POST['message']);

    // Collect service details
    $serviceName = htmlspecialchars($_POST['service-name']);
    $serviceDate = htmlspecialchars($_POST['service-date']);  // Getting the service date
    $serviceTime = htmlspecialchars($_POST['service-time']);  // Getting the service time  // Getting the service date
    $serviceLocation = htmlspecialchars($_POST['service-location']);
    $serviceConsultant = htmlspecialchars($_POST['service-consultant']);
    $serviceDuration = htmlspecialchars($_POST['service-duration']);
    $servicePrice = htmlspecialchars($_POST['service-price']);

    require './PHPMailer/Exception.php';
    require './PHPMailer/PHPMailer.php';
    require './PHPMailer/SMTP.php';

    $mail = new PHPMailer(true);

    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host = 'smtp.gmail.com';
        $mail->SMTPAuth = true;
        $mail->Username = "nitin2019it035abesit@gmail.com";  // Replace with your Gmail address
        $mail->Password = 'cvewhcanbrekhcvj';    // Replace with your Gmail App Password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port = 465;

        // Recipients
        $mail->setFrom('nitin2019it035abesit@gmail.com', 'Nitin');  // Replace with your email and name
        $mail->addAddress('nitsha1999n@gmail.com', 'Recipient Name'); // Replace with recipient email

        // Content
        $mail->isHTML(true);
        $mail->Subject = 'New Appointment Request';
        $mail->Body = "
                   <p><strong>Name:</strong> $fullName</p>
                   <p><strong>Email:</strong> $email</p>
                   <p><strong>Contact:</strong> $contact</p>
                   <p><strong>Message:</strong><br>$message</p>
                   <p><strong>Service Details:</strong></p>
                   <p><strong>Service Name:</strong> $serviceName</p>
                   <p><strong>Date:</strong> $serviceDate</p>
                   <p><strong>Time:</strong> $serviceTime</p>
                   <p><strong>Location:</strong> $serviceLocation</p>
                   <p><strong>Consultant:</strong> $serviceConsultant</p>
                   <p><strong>Duration:</strong> $serviceDuration</p>
                   <p><strong>Price:</strong> $servicePrice</p>";

        $mail->send();
        echo '<script>alert("Message has been sent successfully!"); window.location.href = "legal-consultancy.php";</script>';
    } catch (Exception $e) {
        echo "<script>alert('Message could not be sent. Mailer Error: {$mail->ErrorInfo}');</script>";
    }
}
?>