<!DOCTYPE html>
<html lang="en">
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
	<title>AM Law Team</title>
	<link rel="preconnect" href="https://fonts.googleapis.com/">
	<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
	<link
		href="https://fonts.googleapis.com/css2?family=Libre+Baskerville:ital,wght@0,400;0,700;1,400&amp;family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap"
		rel="stylesheet">
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
		integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
	<link media="all" rel="stylesheet" href="css/main.css">

</head>

<body>
	<div class="wrapper wrapper--offset-0">
		<?php include('main-header.php'); ?>
		<main class="main">
			<section class="section-intro">
				<div class="container">
					<h1>Our Lawyers</h1>
				</div>
				<div class="bg-stretch">
					<img src="img/home/banner-2-2.jpg" alt="image description">
				</div>
			</section>
			<section class="section-breadcrumbs">
				<div class="container">
					<ul class="breadcrumbs">
						<li class="breadcrumbs__item"><a href="#" class="breadcrumbs__link">Home</a></li>
						<li class="breadcrumbs__item current">Our Lawyers</li>
					</ul>
				</div>
			</section>
			<section class="section bg--light">
				<div class="container">
					<ul class="team team--col-6">
						<li class="team__item">
							<div class="team-tile">
								<div class="team-tile__img">
									<img src="img/official-image/founder-2.jpg" alt="image description">
									<ul class="social">
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="14" viewBox="0 0 15 14">
													<path
														d="M11.8133 0H14.1133L9.08845 5.74336L15 13.5586H10.3712L6.74593 8.81856L2.59772 13.5586H0.296162L5.67082 7.41551L0 0H4.74606L8.0231 4.33242L11.8133 0ZM11.006 12.1818H12.2806L4.0536 1.3045H2.68603L11.006 12.1818Z" />
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="10" height="16" viewBox="0 0 15 24">
													<path
														d="M13.0836 13.5L13.7492 9.15469H9.58203V6.3375C9.58203 5.14687 10.1633 3.98906 12.0289 3.98906H13.9227V0.295313C13.9227 0.295313 12.207 0 10.5664 0C7.13516 0 4.88984 2.08125 4.88984 5.84531V9.15469H1.07422V13.5H4.88984V24H9.58672V13.5H13.0836Z" />
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="15" viewBox="0 0 12 12">
													<path
														d="M2.68661 12H0.198214V3.98839H2.68661V12ZM1.44107 2.89554C0.645536 2.89554 0 2.23661 0 1.44107C0 1.05888 0.151827 0.692333 0.42208 0.42208C0.692333 0.151827 1.05888 0 1.44107 0C1.82327 0 2.18981 0.151827 2.46006 0.42208C2.73032 0.692333 2.88214 1.05888 2.88214 1.44107C2.88214 2.23661 2.23661 2.89554 1.44107 2.89554ZM11.9973 12H9.51429V8.1C9.51429 7.17054 9.49554 5.97857 8.22054 5.97857C6.92679 5.97857 6.72857 6.98839 6.72857 8.03304V12H4.24286V3.98839H6.62946V5.08125H6.66429C6.99643 4.45179 7.80804 3.7875 9.01875 3.7875C11.5366 3.7875 12 5.44554 12 7.59911V12H11.9973Z" />
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="16" viewBox="0 0 15 16">
													<path
														d="M7.42745 4.47857C5.29918 4.47857 3.5825 6.19525 3.5825 8.32352C3.5825 10.4518 5.29918 12.1685 7.42745 12.1685C9.55573 12.1685 11.2724 10.4518 11.2724 8.32352C11.2724 6.19525 9.55573 4.47857 7.42745 4.47857ZM7.42745 10.8232C6.05211 10.8232 4.92773 9.70222 4.92773 8.32352C4.92773 6.94483 6.04876 5.8238 7.42745 5.8238C8.80615 5.8238 9.92718 6.94483 9.92718 8.32352C9.92718 9.70222 8.8028 10.8232 7.42745 10.8232ZM12.3265 4.32129C12.3265 4.8199 11.9249 5.21811 11.4297 5.21811C10.9311 5.21811 10.5329 4.81655 10.5329 4.32129C10.5329 3.82603 10.9344 3.42447 11.4297 3.42447C11.9249 3.42447 12.3265 3.82603 12.3265 4.32129ZM14.8731 5.2315C14.8162 4.03016 14.5418 2.96602 13.6617 2.08928C12.785 1.21253 11.7208 0.938135 10.5195 0.8779C9.28133 0.807627 5.57023 0.807627 4.33208 0.8779C3.13409 0.934788 2.06995 1.20919 1.18986 2.08593C0.309775 2.96267 0.0387205 4.02681 -0.0215138 5.22815C-0.0917871 6.4663 -0.0917871 10.1774 -0.0215138 11.4155C0.0353741 12.6169 0.309775 13.681 1.18986 14.5578C2.06995 15.4345 3.13075 15.7089 4.33208 15.7691C5.57023 15.8394 9.28133 15.8394 10.5195 15.7691C11.7208 15.7123 12.785 15.4379 13.6617 14.5578C14.5384 13.681 14.8128 12.6169 14.8731 11.4155C14.9434 10.1774 14.9434 6.46965 14.8731 5.2315ZM13.2735 12.744C13.0125 13.3999 12.5072 13.9052 11.848 14.1696C10.8608 14.5611 8.51836 14.4708 7.42745 14.4708C6.33655 14.4708 3.99076 14.5578 3.00693 14.1696C2.35105 13.9086 1.84575 13.4033 1.58139 12.744C1.18986 11.7569 1.28022 9.41443 1.28022 8.32352C1.28022 7.23261 1.19321 4.88682 1.58139 3.903C1.8424 3.24711 2.3477 2.74182 3.00693 2.47745C3.9941 2.08593 6.33655 2.17628 7.42745 2.17628C8.51836 2.17628 10.8642 2.08928 11.848 2.47745C12.5039 2.73847 13.0092 3.24377 13.2735 3.903C13.665 4.89017 13.5747 7.23261 13.5747 8.32352C13.5747 9.41443 13.665 11.7602 13.2735 12.744Z" />
												</svg>
											</a>
										</li>
									</ul>
								</div>
								<div class="team-tile__content">
									<h3 class="team-title">Anagh Mishra</h3>
									<strong class="team-position">Founding Partner</strong>
									<ul class="contact-info top--line">
										<li class="contact-info__item">
											<span class="contact-info__text">Mail</span>
											<a class="contact-info__link"
												href="mailto:peter@example.com">amlegaloffices@gmail.com</a>
										</li>
										<li class="contact-info__item">
											<span class="contact-info__text">Contact</span>
											<a class="contact-info__link" href="tel:8002369590">+91 7905243300</a>
										</li>
									</ul>
								</div>
							</div>
						</li>
						<li class="team__item">
							<div class="team-tile">
								<div class="team-tile__img">
									<img src="img/team/associate.jpg" alt="image description">
									<ul class="social">
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="14" viewBox="0 0 15 14">
													<path
														d="M11.8133 0H14.1133L9.08845 5.74336L15 13.5586H10.3712L6.74593 8.81856L2.59772 13.5586H0.296162L5.67082 7.41551L0 0H4.74606L8.0231 4.33242L11.8133 0ZM11.006 12.1818H12.2806L4.0536 1.3045H2.68603L11.006 12.1818Z" />
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="10" height="16" viewBox="0 0 15 24">
													<path
														d="M13.0836 13.5L13.7492 9.15469H9.58203V6.3375C9.58203 5.14687 10.1633 3.98906 12.0289 3.98906H13.9227V0.295313C13.9227 0.295313 12.207 0 10.5664 0C7.13516 0 4.88984 2.08125 4.88984 5.84531V9.15469H1.07422V13.5H4.88984V24H9.58672V13.5H13.0836Z" />
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="15" viewBox="0 0 12 12">
													<path
														d="M2.68661 12H0.198214V3.98839H2.68661V12ZM1.44107 2.89554C0.645536 2.89554 0 2.23661 0 1.44107C0 1.05888 0.151827 0.692333 0.42208 0.42208C0.692333 0.151827 1.05888 0 1.44107 0C1.82327 0 2.18981 0.151827 2.46006 0.42208C2.73032 0.692333 2.88214 1.05888 2.88214 1.44107C2.88214 2.23661 2.23661 2.89554 1.44107 2.89554ZM11.9973 12H9.51429V8.1C9.51429 7.17054 9.49554 5.97857 8.22054 5.97857C6.92679 5.97857 6.72857 6.98839 6.72857 8.03304V12H4.24286V3.98839H6.62946V5.08125H6.66429C6.99643 4.45179 7.80804 3.7875 9.01875 3.7875C11.5366 3.7875 12 5.44554 12 7.59911V12H11.9973Z" />
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="16" viewBox="0 0 15 16">
													<path
														d="M7.42745 4.47857C5.29918 4.47857 3.5825 6.19525 3.5825 8.32352C3.5825 10.4518 5.29918 12.1685 7.42745 12.1685C9.55573 12.1685 11.2724 10.4518 11.2724 8.32352C11.2724 6.19525 9.55573 4.47857 7.42745 4.47857ZM7.42745 10.8232C6.05211 10.8232 4.92773 9.70222 4.92773 8.32352C4.92773 6.94483 6.04876 5.8238 7.42745 5.8238C8.80615 5.8238 9.92718 6.94483 9.92718 8.32352C9.92718 9.70222 8.8028 10.8232 7.42745 10.8232ZM12.3265 4.32129C12.3265 4.8199 11.9249 5.21811 11.4297 5.21811C10.9311 5.21811 10.5329 4.81655 10.5329 4.32129C10.5329 3.82603 10.9344 3.42447 11.4297 3.42447C11.9249 3.42447 12.3265 3.82603 12.3265 4.32129ZM14.8731 5.2315C14.8162 4.03016 14.5418 2.96602 13.6617 2.08928C12.785 1.21253 11.7208 0.938135 10.5195 0.8779C9.28133 0.807627 5.57023 0.807627 4.33208 0.8779C3.13409 0.934788 2.06995 1.20919 1.18986 2.08593C0.309775 2.96267 0.0387205 4.02681 -0.0215138 5.22815C-0.0917871 6.4663 -0.0917871 10.1774 -0.0215138 11.4155C0.0353741 12.6169 0.309775 13.681 1.18986 14.5578C2.06995 15.4345 3.13075 15.7089 4.33208 15.7691C5.57023 15.8394 9.28133 15.8394 10.5195 15.7691C11.7208 15.7123 12.785 15.4379 13.6617 14.5578C14.5384 13.681 14.8128 12.6169 14.8731 11.4155C14.9434 10.1774 14.9434 6.46965 14.8731 5.2315ZM13.2735 12.744C13.0125 13.3999 12.5072 13.9052 11.848 14.1696C10.8608 14.5611 8.51836 14.4708 7.42745 14.4708C6.33655 14.4708 3.99076 14.5578 3.00693 14.1696C2.35105 13.9086 1.84575 13.4033 1.58139 12.744C1.18986 11.7569 1.28022 9.41443 1.28022 8.32352C1.28022 7.23261 1.19321 4.88682 1.58139 3.903C1.8424 3.24711 2.3477 2.74182 3.00693 2.47745C3.9941 2.08593 6.33655 2.17628 7.42745 2.17628C8.51836 2.17628 10.8642 2.08928 11.848 2.47745C12.5039 2.73847 13.0092 3.24377 13.2735 3.903C13.665 4.89017 13.5747 7.23261 13.5747 8.32352C13.5747 9.41443 13.665 11.7602 13.2735 12.744Z" />
												</svg>
											</a>
										</li>
									</ul>
								</div>
								<div class="team-tile__content">
									<h3 class="team-title">
										<!-- <a href="kevin-m-johnson.html">Kevin M. Johnson</a> -->
										Manoj Kumar
									</h3>
									<strong class="team-position">Associate</strong>
									<ul class="contact-info top--line">
										<!-- <li class="contact-info__item">
											<span class="contact-info__text">Mail</span>
											<a class="contact-info__link" href="mailto:kevin@example.com">kevin@example.com</a>
										</li> -->
										<li class="contact-info__item">
											<span class="contact-info__text">Contact</span>
											<a class="contact-info__link" href="tel:8004367810">+91 7084286666</a>
										</li>
									</ul>
								</div>
							</div>
						</li>
						<li class="team__item">
							<div class="team-tile">
								<div class="team-tile__img">
									<img src="img/team/luv.png" alt="image description">
									<ul class="social">
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="14" viewBox="0 0 15 14">
													<path
														d="M11.8133 0H14.1133L9.08845 5.74336L15 13.5586H10.3712L6.74593 8.81856L2.59772 13.5586H0.296162L5.67082 7.41551L0 0H4.74606L8.0231 4.33242L11.8133 0ZM11.006 12.1818H12.2806L4.0536 1.3045H2.68603L11.006 12.1818Z" />
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="10" height="16" viewBox="0 0 15 24">
													<path
														d="M13.0836 13.5L13.7492 9.15469H9.58203V6.3375C9.58203 5.14687 10.1633 3.98906 12.0289 3.98906H13.9227V0.295313C13.9227 0.295313 12.207 0 10.5664 0C7.13516 0 4.88984 2.08125 4.88984 5.84531V9.15469H1.07422V13.5H4.88984V24H9.58672V13.5H13.0836Z" />
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="15" viewBox="0 0 12 12">
													<path
														d="M2.68661 12H0.198214V3.98839H2.68661V12ZM1.44107 2.89554C0.645536 2.89554 0 2.23661 0 1.44107C0 1.05888 0.151827 0.692333 0.42208 0.42208C0.692333 0.151827 1.05888 0 1.44107 0C1.82327 0 2.18981 0.151827 2.46006 0.42208C2.73032 0.692333 2.88214 1.05888 2.88214 1.44107C2.88214 2.23661 2.23661 2.89554 1.44107 2.89554ZM11.9973 12H9.51429V8.1C9.51429 7.17054 9.49554 5.97857 8.22054 5.97857C6.92679 5.97857 6.72857 6.98839 6.72857 8.03304V12H4.24286V3.98839H6.62946V5.08125H6.66429C6.99643 4.45179 7.80804 3.7875 9.01875 3.7875C11.5366 3.7875 12 5.44554 12 7.59911V12H11.9973Z" />
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="16" viewBox="0 0 15 16">
													<path
														d="M7.42745 4.47857C5.29918 4.47857 3.5825 6.19525 3.5825 8.32352C3.5825 10.4518 5.29918 12.1685 7.42745 12.1685C9.55573 12.1685 11.2724 10.4518 11.2724 8.32352C11.2724 6.19525 9.55573 4.47857 7.42745 4.47857ZM7.42745 10.8232C6.05211 10.8232 4.92773 9.70222 4.92773 8.32352C4.92773 6.94483 6.04876 5.8238 7.42745 5.8238C8.80615 5.8238 9.92718 6.94483 9.92718 8.32352C9.92718 9.70222 8.8028 10.8232 7.42745 10.8232ZM12.3265 4.32129C12.3265 4.8199 11.9249 5.21811 11.4297 5.21811C10.9311 5.21811 10.5329 4.81655 10.5329 4.32129C10.5329 3.82603 10.9344 3.42447 11.4297 3.42447C11.9249 3.42447 12.3265 3.82603 12.3265 4.32129ZM14.8731 5.2315C14.8162 4.03016 14.5418 2.96602 13.6617 2.08928C12.785 1.21253 11.7208 0.938135 10.5195 0.8779C9.28133 0.807627 5.57023 0.807627 4.33208 0.8779C3.13409 0.934788 2.06995 1.20919 1.18986 2.08593C0.309775 2.96267 0.0387205 4.02681 -0.0215138 5.22815C-0.0917871 6.4663 -0.0917871 10.1774 -0.0215138 11.4155C0.0353741 12.6169 0.309775 13.681 1.18986 14.5578C2.06995 15.4345 3.13075 15.7089 4.33208 15.7691C5.57023 15.8394 9.28133 15.8394 10.5195 15.7691C11.7208 15.7123 12.785 15.4379 13.6617 14.5578C14.5384 13.681 14.8128 12.6169 14.8731 11.4155C14.9434 10.1774 14.9434 6.46965 14.8731 5.2315ZM13.2735 12.744C13.0125 13.3999 12.5072 13.9052 11.848 14.1696C10.8608 14.5611 8.51836 14.4708 7.42745 14.4708C6.33655 14.4708 3.99076 14.5578 3.00693 14.1696C2.35105 13.9086 1.84575 13.4033 1.58139 12.744C1.18986 11.7569 1.28022 9.41443 1.28022 8.32352C1.28022 7.23261 1.19321 4.88682 1.58139 3.903C1.8424 3.24711 2.3477 2.74182 3.00693 2.47745C3.9941 2.08593 6.33655 2.17628 7.42745 2.17628C8.51836 2.17628 10.8642 2.08928 11.848 2.47745C12.5039 2.73847 13.0092 3.24377 13.2735 3.903C13.665 4.89017 13.5747 7.23261 13.5747 8.32352C13.5747 9.41443 13.665 11.7602 13.2735 12.744Z" />
												</svg>
											</a>
										</li>
									</ul>
								</div>
								<div class="team-tile__content">
									<!-- <h3 class="team-title"><a href="kevin-m-johnson.html">Mary Jane</a></h3> -->
									<h3 class="team-title">Luv Singh</h3>
									<strong class="team-position">Associate</strong>
									<ul class="contact-info top--line">
										<li class="contact-info__item">
											<span class="contact-info__text">Mail</span>
											<a class="contact-info__link"
												href="mailto:mary@example.com">singhluv01@gmail.com</a>
										</li>
										<li class="contact-info__item">
											<span class="contact-info__text">Contact</span>
											<a class="contact-info__link" href="tel:8004568790">+91 8318078196</a>
										</li>
									</ul>
								</div>
							</div>
						</li>
						<!-- <li class="team__item">
							<div class="team-tile">
								<div class="team-tile__img">
									<img src="img/image-45-1200x1200.jpg" alt="image description">
									<ul class="social">
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="14" viewBox="0 0 15 14">
													<path d="M11.8133 0H14.1133L9.08845 5.74336L15 13.5586H10.3712L6.74593 8.81856L2.59772 13.5586H0.296162L5.67082 7.41551L0 0H4.74606L8.0231 4.33242L11.8133 0ZM11.006 12.1818H12.2806L4.0536 1.3045H2.68603L11.006 12.1818Z"/>
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="10" height="16" viewBox="0 0 15 24">
													<path d="M13.0836 13.5L13.7492 9.15469H9.58203V6.3375C9.58203 5.14687 10.1633 3.98906 12.0289 3.98906H13.9227V0.295313C13.9227 0.295313 12.207 0 10.5664 0C7.13516 0 4.88984 2.08125 4.88984 5.84531V9.15469H1.07422V13.5H4.88984V24H9.58672V13.5H13.0836Z"/>
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="15" viewBox="0 0 12 12">
													<path d="M2.68661 12H0.198214V3.98839H2.68661V12ZM1.44107 2.89554C0.645536 2.89554 0 2.23661 0 1.44107C0 1.05888 0.151827 0.692333 0.42208 0.42208C0.692333 0.151827 1.05888 0 1.44107 0C1.82327 0 2.18981 0.151827 2.46006 0.42208C2.73032 0.692333 2.88214 1.05888 2.88214 1.44107C2.88214 2.23661 2.23661 2.89554 1.44107 2.89554ZM11.9973 12H9.51429V8.1C9.51429 7.17054 9.49554 5.97857 8.22054 5.97857C6.92679 5.97857 6.72857 6.98839 6.72857 8.03304V12H4.24286V3.98839H6.62946V5.08125H6.66429C6.99643 4.45179 7.80804 3.7875 9.01875 3.7875C11.5366 3.7875 12 5.44554 12 7.59911V12H11.9973Z"/>
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="16" viewBox="0 0 15 16">
													<path d="M7.42745 4.47857C5.29918 4.47857 3.5825 6.19525 3.5825 8.32352C3.5825 10.4518 5.29918 12.1685 7.42745 12.1685C9.55573 12.1685 11.2724 10.4518 11.2724 8.32352C11.2724 6.19525 9.55573 4.47857 7.42745 4.47857ZM7.42745 10.8232C6.05211 10.8232 4.92773 9.70222 4.92773 8.32352C4.92773 6.94483 6.04876 5.8238 7.42745 5.8238C8.80615 5.8238 9.92718 6.94483 9.92718 8.32352C9.92718 9.70222 8.8028 10.8232 7.42745 10.8232ZM12.3265 4.32129C12.3265 4.8199 11.9249 5.21811 11.4297 5.21811C10.9311 5.21811 10.5329 4.81655 10.5329 4.32129C10.5329 3.82603 10.9344 3.42447 11.4297 3.42447C11.9249 3.42447 12.3265 3.82603 12.3265 4.32129ZM14.8731 5.2315C14.8162 4.03016 14.5418 2.96602 13.6617 2.08928C12.785 1.21253 11.7208 0.938135 10.5195 0.8779C9.28133 0.807627 5.57023 0.807627 4.33208 0.8779C3.13409 0.934788 2.06995 1.20919 1.18986 2.08593C0.309775 2.96267 0.0387205 4.02681 -0.0215138 5.22815C-0.0917871 6.4663 -0.0917871 10.1774 -0.0215138 11.4155C0.0353741 12.6169 0.309775 13.681 1.18986 14.5578C2.06995 15.4345 3.13075 15.7089 4.33208 15.7691C5.57023 15.8394 9.28133 15.8394 10.5195 15.7691C11.7208 15.7123 12.785 15.4379 13.6617 14.5578C14.5384 13.681 14.8128 12.6169 14.8731 11.4155C14.9434 10.1774 14.9434 6.46965 14.8731 5.2315ZM13.2735 12.744C13.0125 13.3999 12.5072 13.9052 11.848 14.1696C10.8608 14.5611 8.51836 14.4708 7.42745 14.4708C6.33655 14.4708 3.99076 14.5578 3.00693 14.1696C2.35105 13.9086 1.84575 13.4033 1.58139 12.744C1.18986 11.7569 1.28022 9.41443 1.28022 8.32352C1.28022 7.23261 1.19321 4.88682 1.58139 3.903C1.8424 3.24711 2.3477 2.74182 3.00693 2.47745C3.9941 2.08593 6.33655 2.17628 7.42745 2.17628C8.51836 2.17628 10.8642 2.08928 11.848 2.47745C12.5039 2.73847 13.0092 3.24377 13.2735 3.903C13.665 4.89017 13.5747 7.23261 13.5747 8.32352C13.5747 9.41443 13.665 11.7602 13.2735 12.744Z"/>
												</svg>
											</a>
										</li>
									</ul>
								</div>
								<div class="team-tile__content">
									<h3 class="team-title"><a href="kevin-m-johnson.html">Tyler S. Jackson</a></h3>
									<strong class="team-position">Corporate Lawyer, SF, CA</strong>
									<ul class="contact-info top--line">
										<li class="contact-info__item">
											<span class="contact-info__text">Mail</span>
											<a class="contact-info__link" href="mailto:tyler@example.com">tyler@example.com</a>
										</li>
										<li class="contact-info__item">
											<span class="contact-info__text">Tel</span>
											<a class="contact-info__link" href="tel:8003768790">800 376 8790</a>
										</li>
									</ul>
								</div>
							</div>
						</li>
						<li class="team__item">
							<div class="team-tile">
								<div class="team-tile__img">
									<img src="img/image-42-1200x1200.jpg" alt="image description">
									<ul class="social">
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="14" viewBox="0 0 15 14">
													<path d="M11.8133 0H14.1133L9.08845 5.74336L15 13.5586H10.3712L6.74593 8.81856L2.59772 13.5586H0.296162L5.67082 7.41551L0 0H4.74606L8.0231 4.33242L11.8133 0ZM11.006 12.1818H12.2806L4.0536 1.3045H2.68603L11.006 12.1818Z"/>
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="10" height="16" viewBox="0 0 15 24">
													<path d="M13.0836 13.5L13.7492 9.15469H9.58203V6.3375C9.58203 5.14687 10.1633 3.98906 12.0289 3.98906H13.9227V0.295313C13.9227 0.295313 12.207 0 10.5664 0C7.13516 0 4.88984 2.08125 4.88984 5.84531V9.15469H1.07422V13.5H4.88984V24H9.58672V13.5H13.0836Z"/>
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="15" viewBox="0 0 12 12">
													<path d="M2.68661 12H0.198214V3.98839H2.68661V12ZM1.44107 2.89554C0.645536 2.89554 0 2.23661 0 1.44107C0 1.05888 0.151827 0.692333 0.42208 0.42208C0.692333 0.151827 1.05888 0 1.44107 0C1.82327 0 2.18981 0.151827 2.46006 0.42208C2.73032 0.692333 2.88214 1.05888 2.88214 1.44107C2.88214 2.23661 2.23661 2.89554 1.44107 2.89554ZM11.9973 12H9.51429V8.1C9.51429 7.17054 9.49554 5.97857 8.22054 5.97857C6.92679 5.97857 6.72857 6.98839 6.72857 8.03304V12H4.24286V3.98839H6.62946V5.08125H6.66429C6.99643 4.45179 7.80804 3.7875 9.01875 3.7875C11.5366 3.7875 12 5.44554 12 7.59911V12H11.9973Z"/>
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="16" viewBox="0 0 15 16">
													<path d="M7.42745 4.47857C5.29918 4.47857 3.5825 6.19525 3.5825 8.32352C3.5825 10.4518 5.29918 12.1685 7.42745 12.1685C9.55573 12.1685 11.2724 10.4518 11.2724 8.32352C11.2724 6.19525 9.55573 4.47857 7.42745 4.47857ZM7.42745 10.8232C6.05211 10.8232 4.92773 9.70222 4.92773 8.32352C4.92773 6.94483 6.04876 5.8238 7.42745 5.8238C8.80615 5.8238 9.92718 6.94483 9.92718 8.32352C9.92718 9.70222 8.8028 10.8232 7.42745 10.8232ZM12.3265 4.32129C12.3265 4.8199 11.9249 5.21811 11.4297 5.21811C10.9311 5.21811 10.5329 4.81655 10.5329 4.32129C10.5329 3.82603 10.9344 3.42447 11.4297 3.42447C11.9249 3.42447 12.3265 3.82603 12.3265 4.32129ZM14.8731 5.2315C14.8162 4.03016 14.5418 2.96602 13.6617 2.08928C12.785 1.21253 11.7208 0.938135 10.5195 0.8779C9.28133 0.807627 5.57023 0.807627 4.33208 0.8779C3.13409 0.934788 2.06995 1.20919 1.18986 2.08593C0.309775 2.96267 0.0387205 4.02681 -0.0215138 5.22815C-0.0917871 6.4663 -0.0917871 10.1774 -0.0215138 11.4155C0.0353741 12.6169 0.309775 13.681 1.18986 14.5578C2.06995 15.4345 3.13075 15.7089 4.33208 15.7691C5.57023 15.8394 9.28133 15.8394 10.5195 15.7691C11.7208 15.7123 12.785 15.4379 13.6617 14.5578C14.5384 13.681 14.8128 12.6169 14.8731 11.4155C14.9434 10.1774 14.9434 6.46965 14.8731 5.2315ZM13.2735 12.744C13.0125 13.3999 12.5072 13.9052 11.848 14.1696C10.8608 14.5611 8.51836 14.4708 7.42745 14.4708C6.33655 14.4708 3.99076 14.5578 3.00693 14.1696C2.35105 13.9086 1.84575 13.4033 1.58139 12.744C1.18986 11.7569 1.28022 9.41443 1.28022 8.32352C1.28022 7.23261 1.19321 4.88682 1.58139 3.903C1.8424 3.24711 2.3477 2.74182 3.00693 2.47745C3.9941 2.08593 6.33655 2.17628 7.42745 2.17628C8.51836 2.17628 10.8642 2.08928 11.848 2.47745C12.5039 2.73847 13.0092 3.24377 13.2735 3.903C13.665 4.89017 13.5747 7.23261 13.5747 8.32352C13.5747 9.41443 13.665 11.7602 13.2735 12.744Z"/>
												</svg>
											</a>
										</li>
									</ul>
								</div>
								<div class="team-tile__content">
									<h3 class="team-title"><a href="kevin-m-johnson.html">Maria Gonsales</a></h3>
									<strong class="team-position">Senior Attorney, NY, NY</strong>
									<ul class="contact-info top--line">
										<li class="contact-info__item">
											<span class="contact-info__text">Mail</span>
											<a class="contact-info__link" href="mailto:maria@example.com">maria@example.com</a>
										</li>
										<li class="contact-info__item">
											<span class="contact-info__text">Tel</span>
											<a class="contact-info__link" href="tel:8005569890">800 556 9890</a>
										</li>
									</ul>
								</div>
							</div>
						</li>
						<li class="team__item">
							<div class="team-tile">
								<div class="team-tile__img">
									<img src="img/law-5-1200x1200.jpg" alt="image description">
									<ul class="social">
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="14" viewBox="0 0 15 14">
													<path d="M11.8133 0H14.1133L9.08845 5.74336L15 13.5586H10.3712L6.74593 8.81856L2.59772 13.5586H0.296162L5.67082 7.41551L0 0H4.74606L8.0231 4.33242L11.8133 0ZM11.006 12.1818H12.2806L4.0536 1.3045H2.68603L11.006 12.1818Z"/>
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="10" height="16" viewBox="0 0 15 24">
													<path d="M13.0836 13.5L13.7492 9.15469H9.58203V6.3375C9.58203 5.14687 10.1633 3.98906 12.0289 3.98906H13.9227V0.295313C13.9227 0.295313 12.207 0 10.5664 0C7.13516 0 4.88984 2.08125 4.88984 5.84531V9.15469H1.07422V13.5H4.88984V24H9.58672V13.5H13.0836Z"/>
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="15" viewBox="0 0 12 12">
													<path d="M2.68661 12H0.198214V3.98839H2.68661V12ZM1.44107 2.89554C0.645536 2.89554 0 2.23661 0 1.44107C0 1.05888 0.151827 0.692333 0.42208 0.42208C0.692333 0.151827 1.05888 0 1.44107 0C1.82327 0 2.18981 0.151827 2.46006 0.42208C2.73032 0.692333 2.88214 1.05888 2.88214 1.44107C2.88214 2.23661 2.23661 2.89554 1.44107 2.89554ZM11.9973 12H9.51429V8.1C9.51429 7.17054 9.49554 5.97857 8.22054 5.97857C6.92679 5.97857 6.72857 6.98839 6.72857 8.03304V12H4.24286V3.98839H6.62946V5.08125H6.66429C6.99643 4.45179 7.80804 3.7875 9.01875 3.7875C11.5366 3.7875 12 5.44554 12 7.59911V12H11.9973Z"/>
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="16" viewBox="0 0 15 16">
													<path d="M7.42745 4.47857C5.29918 4.47857 3.5825 6.19525 3.5825 8.32352C3.5825 10.4518 5.29918 12.1685 7.42745 12.1685C9.55573 12.1685 11.2724 10.4518 11.2724 8.32352C11.2724 6.19525 9.55573 4.47857 7.42745 4.47857ZM7.42745 10.8232C6.05211 10.8232 4.92773 9.70222 4.92773 8.32352C4.92773 6.94483 6.04876 5.8238 7.42745 5.8238C8.80615 5.8238 9.92718 6.94483 9.92718 8.32352C9.92718 9.70222 8.8028 10.8232 7.42745 10.8232ZM12.3265 4.32129C12.3265 4.8199 11.9249 5.21811 11.4297 5.21811C10.9311 5.21811 10.5329 4.81655 10.5329 4.32129C10.5329 3.82603 10.9344 3.42447 11.4297 3.42447C11.9249 3.42447 12.3265 3.82603 12.3265 4.32129ZM14.8731 5.2315C14.8162 4.03016 14.5418 2.96602 13.6617 2.08928C12.785 1.21253 11.7208 0.938135 10.5195 0.8779C9.28133 0.807627 5.57023 0.807627 4.33208 0.8779C3.13409 0.934788 2.06995 1.20919 1.18986 2.08593C0.309775 2.96267 0.0387205 4.02681 -0.0215138 5.22815C-0.0917871 6.4663 -0.0917871 10.1774 -0.0215138 11.4155C0.0353741 12.6169 0.309775 13.681 1.18986 14.5578C2.06995 15.4345 3.13075 15.7089 4.33208 15.7691C5.57023 15.8394 9.28133 15.8394 10.5195 15.7691C11.7208 15.7123 12.785 15.4379 13.6617 14.5578C14.5384 13.681 14.8128 12.6169 14.8731 11.4155C14.9434 10.1774 14.9434 6.46965 14.8731 5.2315ZM13.2735 12.744C13.0125 13.3999 12.5072 13.9052 11.848 14.1696C10.8608 14.5611 8.51836 14.4708 7.42745 14.4708C6.33655 14.4708 3.99076 14.5578 3.00693 14.1696C2.35105 13.9086 1.84575 13.4033 1.58139 12.744C1.18986 11.7569 1.28022 9.41443 1.28022 8.32352C1.28022 7.23261 1.19321 4.88682 1.58139 3.903C1.8424 3.24711 2.3477 2.74182 3.00693 2.47745C3.9941 2.08593 6.33655 2.17628 7.42745 2.17628C8.51836 2.17628 10.8642 2.08928 11.848 2.47745C12.5039 2.73847 13.0092 3.24377 13.2735 3.903C13.665 4.89017 13.5747 7.23261 13.5747 8.32352C13.5747 9.41443 13.665 11.7602 13.2735 12.744Z"/>
												</svg>
											</a>
										</li>
									</ul>
								</div>
								<div class="team-tile__content">
									<h3 class="team-title"><a href="kevin-m-johnson.html">Linda Meek</a></h3>
									<strong class="team-position">Senior Attorney, NY, NY</strong>
									<ul class="contact-info top--line">
										<li class="contact-info__item">
											<span class="contact-info__text">Mail</span>
											<a class="contact-info__link" href="mailto:linda@example.com">linda@example.com</a>
										</li>
										<li class="contact-info__item">
											<span class="contact-info__text">Tel</span>
											<a class="contact-info__link" href="tel:8005569890">800 556 9890</a>
										</li>
									</ul>
								</div>
							</div>
						</li>
						<li class="team__item">
							<div class="team-tile">
								<div class="team-tile__img">
									<img src="img/law-7-1200x1200.jpg" alt="image description">
									<ul class="social">
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="14" viewBox="0 0 15 14">
													<path d="M11.8133 0H14.1133L9.08845 5.74336L15 13.5586H10.3712L6.74593 8.81856L2.59772 13.5586H0.296162L5.67082 7.41551L0 0H4.74606L8.0231 4.33242L11.8133 0ZM11.006 12.1818H12.2806L4.0536 1.3045H2.68603L11.006 12.1818Z"/>
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="10" height="16" viewBox="0 0 15 24">
													<path d="M13.0836 13.5L13.7492 9.15469H9.58203V6.3375C9.58203 5.14687 10.1633 3.98906 12.0289 3.98906H13.9227V0.295313C13.9227 0.295313 12.207 0 10.5664 0C7.13516 0 4.88984 2.08125 4.88984 5.84531V9.15469H1.07422V13.5H4.88984V24H9.58672V13.5H13.0836Z"/>
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="15" viewBox="0 0 12 12">
													<path d="M2.68661 12H0.198214V3.98839H2.68661V12ZM1.44107 2.89554C0.645536 2.89554 0 2.23661 0 1.44107C0 1.05888 0.151827 0.692333 0.42208 0.42208C0.692333 0.151827 1.05888 0 1.44107 0C1.82327 0 2.18981 0.151827 2.46006 0.42208C2.73032 0.692333 2.88214 1.05888 2.88214 1.44107C2.88214 2.23661 2.23661 2.89554 1.44107 2.89554ZM11.9973 12H9.51429V8.1C9.51429 7.17054 9.49554 5.97857 8.22054 5.97857C6.92679 5.97857 6.72857 6.98839 6.72857 8.03304V12H4.24286V3.98839H6.62946V5.08125H6.66429C6.99643 4.45179 7.80804 3.7875 9.01875 3.7875C11.5366 3.7875 12 5.44554 12 7.59911V12H11.9973Z"/>
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="16" viewBox="0 0 15 16">
													<path d="M7.42745 4.47857C5.29918 4.47857 3.5825 6.19525 3.5825 8.32352C3.5825 10.4518 5.29918 12.1685 7.42745 12.1685C9.55573 12.1685 11.2724 10.4518 11.2724 8.32352C11.2724 6.19525 9.55573 4.47857 7.42745 4.47857ZM7.42745 10.8232C6.05211 10.8232 4.92773 9.70222 4.92773 8.32352C4.92773 6.94483 6.04876 5.8238 7.42745 5.8238C8.80615 5.8238 9.92718 6.94483 9.92718 8.32352C9.92718 9.70222 8.8028 10.8232 7.42745 10.8232ZM12.3265 4.32129C12.3265 4.8199 11.9249 5.21811 11.4297 5.21811C10.9311 5.21811 10.5329 4.81655 10.5329 4.32129C10.5329 3.82603 10.9344 3.42447 11.4297 3.42447C11.9249 3.42447 12.3265 3.82603 12.3265 4.32129ZM14.8731 5.2315C14.8162 4.03016 14.5418 2.96602 13.6617 2.08928C12.785 1.21253 11.7208 0.938135 10.5195 0.8779C9.28133 0.807627 5.57023 0.807627 4.33208 0.8779C3.13409 0.934788 2.06995 1.20919 1.18986 2.08593C0.309775 2.96267 0.0387205 4.02681 -0.0215138 5.22815C-0.0917871 6.4663 -0.0917871 10.1774 -0.0215138 11.4155C0.0353741 12.6169 0.309775 13.681 1.18986 14.5578C2.06995 15.4345 3.13075 15.7089 4.33208 15.7691C5.57023 15.8394 9.28133 15.8394 10.5195 15.7691C11.7208 15.7123 12.785 15.4379 13.6617 14.5578C14.5384 13.681 14.8128 12.6169 14.8731 11.4155C14.9434 10.1774 14.9434 6.46965 14.8731 5.2315ZM13.2735 12.744C13.0125 13.3999 12.5072 13.9052 11.848 14.1696C10.8608 14.5611 8.51836 14.4708 7.42745 14.4708C6.33655 14.4708 3.99076 14.5578 3.00693 14.1696C2.35105 13.9086 1.84575 13.4033 1.58139 12.744C1.18986 11.7569 1.28022 9.41443 1.28022 8.32352C1.28022 7.23261 1.19321 4.88682 1.58139 3.903C1.8424 3.24711 2.3477 2.74182 3.00693 2.47745C3.9941 2.08593 6.33655 2.17628 7.42745 2.17628C8.51836 2.17628 10.8642 2.08928 11.848 2.47745C12.5039 2.73847 13.0092 3.24377 13.2735 3.903C13.665 4.89017 13.5747 7.23261 13.5747 8.32352C13.5747 9.41443 13.665 11.7602 13.2735 12.744Z"/>
												</svg>
											</a>
										</li>
									</ul>
								</div>
								<div class="team-tile__content">
									<h3 class="team-title"><a href="kevin-m-johnson.html">Donald Arno</a></h3>
									<strong class="team-position">Senior Attorney, NY, NY</strong>
									<ul class="contact-info top--line">
										<li class="contact-info__item">
											<span class="contact-info__text">Mail</span>
											<a class="contact-info__link" href="mailto:donald@example.com">donald@example.com</a>
										</li>
										<li class="contact-info__item">
											<span class="contact-info__text">Tel</span>
											<a class="contact-info__link" href="tel:8005569890">800 556 9890</a>
										</li>
									</ul>
								</div>
							</div>
						</li>
						<li class="team__item">
							<div class="team-tile">
								<div class="team-tile__img">
									<img src="img/law-8-1200x1200.jpg" alt="image description">
									<ul class="social">
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="14" viewBox="0 0 15 14">
													<path d="M11.8133 0H14.1133L9.08845 5.74336L15 13.5586H10.3712L6.74593 8.81856L2.59772 13.5586H0.296162L5.67082 7.41551L0 0H4.74606L8.0231 4.33242L11.8133 0ZM11.006 12.1818H12.2806L4.0536 1.3045H2.68603L11.006 12.1818Z"/>
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="10" height="16" viewBox="0 0 15 24">
													<path d="M13.0836 13.5L13.7492 9.15469H9.58203V6.3375C9.58203 5.14687 10.1633 3.98906 12.0289 3.98906H13.9227V0.295313C13.9227 0.295313 12.207 0 10.5664 0C7.13516 0 4.88984 2.08125 4.88984 5.84531V9.15469H1.07422V13.5H4.88984V24H9.58672V13.5H13.0836Z"/>
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="15" viewBox="0 0 12 12">
													<path d="M2.68661 12H0.198214V3.98839H2.68661V12ZM1.44107 2.89554C0.645536 2.89554 0 2.23661 0 1.44107C0 1.05888 0.151827 0.692333 0.42208 0.42208C0.692333 0.151827 1.05888 0 1.44107 0C1.82327 0 2.18981 0.151827 2.46006 0.42208C2.73032 0.692333 2.88214 1.05888 2.88214 1.44107C2.88214 2.23661 2.23661 2.89554 1.44107 2.89554ZM11.9973 12H9.51429V8.1C9.51429 7.17054 9.49554 5.97857 8.22054 5.97857C6.92679 5.97857 6.72857 6.98839 6.72857 8.03304V12H4.24286V3.98839H6.62946V5.08125H6.66429C6.99643 4.45179 7.80804 3.7875 9.01875 3.7875C11.5366 3.7875 12 5.44554 12 7.59911V12H11.9973Z"/>
												</svg>
											</a>
										</li>
										<li>
											<a class="social__link" href="#" target="_blank">
												<svg width="15" height="16" viewBox="0 0 15 16">
													<path d="M7.42745 4.47857C5.29918 4.47857 3.5825 6.19525 3.5825 8.32352C3.5825 10.4518 5.29918 12.1685 7.42745 12.1685C9.55573 12.1685 11.2724 10.4518 11.2724 8.32352C11.2724 6.19525 9.55573 4.47857 7.42745 4.47857ZM7.42745 10.8232C6.05211 10.8232 4.92773 9.70222 4.92773 8.32352C4.92773 6.94483 6.04876 5.8238 7.42745 5.8238C8.80615 5.8238 9.92718 6.94483 9.92718 8.32352C9.92718 9.70222 8.8028 10.8232 7.42745 10.8232ZM12.3265 4.32129C12.3265 4.8199 11.9249 5.21811 11.4297 5.21811C10.9311 5.21811 10.5329 4.81655 10.5329 4.32129C10.5329 3.82603 10.9344 3.42447 11.4297 3.42447C11.9249 3.42447 12.3265 3.82603 12.3265 4.32129ZM14.8731 5.2315C14.8162 4.03016 14.5418 2.96602 13.6617 2.08928C12.785 1.21253 11.7208 0.938135 10.5195 0.8779C9.28133 0.807627 5.57023 0.807627 4.33208 0.8779C3.13409 0.934788 2.06995 1.20919 1.18986 2.08593C0.309775 2.96267 0.0387205 4.02681 -0.0215138 5.22815C-0.0917871 6.4663 -0.0917871 10.1774 -0.0215138 11.4155C0.0353741 12.6169 0.309775 13.681 1.18986 14.5578C2.06995 15.4345 3.13075 15.7089 4.33208 15.7691C5.57023 15.8394 9.28133 15.8394 10.5195 15.7691C11.7208 15.7123 12.785 15.4379 13.6617 14.5578C14.5384 13.681 14.8128 12.6169 14.8731 11.4155C14.9434 10.1774 14.9434 6.46965 14.8731 5.2315ZM13.2735 12.744C13.0125 13.3999 12.5072 13.9052 11.848 14.1696C10.8608 14.5611 8.51836 14.4708 7.42745 14.4708C6.33655 14.4708 3.99076 14.5578 3.00693 14.1696C2.35105 13.9086 1.84575 13.4033 1.58139 12.744C1.18986 11.7569 1.28022 9.41443 1.28022 8.32352C1.28022 7.23261 1.19321 4.88682 1.58139 3.903C1.8424 3.24711 2.3477 2.74182 3.00693 2.47745C3.9941 2.08593 6.33655 2.17628 7.42745 2.17628C8.51836 2.17628 10.8642 2.08928 11.848 2.47745C12.5039 2.73847 13.0092 3.24377 13.2735 3.903C13.665 4.89017 13.5747 7.23261 13.5747 8.32352C13.5747 9.41443 13.665 11.7602 13.2735 12.744Z"/>
												</svg>
											</a>
										</li>
									</ul>
								</div>
								<div class="team-tile__content">
									<h3 class="team-title"><a href="kevin-m-johnson.html">Nataly Parker</a></h3>
									<strong class="team-position">Senior Attorney, NY, NY</strong>
									<ul class="contact-info top--line">
										<li class="contact-info__item">
											<span class="contact-info__text">Mail</span>
											<a class="contact-info__link" href="mailto:maria@example.com">maria@example.com</a>
										</li>
										<li class="contact-info__item">
											<span class="contact-info__text">Tel</span>
											<a class="contact-info__link" href="tel:8005569890">800 556 9890</a>
										</li>
									</ul>
								</div>
							</div>
						</li> -->
					</ul>
				</div>
			</section>
			<section class="section-tile">
				<div class="section-tile__item">
					<div class="container">

						<h3>Meet the Minds Behind Your Success</h3>
						<p>Our team consists of seasoned professionals driven by a commitment to excellence and client
							success. Each member brings a wealth of expertise, creativity, and innovation to tackle
							complex legal challenges across industries. From strategic advisors in M&A to specialists in
							litigation and corporate risk, our collaborative team combines diverse perspectives and deep
							industry knowledge to deliver exceptional results. Together, we’re dedicated to empowering
							your business with the legal insights and solutions you need to thrive in a dynamic world.
						</p>
						<!-- <a href="#" class="btn btn--outline-primary">
							Find Out More
							<svg class="icon" width="21" height="12" viewBox="0 0 21 12">
								<path fill-rule="evenodd" clip-rule="evenodd" d="M15 6.75L0 6.75L0 5.25L15 5.25V6.75Z"/>
								<path d="M21 5.99986L14.25 11.196L14.25 0.803711L21 5.99986Z"/>
							</svg>
						</a> -->
					</div>
				</div>
				<div class="section-tile__item offset--0">
					<div class="bg-stretch bg-stretch--img">
						<img src="img/home/banner-3-3.jpg" alt="image description">
					</div>
				</div>
			</section>
			<!-- <section class="section section--offset-0 bg--gradient">
				<ul class="cta-list">
					<li class="cta-list__item">
						<div class="cta-wrap">
							<span class="cta-wrap__icon">
								<img src="img/img-5.png" alt="image description">
							</span>
							<div class="cta-wrap__content">
								<h5 class="cta-wrap__subtitle">Book an</h5>
								<h2 class="cta-wrap__title">Appointment</h2>
								<a href="#" class="cta-wrap__link"></a>
							</div>
						</div>
					</li>
					<li class="cta-list__item">
						<div class="cta-wrap">
							<span class="cta-wrap__icon">
								<img src="img/img-7.png" alt="image description">
							</span>
							<div class="cta-wrap__content">
								<h5 class="cta-wrap__subtitle">Get free Case</h5>
								<h2 class="cta-wrap__title">Evaluation</h2>
								<a href="#" class="cta-wrap__link"></a>
							</div>
						</div>
					</li>
					<li class="cta-list__item">
						<div class="cta-wrap">
							<span class="cta-wrap__icon">
								<img src="img/img-9.png" alt="image description">
							</span>
							<div class="cta-wrap__content">
								<h5 class="cta-wrap__subtitle">Get free Case</h5>
								<h2 class="cta-wrap__title">Evaluation</h2>
								<a href="#" class="cta-wrap__link"></a>
							</div>
						</div>
					</li>
				</ul>
			</section> -->
		</main>
		<?php include "main-footer.php" ?>
	</div>
	<script src="js/all.js"></script>
</body>

</html>