<!DOCTYPE html>
<html lang="en">
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>AM Law Contact</title>
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Libre+Baskerville:ital,wght@0,400;0,700;1,400&amp;family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap"
        rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link media="all" rel="stylesheet" href="css/main.css">
    <style>
        .form-container {
            background: white;
            padding: 20px 30px;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 500px;
        }

        @media (max-width: 768px) {
            .form-container {
                padding: 15px;
                width: 100%;
                max-width: 100%;
            }

            .image {
                display: none;
            }

            .row {
                flex-direction: column;
            }

            .col-md-5 {
                width: 100%;
            }

            .offset-md-1 {
                margin-left: 0;
            }
        }

        @media (max-width: 480px) {

            h1,
            h2,
            h4 {
                font-size: 18px;
            }

            .form-group {
                margin-bottom: 10px;
            }

            label {
                font-size: 14px;
            }

            input,
            button {
                padding: 8px;
            }
        }

        h2 {
            text-align: center;
            color: #8a8a5c;
            margin-bottom: 20px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        label {
            display: block;
            margin-bottom: 5px;
            color: #444;
            font-weight: bold;
        }

        input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
            outline: none;
            transition: border 0.3s ease;
        }

        input:focus {
            border: 1px solid #8a8a5c;
            box-shadow: 0 0 5px rgba(192, 148, 57, 0.5);
        }



        .image img {
            width: 100%;
            height: auto;
            border-radius: 10px;
            margin-right: 20%;
        }

        .row {
            display: flex;
            align-items: stretch;
        }

        @media (max-width: 1023px) {
            .image img {
                display: none;
            }
        }

        @media (max-width: 767px) {
            .form-container {
                box-shadow: none;
            }
        }
    </style>
</head>

<body>
    <div class="wrapper wrapper--offset-0">
        <?php include("main-header.php"); ?>
        <main class="main">
            <section class="section-intro">
                <div class="container">
                    <h1>Join us</h1>
                </div>
                <div class="bg-stretch">
                    <img src="img/home/banner-3.jpg" alt="image description">
                </div>
            </section>
            <section class="section-breadcrumbs">
                <div class="container">
                    <ul class="breadcrumbs">
                        <li class="breadcrumbs__item"><a href="#" class="breadcrumbs__link">Home</a></li>
                        <li class="breadcrumbs__item current">Join us</li>
                    </ul>
                </div>
            </section>
            <section>
                <div class="container mt-5">
                    <h4 class="fw-light" style="text-align: left;">
                        AM Law Offices believes in hiring the best talent who can be an asset to our firm, whether you
                        are a recent law graduate or a lawyer with experience in a specific area of practice. AM Law
                        Office could be the place for you if you want to work in a nurturing and relaxed environment.
                        Please see the list of current openings below. To apply for the selected position, please
                        complete the form below.
                    </h4>
                    <div>
                        <div>
                            <div class=" row mb--3 pt-5 align-items-center">
                                <div class="form-container">
                                    <h2>Application Form</h2>
                                    <form id="applicationForm">
                                        <input type="hidden" name="applicationType" value="Join Us Application">
                                        <div class="form-group">
                                            <label for="fname">First Name</label>
                                            <input type="text" id="fname" name="fname"
                                                placeholder="Enter your first name" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="lname">Last Name</label>
                                            <input type="text" id="lname" name="lname"
                                                placeholder="Enter your last name" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="email">Email</label>
                                            <input type="email" id="email" name="email" placeholder="Enter your email"
                                                required>
                                        </div>
                                        <div class="form-group">
                                            <label for="phone">Phone</label>
                                            <input type="number" id="phone" name="phone"
                                                placeholder="Enter your phone number" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="YOE">Year Of Experience</label>
                                            <input type="number" id="YOE" name="YOE"
                                                placeholder="Enter your years of experience" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="CV">Link to CV/LinkedIn</label>
                                            <input type="text" id="CV" name="CV"
                                                placeholder="Enter the link to your CV or LinkedIn" required>
                                        </div>
                                        <div class="w-100 text-center">
                                            <button class="btn btn--outline-primary w-50" type="submit">Apply</button>
                                        </div>
                                    </form>
                                </div>
                                <div class="col-md-5 offset-md-1 image">
                                    <img src="img/official-image/team.jpg" alt="AM legal office">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section>

            </section>


        </main>
        <?php include('main-footer.php'); ?>
    </div>
    <script>
        document.getElementById("applicationForm").addEventListener("submit", function(e) {
            e.preventDefault();

            const formData = new FormData(e.target);
            console.log(formData); // Check if form data is being collected correctly

            fetch('send_email.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.text())
                .then(response => {
                    if (response === "success") {
                        alert("Your application has been submitted successfully!");
                        e.target.reset(); // Clear the form
                    } else {
                        alert("There was an error submitting your application: " + response);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert("An unexpected error occurred. Please try again.");
                });
        });
    </script>
    <script src="js/all.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/lightbox2/dist/js/lightbox.min.js"></script>

</body>

</html>