<!DOCTYPE html>
<html lang="en">
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>AM Law Offices</title>
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Libre+Baskerville:ital,wght@0,400;0,700;1,400&amp;family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap"
        rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link media="all" rel="stylesheet" href="css/main.css">
    <style>
        .form-container {
            background: white;
            padding: 20px 30px;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 500px;
            margin: 0 auto;
        }

        h2 {
            text-align: center;
            color: #898777;
            margin-bottom: 20px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        label {
            display: block;
            margin-bottom: 5px;
            color: #444;
            font-weight: bold;
        }

        input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
            outline: none;
            transition: border 0.3s ease;
        }

        input:focus {
            border: 1px solid #898777;
            box-shadow: 0 0 5px rgba(192, 148, 57, 0.5);
        }



        .image img {
            width: 100%;
            height: auto;
            border-radius: 10px;
            margin-right: 20%;
        }

        .row {
            display: flex;
            flex-wrap: wrap;
            align-items: stretch;
        }

        .col-md-5 {
            display: flex;
            justify-content: center;
            align-items: center;
        }

        @media (max-width: 1023px) {
            .image img {
                display: none;
            }
        }

        @media (max-width: 767px) {
            .form-container {
                box-shadow: none;
            }
        }
    </style>
</head>

<body>
    <div class="wrapper wrapper--offset-0">
        <?php include('main-header.php') ?>
        <main class="main">
            <section class="section-intro">
                <div class="container">
                    <h1>Internship Program</h1>
                    <h4 class="subtitle">Company profile</h4>
                </div>
                <div class="bg-stretch">
                    <img src="img/home/banner-1.jpg" alt="image description">
                </div>
            </section>
            <section class="section-breadcrumbs">
                <div class="container">
                    <ul class="breadcrumbs">
                        <li class="breadcrumbs__item"><a href="index.php" class="breadcrumbs__link">Home</a></li>
                        <li class="breadcrumbs__item current">Internship Program</li>
                    </ul>
                </div>
            </section>
            <section>
                <div class="container mt-5">
                    <h4 class="fw-light">
                        AM Law Offices provides interested aspiring law students with an internship Programme. This
                        Programme was created with the intention of giving emerging legal talent access to
                        mentorship
                        and priceless experience across a range of practice areas.
                    </h4>
                    <h4 class="fw-light">
                        AM Law Offices provides opportunities to students from law colleges/schools from all over
                        the
                        country to undertake an internship at their Lucknow office. During the internship, the
                        interns
                        are supervised by the partners and associates with experience in a range of Corporate,
                        Litigation, Regulatory Compliances, Tax advisory, Investment Strategy and related areas.
                    </h4>
            </section>
            <section class="container mt-5">
                <h2 class="key">Key Benefits of the Internship Program</h2>
                <style>
                    .key-benefits {
                        list-style-type: disc;
                        /* Use 'disc' for solid bullets */
                        padding-left: 20px;

                        /* Add some padding to the left */
                    }

                    @media screen and (max-width: 768px) {
                        .key {
                            text-align: start;
                        }
                    }
                </style>
                <ul class="key-benefits fw-light">
                    <li>The length of the internship could be 4 weeks, 8 weeks, 4 months, or 1 year, depending on the
                        candidate's preferences and the open opportunities.</li><br>
                    <li>The candidate(s) selected for the one year program would be given a position of 'Trainee
                        Advocate.</li><br>
                    <li>Interested law graduates or law students pursuing studies (2nd and 3rd year of three-year law
                        degree course and 3rd to 5th year of five-year law degree course only) at any recognized
                        College/Law School/University should submit their application in the enclosed format.</li><br>
                    <li>The candidate's CV must be received by us at least two months before the desired date of
                        internship.</li><br>
                    <li>Email the application to amlegaloffices@gmail.com.</li><br>
                    <li>A certificate will be issued to the intern at the end of his/her internship after assessment of
                        the work.</li><br>
                    <li>An intern as part of the programme would definitely gain experience in Legal writing, Legal
                        Drafting, Court visits etc.</li>
                </ul>
            </section>
            <section>
                <div class="container">
                    <div class="row mb--3 pt-5 align-items-center">
                        <div class=" col-md-6">
                            <div class="form-container">
                                <h2>Application Form</h2>
                                <form id="applicationForm">
                                    <div class="form-group">
                                        <label for="fname">First Name</label>
                                        <input type="text" id="fname" name="fname" placeholder="Enter your first name"
                                            required>
                                    </div>
                                    <div class="form-group">
                                        <label for="lname">Last Name</label>
                                        <input type="text" id="lname" name="lname" placeholder="Enter your last name"
                                            required>
                                    </div>
                                    <div class="form-group">
                                        <label for="email">Email</label>
                                        <input type="email" id="email" name="email" placeholder="Enter your email"
                                            required>
                                    </div>
                                    <div class="form-group">
                                        <label for="phone">Phone</label>
                                        <input type="tel" id="phone" name="phone" placeholder="Enter your phone number"
                                            pattern="\d{10}" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="YOE">Year Of Experience</label>
                                        <input type="number" id="YOE" name="YOE"
                                            placeholder="Enter your years of experience" min="0" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="CV">Link to CV/LinkedIn</label>
                                        <input type="url" id="CV" name="CV"
                                            placeholder="Enter the link to your CV or LinkedIn" required>
                                    </div>
                                    <div class="w-100 text-center">
                                        <button class="btn btn--outline-primary w-50" type="submit">Apply</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="col-md-5 offset-md-1 image">
                            <img src="img/official-image/team.jpg" class="img-fluid" alt="AM legal office">
                        </div>
                    </div>
                </div>
            </section>
        </main>
    </div>

    <?php include('main-footer.php'); ?>

    <script>
        document.getElementById("applicationForm").addEventListener("submit", function(e) {
            e.preventDefault();

            const formData = new FormData(e.target);
            console.log(formData); // Check if form data is being collected correctly

            fetch('send_email.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.text())
                .then(response => {
                    if (response === "success") {
                        alert("Your application has been submitted successfully!");
                        e.target.reset(); // Clear the form
                    } else {
                        alert("There was an error submitting your application: " + response);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert("An unexpected error occurred. Please try again.");
                });
        });
    </script>
    <script src="js/all.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/lightbox2/dist/js/lightbox.min.js"></script>

</body>

</html>

<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require './PHPMailer/Exception.php';
require './PHPMailer/PHPMailer.php';
require './PHPMailer/SMTP.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Collect form data
    $firstName = $_POST['fname'];
    $lastName = $_POST['lname'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $yearsOfExperience = $_POST['YOE'];
    $cvLink = $_POST['CV'];

    // Set up PHPMailer object
    $mail = new PHPMailer(true);
    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host = 'smtp.gmail.com'; // Gmail SMTP server
        $mail->SMTPAuth = true;
        $mail->Username = 'nitin2019it035abesit@gmail.com'; // Replace with your email
        $mail->Password = 'cvewhcanbrekhcvj'; // Replace with your email password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;

        // Recipients
        $mail->setFrom('nitin2019it035abesit@gmail.com', 'AM Law Offices'); // Replace with your email
        $mail->addAddress('nitsha1999n@gmail.com', 'Website Owner'); // Replace with website owner's email

        // Content
        $mail->isHTML(true);
        $mail->Subject = 'New Internship Application';
        $mail->Body = "<h1>New Internship Application</h1>
            <p><strong>First Name:</strong> $firstName</p>
            <p><strong>Last Name:</strong> $lastName</p>
            <p><strong>Email:</strong> $email</p>
            <p><strong>Phone:</strong> $phone</p>
            <p><strong>Years of Experience:</strong> $yearsOfExperience</p>
            <p><strong>CV/LinkedIn Link:</strong> <a href='$cvLink' target='_blank'>$cvLink</a></p>";

        // Send email
        $mail->send();
        echo "success"; // Return success message to the frontend
    } catch (Exception $e) {
        echo "Mailer Error: " . $mail->ErrorInfo; // Output the PHPMailer error message
    }
}

?>