<!DOCTYPE html>
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>AM Law Offices</title>
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Libre+Baskerville:ital,wght@0,400;0,700;1,400&amp;family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap"
        rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link media="all" rel="stylesheet" href="css/main.css">
    <style>
        .scroll-to-top {
            position: fixed;
            bottom: 20px;
            right: 20px;
            background-color: #fff;
            /* Change this to match your theme */
            border: none;
            border-radius: 50%;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
            padding: 10px;
            cursor: pointer;
            z-index: 1000;
            display: none;
            /* Hidden by default */
            transition: background-color 0.3s, transform 0.3s;
        }

        .scroll-to-top:hover {
            background-color: #f0f0f0;
            /* Change this to match your hover effect */
            transform: scale(1.1);
        }

        .scroll-to-top svg {
            fill: #333;
            /* Change this to match your theme */
        }

        .form-control {
            color: black;
            /* Change text color to black */
        }

        /* Popup Overlay (cover the entire page) */
        .popup-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }

        /* Popup Box */
        .popup {
            background-color: #f0f0f0;
            color: #333;
            padding: 20px;
            border-radius: 8px;
            text-align: left;
            width: 600px;
            max-width: 100%;
        }

        /* Button Style */
        .popup button {
            margin-top: 20px;
            padding: 10px 20px;
            border: none;
            background-color: #979878;
            color: white;
            border-radius: 4px;
            cursor: pointer;
        }

        .popup button:hover {
            background-color: #898777;
        }
    </style>
    <style>
        .form-container {
            background: white;
            padding: 20px 30px;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
        }

        .form-container h2 {
            text-align: center;
            color: #8a8a5c;
            margin-bottom: 20px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-container label {
            display: block;
            margin-bottom: 5px;
            color: #444;
            font-weight: bold;
        }

        .form-container input {
            width: 100%;
            padding: 10px;
            border-radius: 5px;
            font-size: 16px;
            outline: none;
            transition: border 0.3s ease;
        }

        .form-container input:focus {
            border: 1px solid #8a8a5c;
            box-shadow: 0 0 5px rgba(192, 148, 57, 0.5);
        }

        /* .form-container button {
            width: 100%;
            padding: 10px;
            background: #c09439;
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
        } */

        /* .form-container button:hover {
            background: #b28331;
        } */

        .image img {
            width: 100%;
            height: auto;
            border-radius: 10px;
            margin-right: 20%;
        }

        .row {
            display: flex;
            flex-wrap: wrap;
            align-items: stretch;
        }

        .col-md-5 {
            display: flex;
            justify-content: center;
            align-items: center;
        }

        @media (max-width: 1023px) {
            .image img {
                display: none;
            }
        }


        .quote {
            width: 60%;
            margin: 0 auto;
            padding: 50px 0;
        }

        .quote h1 {
            font-size: 36px;
            color: #8a8a5c;
        }

        .quote p {
            font-size: 18px;
            margin-bottom: 40px;
        }

        .quote form {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
        }

        .form-group {
            width: 48%;
            margin-bottom: 20px;
        }

        .form-group.full-width {
            width: 100%;
        }

        .s-btn {
            text-align: center;
        }

        .form-container label {
            display: block;
            font-size: 16px;
            margin-bottom: 5px;
        }

        .form-container input,
        textarea {
            width: 100%;
            padding: 10px;
            font-size: 16px;
            border: none;
            border: 1px solid rgb(187, 187, 187);
            outline: none;
        }

        .form-container textarea {
            height: 100px;
        }

        .submit-btn {
            background-color: #4a4a4a;
            width: 200px;
            color: #fff;
            padding: 10px 20px;
            font-size: 18px;
            border: none;
            cursor: pointer;
            margin-top: 20px;
        }

        @media (max-width: 767px) {
            .form-container {
                box-shadow: none;
            }
        }
    </style>
</head>

<body>
    <div id="popupOverlay" class="popup-overlay">
        <div class="popup">
            <p>The rules of the Bar Council of India prohibit law firms from soliciting work or advertising in any
                manner. By clicking on 'I AGREE, the user acknowledges that:
            </p>
            <p>The user wishes to gain more information about AM Law Offices, its practice areas and its attorneys,
                for his/her own information and use;
            </p>
            <p>The information is made available/provided to the user only on his/her specific request and any
                information obtained or material downloaded from this website is completely at the user's volition and
                any transmission, receipt or use of this site is not intended to, and will not, create any lawyer-client
                relationship; and
            </p>
            <p>None of the information contained on the website is in the nature of a legal opinion or otherwise amounts
                to any legal advice.
            </p>
            <p>AM Law Offices is not liable for any consequence of any action taken by the user relying on
                material/information provided under this website. In cases where the user has any legal issues, he/she
                in all cases must seek independent legal advice.

            </p>
            <button id="agreeButton" class="btn btn-primary">I Agree</button>
        </div>
    </div>

    <div class="wrapper wrapper--offset-0">
        <?php include "main-header.php" ?>
        <main class="main">
            <section>
                <div class="hero-slider">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <div class="hero-tile">
                                <div class="container">
                                    <h2 class="hero-tile__title h1">AM Law Offices</h2>
                                    <div class="text-wrap fade-up">
                                        <p>Smart approaches to legal solutions with exceptional service. Legal talent
                                            and expertise necessary to meet our clients’ needs in an ever-changing and
                                            fast-paced environment.</p>
                                    </div>
                                    <a href="#contact" class="btn btn--white text--uppercase fade-up">
                                        Get In Touch
                                        <svg class="icon" width="21" height="12" viewBox="0 0 21 12">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M15 6.75L0 6.75L0 5.25L15 5.25V6.75Z" />
                                            <path d="M21 5.99986L14.25 11.196L14.25 0.803711L21 5.99986Z" />
                                        </svg>
                                    </a>
                                </div>
                                <div class="bg-stretch">
                                    <img src="img/home/banner-1-1.JPG" alt="AM Legal Offices">
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="hero-tile">
                                <div class="container">
                                    <h2 class="hero-tile__title h1">Solid Law Practice <br> Experienced Lawyers</h2>
                                    <div class="text-wrap fade-up">
                                        <p>Our lawyers offer clients a range of integrated global capabilities. It
                                            includes some of the world’s most active M&A, real estate, financial
                                            services and corporate risk practices.</p>
                                    </div>
                                    <a href="#contact" class="btn btn--white text--uppercase fade-up">
                                        Get In Touch
                                        <svg class="icon" width="21" height="12" viewBox="0 0 21 12">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M15 6.75L0 6.75L0 5.25L15 5.25V6.75Z" />
                                            <path d="M21 5.99986L14.25 11.196L14.25 0.803711L21 5.99986Z" />
                                        </svg>
                                    </a>
                                </div>
                                <div class="bg-stretch">
                                    <img src="img/home/banner-3-3.jpg" alt="AM Legal Offices">
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="hero-tile">
                                <div class="container">
                                    <h2 class="hero-tile__title h1">Comprehensive Legal Support<br> When It Matters Most
                                    </h2>
                                    <div class="text-wrap fade-up">
                                        <p>Whether you’re facing personal, business, or family legal matters, our team
                                            is here to guide you with confidence, compassion, and skill.</p>
                                    </div>
                                    <a href="#contact" class="btn btn--white text--uppercase fade-up">
                                        Get In Touch
                                        <svg class="icon" width="21" height="12" viewBox="0 0 21 12">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M15 6.75L0 6.75L0 5.25L15 5.25V6.75Z" />
                                            <path d="M21 5.99986L14.25 11.196L14.25 0.803711L21 5.99986Z" />
                                        </svg>
                                    </a>
                                </div>
                                <div class="bg-stretch">
                                    <img src="img/home/banner-5-5.jpg" alt="AM Legal Offices">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-pagination"></div>
                </div>
            </section>
            <section>
                <ul class="service-list">
                    <li class="service-list__item">
                        <div class="service-card">
                            <div class="service-card__bg">
                                <img src="img/box_bg_1.jpg" alt="image description">
                            </div>
                            <h2 class="service-card__title">Experienced Court<br> Performance</h2>
                            <p>Driven by Precision, Powered by Results</p>
                        </div>
                    </li>
                    <li class="service-list__item">
                        <div class="service-card">
                            <div class="service-card__bg">
                                <img src="img/box_bg_2.jpg" alt="image description">
                            </div>
                            <h2 class="service-card__title">Solid Foundations, Unbreakable Trust</h2>
                            <p class="text-white">Building Legal Strategies that Stand the Test of Time</p>
                        </div>
                    </li>
                    <li class="service-list__item">
                        <div class="service-card">
                            <div class="service-card__bg">
                                <img src="img/box_bg_3.jpg" alt="image description">
                            </div>
                            <h2 class="service-card__title">Leaders in Legal<br> Innovation</h2>
                            <p>Pioneering Solutions for a Changing World</p>
                        </div>
                    </li>
                </ul>
            </section>
            <section class="section bg--light">
                <div class="container">
                    <div class="section-headline">
                        <h4>Our Expertise</h4>
                        <p>Our lawyers offer clients a range of integrated global capabilities, including some of the
                            world’s most active M&amp;A, real estate, financial services, litigation and corporate risk
                            practices.</p>
                    </div>
                    <ul class="row-list gap--1">
                        <li class="row-list__item">
                            <div class="card card--overlay">
                                <div class="card__image">
                                    <img src="img/law.png" width="40" alt="image description">
                                </div>
                                <h4 class="card__title">Constitutional Law Disputes
                                </h4>
                                <div class="text-wrap">
                                    <p>We are the top law firm in Lucknow and mainly deal in Constitutional, civil, real
                                        estate litigation and advisory Service & employment issues.</p>
                                </div>
                                <a href="#" class="card__link"></a>
                            </div>
                        </li>
                        <li class="row-list__item">
                            <div class="card card--overlay">
                                <div class="card__image">
                                    <img src="img/img-11.png" width="40" alt="image description">
                                </div>
                                <h4 class="card__title">Corporate Law</h4>
                                <div class="text-wrap">
                                    <p>Our corporate-commercial team has extensive experience in providing a wide range
                                        of services to corporations, directors, shareholders, partnerships and so on.
                                    </p>
                                </div>
                                <a href="#" class="card__link"></a>
                            </div>
                        </li>
                        <li class="row-list__item">
                            <div class="card card--overlay">
                                <div class="card__image">
                                    <img src="img/img-22.png" alt="image description">
                                </div>
                                <h4 class="card__title">Real Estate Litigation and Advisory
                                </h4>
                                <div class="text-wrap">
                                    <p>Includes all disputes and matters related to property and estate planning.We have
                                        a great bunch of advocates among which you can get highly essential legal
                                        assistance.</p>
                                </div>
                                <a href="#" class="card__link"></a>
                            </div>
                        </li>
                        <li class="row-list__item">
                            <div class="card card--overlay">
                                <div class="card__image">
                                    <img src="img/img-13.png" width="39" alt="image description">
                                </div>
                                <h4 class="card__title">Service Related Disputes
                                </h4>
                                <div class="text-wrap">
                                    <p>AM Law Offices has a team of experts ready to advise our clients on Service
                                        related disputes related to termination, suspension, promotion, reversion etc.in
                                        Lucknow area.</p>
                                </div>
                                <a href="#" class="card__link"></a>
                            </div>
                        </li>
                        <li class="row-list__item">
                            <div class="card card--overlay">
                                <div class="card__image">
                                    <img src="img/img-23.png" alt="image description" width="30">
                                </div>
                                <h4 class="card__title">Tax Law</h4>
                                <div class="text-wrap">
                                    <p>We advise and assist corporate business entities, non-corporate entities, and
                                        high net worth individuals in strategizing and meeting their domestic tax
                                        obligations.</p>
                                </div>
                                <a href="#" class="card__link"></a>
                            </div>
                        </li>
                        <li class="row-list__item">
                            <div class="card card--overlay">
                                <div class="card__image">
                                    <img src="img/img-14.png" width="39" alt="image description">
                                </div>
                                <h4 class="card__title">Arbitration and Conciliation Act</h4>
                                <div class="text-wrap">
                                    <p>ADR, or alternative dispute resolution, includes arbitration along with other
                                        well-known ADR procedures including conciliation and mediation.</p>
                                </div>
                                <a href="#" class="card__link"></a>
                            </div>
                        </li>
                        <!-- <li class="row-list__item">
							<div class="card card--overlay">
								<div class="card__image">
									<img src="img/loan.png" width="40" alt="image description">
								</div>
								<h4 class="card__title">Consumer and Banking matters
								</h4>
								<div class="text-wrap">
									<p>
										Our banking and finance services team is cognizant of this sectoral reality and is skilled at handling a wide range of legal issues arising from borrower-lender relationships. </p>
								</div>
								<a href="#" class="card__link"></a>
							</div>
						</li>
						<li class="row-list__item">
							<div class="card card--overlay">
								<div class="card__image">
									<img src="img/family.png" width="40" alt="image description">
								</div>
								<h4 class="card__title">Matrimonial Disputes 
								</h4>
								<div class="text-wrap">
									<p>Adoption, divorce, and child custody are examples of legal issues relating family relationships that are addressed under family law.   </p>
								</div>
								<a href="#" class="card__link"></a>
							</div>
						</li>
						  -->


                    </ul>
                    <div class="btn-holder">
                        <a href="practices.php" class="btn btn--outline-primary">
                            Find Out More
                            <svg class="icon" width="21" height="12" viewBox="0 0 21 12">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M15 6.75L0 6.75L0 5.25L15 5.25V6.75Z">
                                </path>
                                <path d="M21 5.99986L14.25 11.196L14.25 0.803711L21 5.99986Z"></path>
                            </svg>
                        </a>
                    </div>
                </div>
            </section>

            <section class="section-tile">
                <div class="section-tile__item">
                    <div class="container">
                        <h4 class="headtitle">Who we are</h4>
                        <h3>AM Law Offices established in the year 2014 is a multi- disciplinary law firm with result
                            oriented and well read lawyers having a global approach.
                        </h3>
                        <div class="about-wrap__text mb-5">
                            <p>Founded with the goal of bringing client service into sharper focus, the firm has
                                successfully been able to establish its identity outside of its origins, dealing with
                                significant depth in complex domestic and international matters. It also provides
                                clients across all sectors with committed legal representation and commercially viable
                                legal advice.</p>
                        </div>
                        <a href="about.php" class="btn btn--outline-primary">
                            Find Out More
                            <svg class="icon" width="21" height="12" viewBox="0 0 21 12">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M15 6.75L0 6.75L0 5.25L15 5.25V6.75Z">
                                </path>
                                <path d="M21 5.99986L14.25 11.196L14.25 0.803711L21 5.99986Z"></path>
                            </svg>
                        </a>
                    </div>
                </div>
                <div class="section-tile__item offset--0">
                    <div class="bg-stretch bg-stretch--img">
                        <img src="img/home/banner-2-2.jpg" alt="image description">
                    </div>
                </div>
            </section>


            <section class="section section-testimonial">
                <div class="container">
                    <div class="section-headline">
                        <h4>Satisfied client stories</h4>
                    </div>
                    <div class="testimonial-slider">
                        <div class="swiper-wrapper">
                            <div class="swiper-slide">
                                <blockquote class="testimonial-quote">
                                    <p>“AM Law Offices is committed to providing its clients with the best legal
                                        representation available, while also providing the level attention to detail
                                        that our clients expect and deserve.”</p>
                                    <span class="testimonial-quote__author">Sunil Singh</span>
                                </blockquote>
                            </div>
                            <div class="swiper-slide">
                                <blockquote class="testimonial-quote">
                                    <p>Working with AM Law Offices was an absolute game-changer. I was overwhelmed and
                                        unsure where to turn, facing a legal battle that seemed impossible to win. From
                                        our very first consultation, they put me at ease, explaining every step of the
                                        process and answering all my questions with patience and clarity. </p>
                                    <span class="testimonial-quote__author">Kapil Kumar</span>
                                </blockquote>
                            </div>

                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
                <div class="bg-stretch">
                    <img src="img/home/banner-1.jpg" alt="image description">
                </div>
            </section>
            <section class="section-tile" id="contact">
                <div class="section-tile__item">
                    <div class="form-container">
                        <h2>
                            Get in Touch</h2>
                        <p>Contacting the firm is free. We understand that the disputes facing you, your family or your
                            business can seem daunting.</p>
                        <form id="applicationForm">
                            <input type="hidden" name="applicationType" value="Join Us Application">
                            <div class="row">
                                <div class="form-group w-100">
                                    <label for="fname">Name</label>
                                    <input type="text" id="fname" name="fname" placeholder="Enter your first name"
                                        required>
                                </div>

                                <div class="form-group w-100">
                                    <label for="email">Email</label>
                                    <input type="email" id="email" name="email" placeholder="Enter your email" required>
                                </div>
                                <div class="form-group w-100">
                                    <label for="phone">Subject</label>
                                    <input type="text" id="phone" name="phone" placeholder="Enter your phone number"
                                        required>
                                </div>
                                <div class="form-group w-100">
                                    <label for="YOE">Message</label>
                                    <textarea name="" placeholder="Enter your message" id=""></textarea>
                                </div>

                            </div>
                            <div class="w-100 text-center">
                                <button class="btn btn--outline-primary w-50" type="submit">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="section-tile__item bg--gradient">
                    <div class="container">
                        <h4 class="headtitle">Contact Us</h4>
                        <ul class="post-list">
                            <li class="post-list__item">
                                <div class="post-card">
                                    <div class="listing-meta">
                                        <span class="listing-meta__item">
                                            <a href="#">Address</a>
                                        </span>
                                    </div>
                                    <h3 class="post-card__title">AASRA R-6, 18, opp. UP Bar Council Office, Vipul Khand
                                        6, Vipul Khand, Gomti Nagar, Lucknow, Uttar Pradesh 226010, India</h3>
                                </div>
                            </li>
                            <li class="post-list__item">
                                <div class="post-card">
                                    <div class="listing-meta">
                                        <span class="listing-meta__item">
                                            <a href="#">Contact No</a>
                                        </span>
                                    </div>
                                    <h3 class="post-card__title"><a href="tel:7905243300">+91-7905243300</a></h3>
                                </div>
                            </li>
                            <li class="post-list__item">
                                <div class="post-card">
                                    <div class="listing-meta">
                                        <span class="listing-meta__item">
                                            <a href="#">Email</a>
                                        </span>
                                    </div>
                                    <h3 class="post-card__title"><a
                                            href="mailto:amlegaloffices@gmail.com">amlegaloffices@gmail.com</a></h3>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </section>
        </main>
        <button id="scrollToTop" class="scroll-to-top" title="Go to top">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="#000">
                <!-- Outer Circle -->
                <path d="M12 2a10 10 0 1 0 10 10A10.011 10.011 0 0 0 12 2zm0 18a8 8 0 1 1 8-8 8.009 8.009 0 0 1-8 8z" />

                <!-- Upper Chevron -->
                <path d="m7.293 11.293 1.414 1.414L12 9.414l3.293 3.293 1.414-1.414L12 6.586l-4.707 4.707z" />

                <!-- Lower Chevron -->
                <path d="m7.293 15.293 1.414 1.414L12 13.414l3.293 3.293 1.414-1.414L12 10.586l-4.707 4.707z" />
            </svg>

        </button>
        <?php include('main-footer.php'); ?>
    </div>
    <script src="js/all.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"
        integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js"
        integrity="sha384-0pUGZvbkm6XF6gxjEnlmuGrJXVbNuzT9qBBavbLwCsOGabYfZo0T0to5eqruptLy" crossorigin="anonymous">
    </script>
    <script>
        // Get the button
        var scrollToTopBtn = document.getElementById("scrollToTop");

        // Show the button when scrolling down
        window.onscroll = function() {
            if (document.body.scrollTop > 100 || document.documentElement.scrollTop > 100) {
                scrollToTopBtn.style.display = "block";
            } else {
                scrollToTopBtn.style.display = "none";
            }
        };

        // Scroll to top function
        scrollToTopBtn.onclick = function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        };



        // Wait for the page to load completely
        window.onload = function() {
            // Display the popup
            document.getElementById('popupOverlay').style.display = 'flex';
        };

        // Function to close the popup when the user agrees
        document.getElementById('agreeButton').addEventListener('click', function() {
            // Hide the popup and enable the background
            document.getElementById('popupOverlay').style.display = 'none';
        });
    </script>


</body>

</html>