<?php
$galleryImages = [
    [
        "src" => "./img/official-image/Office.jpg",
        "alt" => "office"
    ],
    [
        "src" => "./img/official-image/founder.jpg",
        "alt" => "founder"
    ],
    [
        "src" => "./img/official-image/certificate.jpg",
        "alt" => "certificate"
    ],
    [
        "src" => "./img/official-image/associate.jpg",
        "alt" => "associate"
    ],
    [
        "src" => "./img/official-image/associate-2.jpg",
        "alt" => "associate 2"
    ],
    [
        "src" => "./img/official-image/client-meeting.jpg",
        "alt" => "client meeting"
    ],
    [
        "src" => "./img/official-image/founder-2.jpg",
        "alt" => "founder 2"
    ],
    [
        "src" => "./img/official-image/interior.jpg",
        "alt" => "interior"
    ],
    [
        "src" => "./img/official-image/interior2.jpg",
        "alt" => "interior 2"
    ],
    [
        "src" => "./img/official-image/interior3.jpg",
        "alt" => "interior 3"
    ],
    [
        "src" => "./img/official-image/interior4.jpg",
        "alt" => "interior 2"
    ],
    [
        "src" => "./img/official-image/interior5.jpg",
        "alt" => "interior 2"
    ],
    [
        "src" => "./img/official-image/team-2.jpg",
        "alt" => "interior 2"
    ],
    [
        "src" => "./img/official-image/team-3.jpg",
        "alt" => "interior 2"
    ],
    [
        "src" => "./img/official-image/team-meeting-2.jpg",
        "alt" => "interior 2"
    ],
];
$galleryImagesJson = json_encode($galleryImages);
?>

<!DOCTYPE html>
<html lang="en">
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>AM Law Offices</title>
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Libre+Baskerville:ital,wght@0,400;0,700;1,400&amp;family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap"
        rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link media="all" rel="stylesheet" href="css/main.css">

    <link href="https://cdn.jsdelivr.net/npm/lightbox2/dist/css/lightbox.min.css" rel="stylesheet">


    <style>
        .gallery {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            /* 3 columns */
            grid-gap: 16px;
            /* Space between items */
            max-width: 1400px;
            margin: 0 auto;
            padding: 20px 10px;
        }

        .gallery img {
            width: 100%;
            height: 300px;
            object-fit: cover;
            border-radius: 10px;
            opacity: 0.5;
        }

        .gallery img:hover {
            opacity: 1.0;
        }

        .pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-top: 20px;
        }

        .pagination button {
            margin: 0 5px 10px 5px;
            padding: 5px 10px;
            border: none;
            background-color: #ccc;
            cursor: pointer;
            border-radius: 5px;
            font-size: 16px;
        }

        .pagination button.active {
            background-color: #000;
            color: #fff;
        }

        .pagination button:disabled {
            background-color: #eee;
            cursor: not-allowed;
        }

        .pagination button:hover:not(:disabled) {
            background-color: #555;
            color: #fff;
        }

        @media (max-width: 768px) {
            .gallery img {
                height: 150px;
                /* Smaller image height for smaller screens */
            }
        }

        @media (max-width: 480px) {
            .gallery img {
                height: 120px;
                /* Even smaller for very small screens */
            }

            .pagination button {
                padding: 3px 8px;
                /* Smaller buttons */
                font-size: 14px;
                /* Adjust text size */
            }
        }
    </style>
</head>

<body>
    <div class="wrapper wrapper--offset-0">
        <?php include('main-header.php'); ?>
        <main class="main">
            <section class="section-intro">
                <div class="container">
                    <h1>Gallary</h1>
                    <h4 class="subtitle">Images</h4>
                </div>
                <div class="bg-stretch">
                    <img src="img/home/banner-1.jpg" alt="image description">
                </div>
            </section>
            <section class="section-breadcrumbs">
                <div class="container">
                    <ul class="breadcrumbs">
                        <li class="breadcrumbs__item"><a href="index.php" class="breadcrumbs__link">Home</a></li>
                        <li class="breadcrumbs__item current">Gallary</li>
                    </ul>
                </div>
            </section>
            <section class="section-gallery container">
                <div class="gallery">
                    <?php
                    $images = json_decode($galleryImagesJson, true);
                    foreach ($images as $index => $image) {
                        echo '<a href="' . htmlspecialchars($image['src']) . '" data-lightbox="gallery" data-title="' . htmlspecialchars($image['alt']) . '">';
                        echo '<img src="' . htmlspecialchars($image['src']) . '" alt="' . htmlspecialchars($image['alt']) . '">';
                        echo '</a>';
                    }
                    ?>
                </div>
            </section>
        </main>
    </div>
    <?php include('main-footer.php'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const itemsPerPage = 9;
            const gallery = document.querySelector('.gallery');
            const allItems = Array.from(gallery.querySelectorAll('a'));
            const paginationContainer = document.createElement('div');
            paginationContainer.className = 'pagination';
            let currentPage = 1;

            function showPage(page) {
                const start = (page - 1) * itemsPerPage;
                const end = start + itemsPerPage;
                allItems.forEach((item, index) => {
                    item.style.display = index >= start && index < end ? 'block' : 'none';
                });
            }

            function setupPagination() {
                const totalPages = Math.ceil(allItems.length / itemsPerPage);
                paginationContainer.innerHTML = '';

                // Previous button
                const prevButton = document.createElement('button');
                prevButton.textContent = '<';
                prevButton.disabled = currentPage === 1;
                prevButton.addEventListener('click', () => {
                    if (currentPage > 1) {
                        currentPage--;
                        showPage(currentPage);
                        setupPagination();
                    }
                });
                paginationContainer.appendChild(prevButton);

                // Page buttons
                for (let i = 1; i <= totalPages; i++) {
                    const button = document.createElement('button');
                    button.textContent = i;
                    button.className = i === currentPage ? 'active' : '';
                    button.addEventListener('click', () => {
                        currentPage = i;
                        showPage(currentPage);
                        setupPagination();
                    });
                    paginationContainer.appendChild(button);
                }

                // Next button
                const nextButton = document.createElement('button');
                nextButton.textContent = '>';
                nextButton.disabled = currentPage === totalPages;
                nextButton.addEventListener('click', () => {
                    if (currentPage < totalPages) {
                        currentPage++;
                        showPage(currentPage);
                        setupPagination();
                    }
                });
                paginationContainer.appendChild(nextButton);
            }

            gallery.after(paginationContainer);
            showPage(currentPage);
            setupPagination();
        });
    </script>
    <script src="js/all.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/lightbox2/dist/js/lightbox.min.js"></script>
</body>

</html>