<!DOCTYPE html>
<html lang="en">
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
	<title>AM Law Contact</title>
	<link rel="preconnect" href="https://fonts.googleapis.com/">
	<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
	<link
		href="https://fonts.googleapis.com/css2?family=Libre+Baskerville:ital,wght@0,400;0,700;1,400&amp;family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap"
		rel="stylesheet">
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
		integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
	<link media="all" rel="stylesheet" href="css/main.css">
	<style>
		.form-container {
			background: white;
			padding: 20px 30px;
			border-radius: 10px;
			box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
			width: 100%;
			max-width: 600px;
			margin: 0 auto;
		}

		h2 {
			text-align: center;
			color: #8a8a5c;
			margin-bottom: 20px;
		}

		.form-group {
			margin-bottom: 15px;
		}

		label {
			display: block;
			margin-bottom: 5px;
			color: #444;
			font-weight: bold;
		}

		input {
			width: 100%;
			padding: 10px;
			border-radius: 5px;
			font-size: 16px;
			outline: none;
			transition: border 0.3s ease;
		}

		input:focus {
			border: 1px solid #8a8a5c;
			box-shadow: 0 0 5px rgba(192, 148, 57, 0.5);
		}



		.image img {
			width: 100%;
			height: auto;
			border-radius: 10px;
			margin-right: 20%;
		}

		.row {
			display: flex;
			flex-wrap: wrap;
			align-items: stretch;
		}

		.col-md-5 {
			display: flex;
			justify-content: center;
			align-items: center;
		}

		@media (max-width: 1023px) {
			.image img {
				display: none;
			}
		}


		.quote {
			width: 60%;
			margin: 0 auto;
			padding: 50px 0;
		}

		.quote h1 {
			font-size: 36px;
			color: #8a8a5c;
		}

		.quote p {
			font-size: 18px;
			margin-bottom: 40px;
		}

		.quote form {
			display: flex;
			flex-wrap: wrap;
			justify-content: space-between;
		}

		.form-group {
			width: 48%;
			margin-bottom: 20px;
		}

		.form-group.full-width {
			width: 100%;
		}

		.s-btn {
			text-align: center;
		}

		label {
			display: block;
			font-size: 16px;
			margin-bottom: 5px;
		}

		input,
		textarea {
			width: 100%;
			padding: 10px;
			font-size: 16px;
			border: none;
			border: 1px solid rgb(187, 187, 187);
			outline: none;
		}

		textarea {
			height: 100px;
		}

		.submit-btn {
			background-color: #4a4a4a;
			width: 200px;
			color: #fff;
			padding: 10px 20px;
			font-size: 18px;
			border: none;
			cursor: pointer;
			margin-top: 20px;
		}

		@media (max-width: 767px) {
			.form-container {
				box-shadow: none;
			}
		}
	</style>
</head>

<body>
	<div class="wrapper wrapper--offset-0">
		<?php include "main-header.php" ?>
		<main class="main">
			<section class="section-intro">
				<div class="container">
					<h1>Contact us</h1>
				</div>
				<div class="bg-stretch">
					<img src="img/home/banner-3.jpg" alt="image description">
				</div>
			</section>
			<section class="section-breadcrumbs">
				<div class="container">
					<ul class="breadcrumbs">
						<li class="breadcrumbs__item"><a href="#" class="breadcrumbs__link">Home</a></li>
						<li class="breadcrumbs__item current">Contact us</li>
					</ul>
				</div>
			</section>
			<section class="section-tile">
				<div class="section-tile__item">
					<div class="container">
						<h3>Your Success, Our Expertise – <br>Let’s Connect!</h3>
						<p class="fs-14">Our team is here to offer expert legal guidance tailored to your unique
							challenges and goals. Reach out to us today, and let's discuss how our innovative approach
							and industry-leading experience can provide you with a distinct commercial advantage.
							Whether it's navigating complex mergers, securing real estate assets, or mitigating
							corporate risk, we’re ready to support your journey to success. Contact us to start a
							conversation—your success is our commitment.</p>
						<!-- <a href="#" class="btn btn--outline-primary">
							Find Out More
							<svg class="icon" width="21" height="12" viewBox="0 0 21 12">
								<path fill-rule="evenodd" clip-rule="evenodd" d="M15 6.75L0 6.75L0 5.25L15 5.25V6.75Z"/>
								<path d="M21 5.99986L14.25 11.196L14.25 0.803711L21 5.99986Z"/>
							</svg>
						</a> -->
					</div>
				</div>
				<div class="section-tile__item offset--0">
					<div class="bg-stretch bg-stretch--img">
						<img src="img/home/banner-4-4.jpg" alt="image description">
					</div>
				</div>
			</section>
			<section class="section-tile">
				<div class="section-tile__item offset--0">
					<div class="map">
						<iframe frameborder="0" scrolling="no" marginheight="0" marginwidth="0"
							src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3559.949987300063!2d80.98198551117004!3d26.841542976592443!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x399bfd3d07862825%3A0xc882b1f102d4978e!2sAasra!5e0!3m2!1sen!2sin!4v1731586156914!5m2!1sen!2sin"><a
								href="https://www.gps.ie/">gps systems</a></iframe>

					</div>
				</div>
				<div class="section-tile__item">
					<div class="form-container">
						<h2>
							Get in Touch</h2>
						<p>Contacting the firm is free. We understand that the disputes facing you, your family or your
							business can seem daunting.</p>
						<form id="applicationForm">
							<input type="hidden" name="applicationType" value="Join Us Application">
							<div class="row">
								<div class="form-group w-100">
									<label for="fname">Name</label>
									<input type="text" id="fname" name="fname" placeholder="Enter your first name"
										required>
								</div>

								<div class="form-group w-100">
									<label for="email">Email</label>
									<input type="email" id="email" name="email" placeholder="Enter your email" required>
								</div>
								<div class="form-group w-100">
									<label for="phone">Subject</label>
									<input type="text" id="phone" name="phone" placeholder="Enter your phone number"
										required>
								</div>
								<div class="form-group w-100">
									<label for="YOE">Message</label>
									<textarea name="" placeholder="Enter your message" id=""></textarea>
								</div>

							</div>
							<div class="w-100 text-center">
								<button class="btn btn--outline-primary w-50" type="submit">Submit</button>
							</div>
						</form>
					</div>
				</div>
			</section>
			<!-- <section class="section bg--light">
				<div class="container">
					<div class="section-headline">
						<h2>Office Locations</h2>
						<p>With our recognized leadership in applying legal service and technology innovation, we deliver commercial advantage to clients.</p>
					</div>
					<div class="row">
						<div class="col-3">
							<h5 class="title">Los Angeles</h5>
							<ul class="contact-info">
								<li class="contact-info__item">
									<span class="contact-info__text">Office</span>
									<strong>1760 Wilshire Blvd., Suite 1, LA, CA 90025</strong>
								</li>
								<li class="contact-info__item">
									<span class="contact-info__text">Mail</span>
									<a class="contact-info__link" href="mailto:example@example.com">example@example.com</a>
								</li>
								<li class="contact-info__item">
									<span class="contact-info__text">Tel</span>
									<a class="contact-info__link" href="tel:13105001234">+1 310 500 1234</a>
								</li>
							</ul>
						</div>
						<div class="col-3">
							<h5 class="title">San Francisco</h5>
							<ul class="contact-info">
								<li class="contact-info__item">
									<span class="contact-info__text">Office</span>
									<strong>1760 Wilshire Blvd., Suite 1, LA, CA 90025</strong>
								</li>
								<li class="contact-info__item">
									<span class="contact-info__text">Mail</span>
									<a class="contact-info__link" href="mailto:example@example.com">example@example.com</a>
								</li>
								<li class="contact-info__item">
									<span class="contact-info__text">Tel</span>
									<a class="contact-info__link" href="tel:13105001234">+1 310 500 1234</a>
								</li>
							</ul>
						</div>
						<div class="col-3">
							<h5 class="title">Barcelona</h5>
							<ul class="contact-info">
								<li class="contact-info__item">
									<span class="contact-info__text">Office</span>
									<strong>1760 Wilshire Blvd., Suite 1, LA, CA 90025</strong>
								</li>
								<li class="contact-info__item">
									<span class="contact-info__text">Mail</span>
									<a class="contact-info__link" href="mailto:example@example.com">example@example.com</a>
								</li>
								<li class="contact-info__item">
									<span class="contact-info__text">Tel</span>
									<a class="contact-info__link" href="tel:13105001234">+1 310 500 1234</a>
								</li>
							</ul>
						</div>
						<div class="col-3">
							<h5 class="title">Los Angeles</h5>
							<ul class="contact-info">
								<li>
									<span class="contact-info__text">Office</span>
									<strong>1760 Wilshire Blvd., Suite 1, LA, CA 90025</strong>
								</li>
								<li class="contact-info__item">
									<span class="contact-info__text">Mail</span>
									<a class="contact-info__link" href="mailto:example@example.com">example@example.com</a>
								</li>
								<li class="contact-info__item">
									<span class="contact-info__text">Tel</span>
									<a class="contact-info__link" href="tel:13105001234">+1 310 500 1234</a>
								</li>
							</ul>
						</div>
					</div>
				</div>
			</section> -->
			<!-- <section class="section bg--gradient">
				<div class="container">
					<div class="section-headline">
						<h4>Our people</h4>
						<p>Our lawyers offer clients a range of integrated global capabilities, including some of the world’s most active M&A, real estate, financial services, litigation and corporate risk practices.</p>
					</div>
					<ul class="team">
						<li class="team__item">
							<div class="team-member">
								<div class="team-member__img">
									<img src="img/law-6-540x654.jpg" alt="image description">
								</div>
								<div class="team-member__expanded">
									<h3 class="team-title">Peter Morgan</h3>
									<strong class="team-position">Senior Attorney, NY, NY</strong>
									<ul class="contact-info top--line">
										<li class="contact-info__item">
											<span class="contact-info__text">Mail</span>
											<a class="contact-info__link" href="mailto:peter@example.com">peter@example.com</a>
										</li>
										<li class="contact-info__item">
											<span class="contact-info__text">Mail</span>
											<a class="contact-info__link" href="tel:8002369590">800 236 9590</a>
										</li>
									</ul>
								</div>
								<a href="#" class="team-member__link"></a>
							</div>
						</li>
						<li class="team__item">
							<div class="team-member">
								<div class="team-member__img">
									<img src="img/image-43-540x654.jpg" alt="image description">
								</div>
								<div class="team-member__expanded">
									<h3 class="team-title">Kevin M. Johnson</h3>
									<strong class="team-position">Legal Assistant, CH, IL</strong>
									<ul class="contact-info top--line">
										<li class="contact-info__item">
											<span class="contact-info__text">Mail</span>
											<a class="contact-info__link" href="mailto:kevin@example.com">kevin@example.com</a>
										</li>
										<li class="contact-info__item">
											<span class="contact-info__text">Mail</span>
											<a class="contact-info__link" href="tel:8004367810">800 436 7810</a>
										</li>
									</ul>
								</div>
								<a href="#" class="team-member__link"></a>
							</div>
						</li>
						<li class="team__item">
							<div class="team-member">
								<div class="team-member__img">
									<img src="img/image-44-540x654.jpg" alt="image description">
								</div>
								<div class="team-member__expanded">
									<h3 class="team-title">Mary Jane</h3>
									<strong class="team-position">Senior Counsel, LA, CA</strong>
									<ul class="contact-info top--line">
										<li class="contact-info__item">
											<span class="contact-info__text">Mail</span>
											<a class="contact-info__link" href="mailto:mary@example.com">mary@example.com</a>
										</li>
										<li class="contact-info__item">
											<span class="contact-info__text">Mail</span>
											<a class="contact-info__link" href="tel:8004568790">800 456 8790</a>
										</li>
									</ul>
								</div>
								<a href="#" class="team-member__link"></a>
							</div>
						</li>
						<li class="team__item">
							<div class="team-member">
								<div class="team-member__img">
									<img src="img/image-45-540x654.jpg" alt="image description">
								</div>
								<div class="team-member__expanded">
									<h3 class="team-title">Tyler S. Jackson</h3>
									<strong class="team-position">Corporate Lawyer, SF, CA</strong>
									<ul class="contact-info top--line">
										<li class="contact-info__item">
											<span class="contact-info__text">Mail</span>
											<a class="contact-info__link" href="mailto:tyler@example.com">tyler@example.com</a>
										</li>
										<li class="contact-info__item">
											<span class="contact-info__text">Mail</span>
											<a class="contact-info__link" href="tel:8003768790">800 376 8790</a>
										</li>
									</ul>
								</div>
								<a href="#" class="team-member__link"></a>
							</div>
						</li>
					</ul>
					<div class="btn-holder">
						<a href="#" class="btn btn--outline-secondary">
							Find Out More
							<svg class="icon" width="21" height="12" viewBox="0 0 21 12">
								<path fill-rule="evenodd" clip-rule="evenodd" d="M15 6.75L0 6.75L0 5.25L15 5.25V6.75Z"/>
								<path d="M21 5.99986L14.25 11.196L14.25 0.803711L21 5.99986Z"/>
							</svg>
						</a>
					</div>
				</div>
			</section> -->
			<!-- <section class="section">
				<div class="container">
					<div class="section-headline">
						<h4>Company core values</h4>
						<p>Our lawyers offer clients a range of integrated global capabilities, including some of the world’s most active M&A, real estate, financial services, litigation and corporate risk practices.</p>
					</div>
					<ul class="row-list">
						<li class="row-list__item">
							<div class="blog-post">
								<div class="blog-post__visual">
									<a href="#" class="blog-post__img sm">
										<img src="img/image-28.jpg" alt="image description">
									</a>
								</div>
								<div class="listing-meta">
									<span class="listing-meta__item text--primary">
										<a href="#">Finance</a>
									</span>
									<span class="listing-meta__item">September 10, 2024</span>
								</div>
								<h3 class="blog-post__title"><a href="#">What Does Marijuana Law Mean for You?</a></h3>
								<a href="#" class="btn btn--link">View More</a>
							</div>
						</li>
						<li class="row-list__item">
							<div class="blog-post">
								<div class="blog-post__visual">
									<a href="#" class="blog-post__img sm">
										<img src="img/image-27.jpg" alt="image description">
									</a>
								</div>
								<div class="listing-meta">
									<span class="listing-meta__item text--primary">
										<a href="#">Corporate Law</a>
									</span>
									<span class="listing-meta__item">September 10, 2024</span>
								</div>
								<h3 class="blog-post__title"><a href="#">Hit-and-Run Crash Should Seek Immediate Counsel</a></h3>
								<a href="#" class="btn btn--link">View More</a>
							</div>
						</li>
						<li class="row-list__item">
							<div class="blog-post">
								<div class="blog-post__visual">
									<a href="#" class="blog-post__img sm">
										<img src="img/image-29.jpg" alt="image description">
									</a>
								</div>
								<div class="listing-meta">
									<span class="listing-meta__item text--primary">
										<a href="#">News</a>
									</span>
									<span class="listing-meta__item">September 10, 2024</span>
								</div>
								<h3 class="blog-post__title"><a href="#">So You’ve Had a Compliance Breach — Now What?</a></h3>
								<a href="#" class="btn btn--link">View More</a>
							</div>
						</li>
					</ul>
					<div class="btn-holder">
						<a href="#" class="btn btn--outline-primary">
							Find Out More
							<svg class="icon" width="21" height="12" viewBox="0 0 21 12">
								<path fill-rule="evenodd" clip-rule="evenodd" d="M15 6.75L0 6.75L0 5.25L15 5.25V6.75Z"/>
								<path d="M21 5.99986L14.25 11.196L14.25 0.803711L21 5.99986Z"/>
							</svg>
						</a>
					</div>
				</div>
			</section> -->
		</main>
		<?php include "main-footer.php" ?>
	</div>
	<script src="js/all.js"></script>
</body>

</html>