 
<!DOCTYPE html>
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>AM Law Offices</title>
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Libre+Baskerville:ital,wght@0,400;0,700;1,400&amp;family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap"
        rel="stylesheet">
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link media="all" rel="stylesheet" href="css/main.css">
    
    <style>
        /* Styles for the booking page */

        .back-link {
            display: inline-block;
            margin: 20px;
            color: #8A784D;
            text-decoration: none;
        }

        .booking-details-section {
            padding: 20px;
            text-align: left;
        }

        .booking-content {
            display: flex;
            gap: 40px;
            margin-top: 20px;
        }

        .date-time-selection,
        .service-details {
            flex: 1;
            border: 1px solid #ccc;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
        }

        .calendar-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-weight: bold;
        }

        .calendar {
            display: grid;
            grid-template-columns: repeat(7, 1fr);
            gap: 5px;
            margin-top: 10px;
        }

        .calendar-day {
            padding: 10px;
            text-align: center;
            cursor: pointer;
        }

        .calendar-day.selected {
            background-color: #8A784D;
            color: #fff;
        }

        .time-slots button {
            margin: 5px;
            padding: 10px;
            border: 1px solid #8A784D;
            background-color: #fff;
            color: #8A784D;
            cursor: pointer;
            border-radius: 4px;
        }

        .next-button {
            display: block;
            width: 100%;
            padding: 12px;
            background-color: #8A784D;
            color: white;
            border: none;
            cursor: pointer;
            border-radius: 4px;
            margin-top: 10px;
        }
    </style>
</head>

<body>
	<div class="wrapper wrapper--offset-0">
    <?php include "main-header.php"?>
		<main class="main">
           <section class="section-intro">
				<div class="container">
					<h1>Legal Consultancy</h1>
				</div>
				<div class="bg-stretch">
					<img src="img/home/banner-3.jpg" alt="image description">
				</div>
			</section>
            <section class="booking-details-section pt-5">
                <h4>Check out our availability and book the date and time that works for you</h4>
                <div class="booking-content">
                    <div class="date-time-selection">
                        <h3>Select a Date and Time</h3>
                        <!-- Calendar Header -->
                        <div class="calendar-header">
                            <button id="prev-month">&lt;</button>
                            <span id="month-year"></span>
                            <button id="next-month">&gt;</button>
                        </div>
                        <!-- Calendar Container -->
                        <div class="calendar" id="calendar"></div>
                        <!-- Time Slots Container -->
                        <div class="time-slots" id="time-slots">
                            <p>Select a time slot:</p>
                        </div>
                    </div>
                    <div class="service-details">
                        <h3>Service Details</h3>
                        <p id="service-summary">
                            <strong>Legal Consultancy</strong><br>
                            Date: <span id="selected-date">Not selected</span><br>
                            Time: <span id="selected-time">Not selected</span><br>
                            Location: Vipul Khand 6<br>
                            Consultant: ANAGH MISHRA<br>
                            Duration: 1 hr 30 min<br>
                            Price: ₹10,000
                        </p>
                        <button class="next-button">Next</button>
                    </div>
                </div>
            </section>
		</main>
        <?php include "main-footer.php"?>
	</div>
	<script src="js/all.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const calendar = document.getElementById('calendar');
            const monthYearEl = document.getElementById('month-year');
            const prevMonthBtn = document.getElementById('prev-month');
            const nextMonthBtn = document.getElementById('next-month');
            const timeSlots = document.getElementById('time-slots');
            const selectedDateEl = document.getElementById('selected-date');
            const selectedTimeEl = document.getElementById('selected-time');

            let selectedDate = null;
            const daysOfWeek = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
            const months = [
                'January', 'February', 'March', 'April', 'May', 'June',
                'July', 'August', 'September', 'October', 'November', 'December'
            ];

            let currentDate = new Date();
            let currentMonth = currentDate.getMonth();
            let currentYear = currentDate.getFullYear();

            function updateMonthYear() {
                monthYearEl.textContent = `${months[currentMonth]} ${currentYear}`;
            }

            function generateCalendar(month, year) {
                calendar.innerHTML = ''; // Clear previous calendar
                updateMonthYear();

                const firstDay = new Date(year, month, 1).getDay();
                const daysInMonth = new Date(year, month + 1, 0).getDate();

                // Add day labels
                daysOfWeek.forEach(day => {
                    const dayLabel = document.createElement('div');
                    dayLabel.classList.add('calendar-day');
                    dayLabel.style.fontWeight = 'bold';
                    dayLabel.textContent = day;
                    calendar.appendChild(dayLabel);
                });

                // Fill in the empty days at the start of the month
                for (let i = 0; i < firstDay; i++) {
                    calendar.innerHTML += `<div class="calendar-day inactive"></div>`;
                }

                // Fill in the actual days of the month
                for (let day = 1; day <= daysInMonth; day++) {
                    const dateDiv = document.createElement('div');
                    dateDiv.className = 'calendar-day';
                    dateDiv.innerText = day;
                    const thisDate = new Date(year, month, day);
                    if (thisDate.toDateString() === currentDate.toDateString()) {
                        dateDiv.classList.add('selected');
                        selectedDate = thisDate;
                        displayTimeSlots(thisDate);
                    }
                    dateDiv.addEventListener('click', () => {
                        document.querySelectorAll('.calendar-day').forEach(d => d.classList.remove('selected'));
                        dateDiv.classList.add('selected');
                        selectedDate = thisDate;
                        selectedDateEl.innerText = selectedDate.toDateString();
                        displayTimeSlots(selectedDate);
                    });
                    calendar.appendChild(dateDiv);
                }
            }
            function displayTimeSlots(date) {
                timeSlots.innerHTML = '<p>Select a time slot:</p>';
                const startHour = 10;
                const endHour = 16;
                const interval = 30;
                const now = new Date();

                for (let hour = startHour; hour <= endHour; hour++) {
                    for (let min = 0; min < 60; min += interval) {
                        const slot = new Date(date);
                        slot.setHours(hour, min, 0);

                        // Skip slots before the current time on today's date
                        if (slot.toDateString() === now.toDateString() && slot <= now) continue;

                        // Skip slot if it's after 4:30 PM
                        if (hour === endHour && min > 0) break;

                        const slotBtn = document.createElement('button');
                        slotBtn.innerText = slot.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' });
                        slotBtn.addEventListener('click', () => {
                            document.querySelectorAll('.time-slots button').forEach(b => b.classList.remove('selected'));
                            slotBtn.classList.add('selected');
                            selectedTimeEl.innerText = slotBtn.innerText;
                        });

                        timeSlots.appendChild(slotBtn);
                    }
                }
            }

            prevMonthBtn.addEventListener('click', () => {
                currentMonth = currentMonth === 0 ? 11 : currentMonth - 1;
                currentYear = currentMonth === 11 ? currentYear - 1 : currentYear;
                generateCalendar(currentMonth, currentYear);
            });

            nextMonthBtn.addEventListener('click', () => {
                currentMonth = currentMonth === 11 ? 0 : currentMonth + 1;
                currentYear = currentMonth === 0 ? currentYear + 1 : currentYear;
                generateCalendar(currentMonth, currentYear);
            });

            generateCalendar(currentMonth, currentYear); // Generate calendar on page load
        });
    </script>
</body>

</html>