<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>AM Law Offices</title>
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Libre+Baskerville:ital,wght@0,400;0,700;1,400&amp;family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap"
        rel="stylesheet">
    <link media="all" rel="stylesheet" href="css/main.css">
    <style>
        .booking-section {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            padding: 20px;
        }

        .custom-dropdown {
            position: relative;
            display: inline-block;
            width: 300px;
        }

        .custom-dropdown select {
            display: none; /* Hide the default select */
        }

        .dropdown-trigger {
            background-color: #8A784D;
            color: white;
            padding: 15px;
            border-radius: 5px;
            cursor: pointer;
            text-align: left;
            width: 100%;
            border: 1px solid #ccc;
            font-size: 16px;
        }

        .dropdown-menu {
            position: absolute;
            background-color: white;
            border: 1px solid #ccc;
            border-radius: 5px;
            width: 100%;
            max-height: 200px;
            overflow-y: auto;
            z-index: 1000;
            display: none;
        }

        .dropdown-menu div {
            padding: 10px;
            cursor: pointer;
        }

        .dropdown-menu div:hover {
            background-color: #f0f0f0;
        }

        .dropdown-menu div.selected {
            background-color: #8A784D;
            color: white;
        }
    </style>
</head>

<body>
    <div class="wrapper wrapper--offset-0">
        <?php include "main-header.php" ?>
        <main class="main">
            <section class="section-intro">
                <div class="container">
                    <h1>Book Appointment</h1>
                    <p>Check out our availability and book the date and time that works for you</p>
                </div>
                <div class="bg-stretch">
                    <img src="img/home/banner-3.jpg" alt="image description">
                </div>
            </section>
            <section class="section-breadcrumbs">
                <div class="container">
                    <ul class="breadcrumbs">
                        <li class="breadcrumbs__item"><a href="./index.php" class="breadcrumbs__link">Home</a></li>
                        <li class="breadcrumbs__item current">Book Appointment</li>
                    </ul>
                </div>
            </section>
            <!-- Booking service -->
            <section class="booking-section">
                <div class="custom-dropdown">
                    <div class="dropdown-trigger">Choose a service</div>
                    <div class="dropdown-menu">
                        <?php
                        $services = [
                            [
                                "title" => "Online Legal Consultancy",
                                "duration" => "1 hr 30 min",
                                "price" => "₹5,000",
                                "link" => "online-legal-consultancy.php?service=offline"
                            ],
                            [
                                "title" => "Legal Consultancy",
                                "duration" => "1 hr 30 min",
                                "price" => "₹10,000",
                                "link" => "legal-consultancy.php?service=online"
                            ]
                        ];

                        foreach ($services as $service) {
                            echo '<div class="service-option" data-link="' . $service["link"] . '">' . 
                                $service["title"] . ' - ' . $service["duration"] . ' - ' . $service["price"] . 
                                '</div>';
                        }
                        ?>
                    </div>
                </div>
            </section>
        </main>
        <?php include "main-footer.php" ?>
 </div>
    <script src="js/all.js"></script>
    <script>
        const dropdownTrigger = document.querySelector('.dropdown-trigger');
        const dropdownMenu = document.querySelector('.dropdown-menu');
        const serviceOptions = document.querySelectorAll('.service-option');

        dropdownTrigger.addEventListener('click', () => {
            dropdownMenu.style.display = dropdownMenu.style.display === 'block' ? 'none' : 'block';
        });

        serviceOptions.forEach(option => {
            option.addEventListener('click', () => {
                const link = option.getAttribute('data-link');
                window.location.href = link;
            });
        });

        // Close dropdown if clicked outside
        window.addEventListener('click', (event) => {
            if (!dropdownTrigger.contains(event.target) && !dropdownMenu.contains(event.target)) {
                dropdownMenu.style.display = 'none';
            }
        });
    </script>
</body>
</html>