<!DOCTYPE html>
<html lang="en">
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>AM Law Offices</title>
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Libre+Baskerville:ital,wght@0,400;0,700;1,400&amp;family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap"
        rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link media="all" rel="stylesheet" href="css/main.css">
</head>


<body>
    <div class="wrapper wrapper--offset-0">
        <?php include('main-header.php'); ?>
        <main class="main">
            <section class="section-intro">
                <div class="container">
                    <h1>About Us</h1>
                    <h4 class="subtitle">Company profile</h4>
                </div>
                <div class="bg-stretch">
                    <img src="img/home/banner-1.jpg" alt="image description">
                </div>
            </section>
            <section class="section-breadcrumbs">
                <div class="container">
                    <ul class="breadcrumbs">
                        <li class="breadcrumbs__item"><a href="index.php" class="breadcrumbs__link">Home</a></li>
                        <li class="breadcrumbs__item current">About Us</li>
                    </ul>
                </div>
            </section>
            <section class="section bg--gradient">
                <div class="container">
                    <div class="tile-wrapper">
                        <div class="tile-wrapper__content">
                            <h4 class="headtitle">Who we are</h4>
                            <h3 style="text-align: left;">AM Law Offices established in the year 2014 is a multi-
                                disciplinary law firm with
                                result oriented and well read lawyers having a global approach.</h3>
                            <p style="text-align: left;">Founded with the goal of bringing client service into
                                sharper focus, the firm has
                                successfully been able to establish its identity outside of its origins, dealing with
                                significant depth in complex domestic and international matters. It also provides
                                clients across all sectors with committed legal representation and commercially viable
                                legal advice.</p>
                            <p style="text-align: left;">For higher standards of service with a high degree of
                                professionalism and responsiveness,
                                our team of highly skilled and experienced lawyers brings entrepreneurial spirit to work
                                together with shared ideals.</p>
                        </div>
                        <div class="tile-wrapper__image">
                            <img src="img/home/banner-5-5.jpg" alt="image description">
                        </div>
                    </div>
                </div>
            </section>
            <section class="section">
                <div class="container">
                    <div class="section-headline">
                        <h4>Company core values</h4>
                        <p>Our lawyers offer clients a range of integrated global capabilities, including some of the
                            world’s most active M&A, real estate, financial services, litigation and corporate risk
                            practices.</p>
                    </div>
                    <ul class="row-list gap--0">
                        <li class="row-list__item">
                            <div class="card card--border">
                                <div class="card__image">
                                    <img src="img/img-17.png" alt="image description">
                                </div>
                                <h4 class="card__title">Corporate Law</h4>
                                <div class="text-wrap">
                                    <p>Every day, we help international businesses determine how best to structure their
                                        domestic and overseas operations.</p>
                                </div>
                            </div>
                        </li>
                        <li class="row-list__item">
                            <div class="card card--border">
                                <div class="card__image">
                                    <img src="img/img-18.png" alt="image description">
                                </div>
                                <h4 class="card__title">Teamwork and Collaboration</h4>
                                <div class="text-wrap">
                                    <p>Protect your trademarks, copyrights, patents, trade secrets, confidential
                                        information and other intellectual property rights around the world.</p>
                                </div>
                            </div>
                        </li>
                        <li class="row-list__item">
                            <div class="card card--border">
                                <div class="card__image">
                                    <img src="img/img-19.png" alt="image description">
                                </div>
                                <h4 class="card__title">Diversity and Inclusion</h4>
                                <div class="text-wrap">
                                    <p>We protect clients international enterprises and we never stop working to further
                                        develop our worldwide legal network.</p>
                                </div>
                            </div>
                        </li>
                    </ul>
                    <!-- <div class="btn-holder">
						<a href="#" class="btn btn--outline-primary">
							Find Out More
							<svg class="icon" width="21" height="12" viewBox="0 0 21 12">
								<path fill-rule="evenodd" clip-rule="evenodd" d="M15 6.75L0 6.75L0 5.25L15 5.25V6.75Z"/>
								<path d="M21 5.99986L14.25 11.196L14.25 0.803711L21 5.99986Z"/>
							</svg>
						</a>
					</div> -->
                </div>
            </section>
            <section class="section text--white">
                <div class="container">
                    <div class="section-headline">
                        <h4>Company timeline</h4>
                        <p>Our lawyers offer clients a range of integrated global capabilities, including some of the
                            world’s most active M&A, real estate, financial services, litigation and corporate risk
                            practices.</p>
                    </div>
                    <ul class="timeline">
                        <li class="timeline__item">
                            <div class="timeline-tile">
                                <span class="timeline-tile__num">2008</span>
                                <span class="timeline-tile__circle">
                                    <div class="circle-pulse"></div>
                                </span>
                                <div class="timeline-tile__content">
                                    <h3 class="timeline-tile__title">Established</h3>
                                    <p>Our lawyers offer clients a range of integrated global capabilities, including
                                        some of the world’s most active M&A, real estate, financial services, litigation
                                        and corporate risk practices.</p>
                                </div>
                            </div>
                        </li>
                        <li class="timeline__item">
                            <div class="timeline-tile">
                                <span class="timeline-tile__num">2011</span>
                                <span class="timeline-tile__circle">
                                    <div class="circle-pulse"></div>
                                </span>
                                <div class="timeline-tile__content">
                                    <h3 class="timeline-tile__title">Office Founded</h3>
                                    <p>Our lawyers offer clients a range of integrated global capabilities, including
                                        some of the world’s most active M&A, real estate, financial services, litigation
                                        and corporate risk practices.</p>
                                </div>
                            </div>
                        </li>
                        <li class="timeline__item">
                            <div class="timeline-tile">
                                <span class="timeline-tile__num">2014</span>
                                <span class="timeline-tile__circle">
                                    <div class="circle-pulse"></div>
                                </span>
                                <div class="timeline-tile__content">
                                    <h3 class="timeline-tile__title">Established</h3>
                                    <p>Our lawyers offer clients a range of integrated global capabilities, including
                                        some of the world’s most active M&A, real estate, financial services, litigation
                                        and corporate risk practices.</p>
                                </div>
                            </div>
                        </li>
                        <li class="timeline__item">
                            <div class="timeline-tile">
                                <span class="timeline-tile__num">2019</span>
                                <span class="timeline-tile__circle">
                                    <div class="circle-pulse"></div>
                                </span>
                                <div class="timeline-tile__content">
                                    <h3 class="timeline-tile__title">Office Founded</h3>
                                    <p>Our lawyers offer clients a range of integrated global capabilities, including
                                        some of the world’s most active M&A, real estate, financial services, litigation
                                        and corporate risk practices.</p>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="bg-stretch">
                    <img src="img/image-26.jpg" alt="image description">
                </div>
            </section>
            <section class="section">
                <div class="container">
                    <div class="section-headline">
                        <h4>Company details</h4>
                    </div>
                    <div class="accordion">
                        <div class="accordion__item bg--white">
                            <h4 class="accordion__title">Awards and Accolades</h4>
                            <div class="accordion__expanded">
                                <p>Our commitment to diversity and inclusion means that we are continually working to
                                    surpass our previous efforts in recruitment, retention and promotion of diverse
                                    attorneys. We continue to expand our outreach to the legal community through our
                                    diversity initiatives, business development, community involvement and pro bono
                                    engagements. We are honored by the recognitions that affirm these efforts and are
                                    always driven to do more.</p>
                            </div>
                        </div>
                        <div class="accordion__item bg--white">
                            <h4 class="accordion__title">Firmwide Resource Groups</h4>
                            <div class="accordion__expanded">
                                <p>Our commitment to diversity and inclusion means that we are continually working to
                                    surpass our previous efforts in recruitment, retention and promotion of diverse
                                    attorneys. We continue to expand our outreach to the legal community through our
                                    diversity initiatives, business development, community involvement and pro bono
                                    engagements. We are honored by the recognitions that affirm these efforts and are
                                    always driven to do more.</p>
                            </div>
                        </div>
                        <div class="accordion__item bg--white">
                            <h4 class="accordion__title">Recruiting and Pipeline Initiatives</h4>
                            <div class="accordion__expanded">
                                <p>Our commitment to diversity and inclusion means that we are continually working to
                                    surpass our previous efforts in recruitment, retention and promotion of diverse
                                    attorneys. We continue to expand our outreach to the legal community through our
                                    diversity initiatives, business development, community involvement and pro bono
                                    engagements. We are honored by the recognitions that affirm these efforts and are
                                    always driven to do more.</p>
                            </div>
                        </div>
                        <div class="accordion__item bg--white">
                            <h4 class="accordion__title">Work/Life Resources and Benefits</h4>
                            <div class="accordion__expanded">
                                <p>Our commitment to diversity and inclusion means that we are continually working to
                                    surpass our previous efforts in recruitment, retention and promotion of diverse
                                    attorneys. We continue to expand our outreach to the legal community through our
                                    diversity initiatives, business development, community involvement and pro bono
                                    engagements. We are honored by the recognitions that affirm these efforts and are
                                    always driven to do more.</p>
                            </div>
                        </div>
                        <div class="accordion__item bg--white">
                            <h4 class="accordion__title">Strategic Partnerships</h4>
                            <div class="accordion__expanded">
                                <p>Our commitment to diversity and inclusion means that we are continually working to
                                    surpass our previous efforts in recruitment, retention and promotion of diverse
                                    attorneys. We continue to expand our outreach to the legal community through our
                                    diversity initiatives, business development, community involvement and pro bono
                                    engagements. We are honored by the recognitions that affirm these efforts and are
                                    always driven to do more.</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="bg-stretch">
                    <img src="img/image-24.jpg" alt="image description">
                </div>
            </section>
            <!-- <section>
				<div class="container">
					<div class="contact-tile text--white">
						<div class="contact-tile__item">
							<div class="contact-tile__head">
								<h2>Get In Touch</h2>
								<p>Working with clients on their most critical challenges often results in new industry perspectives and insights.</p>
							</div>
							<ul class="contact-list">
								<li class="contact-list__item">
									<h6 class="contact-list__title">Call us now</h6>
									<a class="contact-list__link" href="tel:8001234567">800 123 4567</a>
								</li>
								<li class="contact-list__item">
									<h6 class="contact-list__title">Send mail</h6>
									<a href="mailto:example@example.com">example@example.com</a>
								</li>
								<li class="contact-list__item">
									<h6 class="contact-list__title">Or get our app</h6>
									<div class="app-links">
										<a href="#" class="app-links__item">
											<img src="img/img-28.png" width="200" alt="image description">
										</a>
										<a href="#" class="app-links__item">
											<img src="img/img-29.png" width="200" alt="image description">
										</a>
									</div>
								</li>
							</ul>
						</div>
						<div class="contact-tile__item">
							<div class="contact-tile__image">
								<img class="contact-tile__image" src="img/img-20-1.png" alt="image description">
							</div>
						</div>
					</div>
				</div>
				<div class="bg-stretch">
					<img src="img/image-25.jpg" alt="image description">
				</div>
			</section> -->
            <section class="section section-testimonial">
                <div class="container">
                    <div class="section-headline">
                        <h4>Satisfied client stories</h4>
                    </div>
                    <div class="testimonial-slider">
                        <div class="swiper-wrapper">
                            <div class="swiper-slide">
                                <blockquote class="testimonial-quote">
                                    <p>“AM Law Offices is committed to providing its clients with the best legal
                                        representation available, while also providing the level attention to detail
                                        that our clients expect and deserve.”</p>
                                    <span class="testimonial-quote__author">Mary Jane, IT Company CEO</span>
                                </blockquote>
                            </div>

                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
                <div class="bg-stretch">
                    <img src="img/image-7.jpg" alt="image description">
                </div>
            </section>
            <section class="section bg--light">
                <div class="container">
                    <div class="section-headline">
                        <h4>Our people</h4>
                    </div>
                    <ul class="row-list gap--1">
                        <li class="row-list__item">
                            <div class="team-card">
                                <div class="team-card__img">
                                    <img src="img/team/founder.jpg" alt="image description">
                                </div>
                                <h3 class="team-title"> Anagh Mishra</h3>
                                <strong class="team-position">Founding Partner</strong>
                                <ul class="contact-info top--line">
                                    <li class="contact-info__item">
                                        <span class="contact-info__text">Mail</span>
                                        <a class="contact-info__link"
                                            href="mailto:amlegaloffices@gmail.com">amlegaloffices@gmail.com</a>
                                    </li>
                                    <li class="contact-info__item">
                                        <span class="contact-info__text">Mob</span>
                                        <a class="contact-info__link" href="tel:7905243300">+91 7905243300</a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                        <li class="row-list__item">
                            <div class="team-card">
                                <div class="team-card__img">
                                    <img src="img/team/associate.jpg" alt="image description">
                                </div>
                                <h3 class="team-title">Manoj Kumar</h3>
                                <strong class="team-position">Associate</strong>
                                <ul class="contact-info top--line">
                                    <!-- <li class="contact-info__item">
										<span class="contact-info__text">Mail</span>
										<a class="contact-info__link" href="mailto:kevin@example.com">kevin@example.com</a>
									</li> -->
                                    <li class="contact-info__item">
                                        <span class="contact-info__text">Mob</span>
                                        <a class="contact-info__link" href="tel:8004367810">+91 7084286666</a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                        <li class="row-list__item">
                            <div class="team-card">
                                <div class="team-card__img">
                                    <img src="img/team/luv.png" alt="image description">
                                </div>
                                <h3 class="team-title">Luv Singh</h3>
                                <strong class="team-position">Associate</strong>
                                <ul class="contact-info top--line">
                                    <li class="contact-info__item">
                                        <span class="contact-info__text">Mail</span>
                                        <a class="contact-info__link"
                                            href="mailto:singhluv01@gmail.com">singhluv01@gmail.com</a>
                                    </li>
                                    <li class="contact-info__item">
                                        <span class="contact-info__text">Mob</span>
                                        <a class="contact-info__link" href="tel:8318078196">+91 8318078196</a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                    </ul>
                    <div class="btn-holder">
                        <a href="lawyers.php" class="btn btn--outline-primary">
                            Find Out More
                            <svg class="icon" width="21" height="12" viewBox="0 0 21 12">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M15 6.75L0 6.75L0 5.25L15 5.25V6.75Z" />
                                <path d="M21 5.99986L14.25 11.196L14.25 0.803711L21 5.99986Z" />
                            </svg>
                        </a>
                    </div>
                </div>
            </section>
        </main>
        <?php include('main-footer.php'); ?>
    </div>
    <script src="js/all.js"></script>
</body>


</html>

</html>

</html>