<?php
namespace App;
use Request;
use Carbon\Carbon;
use DB;
use App\PaymentLog;
use App\RefundPaymentLog;
use App\EcomLogs;
//use Jenssegers\Agent\Agent;
class LogActivity
{
    public static function addToPayment($requestparams,  $orderID, $response, $status, $order_payment_phase, $hash, $paymentMethod)
    {   
        $data['letzpay_hash'] = $hash;
      //  $data['platform_device'] = LogActivity::deviceAndbrowserDetection();
        $data['payment_phase']= $order_payment_phase;
        $data['payment_method']= $paymentMethod;
        $data['status']= $status;
        $data['response']= $response;
        $data['request']= $requestparams;
        $data['url']= Request::fullUrl();
        $data['method'] = Request::method();
        $data['ip']= \Request::ip();
        $data['agent'] = Request::header('user-agent');
        $data['user_id']= @Auth()->user()->id;
        $data['order_id']= $orderID;
        $data['created_at'] = Carbon::now()->toDateTimeString();
        PaymentLog::insert($data);
    }

    public static function addToRefund($requestparams,  $orderID, $orderDetailID, $refundID, $response, $status, $hash, $paymentMethod, $amount, $refundType){

        $data['url']= Request::fullUrl();
       // $data['platform_device'] = LogActivity::deviceAndbrowserDetection();
        $data['method'] = Request::method();
        $data['ip']= \Request::ip();
        $data['agent'] = Request::header('user-agent');
        $data['user_id']= @Auth()->user()->id;
        $data['order_id']= $orderID;
        $data['order_detail_id']= $orderDetailID;
        $data['amount']= $amount;
        $data['refund_id'] = $refundID;
        $data['refund_type'] = $refundType;
        $data['response']= $response;
        $data['request']= $requestparams;
        $data['letzpay_hash'] = $hash;
        $data['payment_method']= $paymentMethod;
        $data['status']= $status;
        $data['created_at'] = Carbon::now()->toDateTimeString();
        RefundPaymentLog::insert($data);

    }

    public static function addToEcomLog($requestparams,  $ecomRequestType, $ecomStatus, $ecomResponse, $status){

       // $data['platform_device'] = LogActivity::deviceAndbrowserDetection();
        $data['ip']= \Request::ip();
        $data['url']= Request::fullUrl();
        $data['agent'] = Request::header('user-agent');
        $data['method'] = Request::method();   
        $data['ecom_request_type']= $ecomRequestType;
        $data['request']= $requestparams;
        $data['ecom_status']= $ecomStatus;
        $data['ecom_response'] = $ecomResponse;
        $data['status']= $status;
        $data['created_at'] = Carbon::now()->toDateTimeString();
        EcomLogs::insert($data);

    }

    public static function addToSmsLog($requestparams, $response,  $type , $service, $mobile)
    {   
        
        $data['response']= $response;
        $data['type']= $type;
        $data['platform_device'] = LogActivity::deviceAndbrowserDetection();
        $data['mobile']= $mobile;
        $data['request']= $requestparams;
        $data['method'] = Request::method();
        $data['ip']= \Request::ip();
        $data['sms_service_type']= $service;        
        $data['user_id'] = @Auth()->user()->id;      
        $data['created_at'] = Carbon::now()->toDateTimeString();
        DB::table('sms_logs')->insert($data);
    }


    public static function deviceAndbrowserDetection(){
     
        $agent = new Agent();
        $header = Request::header('user-agent');
        $agent->setUserAgent($header);
        $data['device'] = $agent->device();
        $data['Windows'] = $agent->is('Windows');
        $data['Firefox'] = $agent->is('Firefox');
        $data['iPhone'] = $agent->is('iPhone');
        $data['OS'] = $agent->is('OS X');
        $data['isAndroidOS'] = $agent->isAndroidOS();
        $data['isNexus'] = $agent->isNexus();
        $data['isSafari'] = $agent->isSafari();
        $data['browser'] = $agent->browser();
        $data['browser_version'] = $agent->version($data['browser']);
        $data['platform'] = $agent->platform();
        $data['platform_version'] = $agent->version($data['platform']);

        return json_encode($data);
    }
    
    
}