<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Session;
use Redirect;
use App\Order;
use App\Seller;
use Razorpay\Api\Api;
use Illuminate\Support\Facades\Input;
use App\CustomerPackage;
use App\SellerPackage;
use App\Http\Controllers\CustomerPackageController;
use Auth;
use App\LogActivity;
use Config;
use Flash;

class RazorpayController extends Controller
{
    public function payWithRazorpay($request)
    {
        if(Session::has('payment_type')){
            if(Session::get('payment_type') == 'cart_payment'){
                $order = Order::findOrFail(Session::get('order_id'));
                $api = new Api(env('RAZOR_KEY'), env('RAZOR_SECRET'));

                $orderinfo = $api->order->create(array(
                    'receipt' => $order->code,
                    'amount' => $order->grand_total * 100,
                    'currency' => 'INR'
                    )
                );
                $orderId = $orderinfo['id']; // Get the created Order ID
                $orderinfo  = $api->order->fetch($orderId);
                $order_detalis = json_encode(array(     'id' => $orderinfo['id'],
                                                        'entity' => $orderinfo['entity'],
                                                        'amount' => $orderinfo['amount'],
                                                        'currency' => $orderinfo['currency'],
                                                        'receipt' => $orderinfo['receipt'],
                                                        'status' => $orderinfo['status'],
                                                        'attempts' => $orderinfo['attempts']
                                                    ));
                $orderUpdate = Order::where('id', Session::get('order_id'))->update(['order_create' => $order_detalis]);
                $requestParams = json_encode(array('id' => $order->code, 'amount' => $order->grand_total*100, 'currency' => 'INR'));
                LogActivity::addToPayment($order_detalis, $order->id, 'success', 'success', 'post', '', 'razorpay');
                // return view('frontend.razor_wallet.order_payment_Razorpay', compact('order'))->with('orderId', $orderinfo['id']);
                $response = [
                        'receipt' => $order->code,
                        'orderId' => $orderinfo['id'],
                        'razorpayId' => env('RAZOR_KEY'),
                        'amount' => $order->grand_total*100,
                        'name' => json_decode($order->shipping_address)->name,
                        'currency' => 'INR',
                        'email' => json_decode($order->shipping_address)->email,
                        'contactNumber' => json_decode($order->shipping_address)->phone,
                        'address' =>json_decode($order->shipping_address)->address,
                        'description' => 'Order Payment',
                    ];

                return view('frontend.razor_wallet.razor-pay',compact('response'));
                // return view('frontend.razor_wallet.order_payment_Razorpay', compact('order'));
            }
            elseif (Session::get('payment_type') == 'wallet_payment') {
                return view('frontend.razor_wallet.wallet_payment_Razorpay');
            }
            elseif (Session::get('payment_type') == 'customer_package_payment') {
                return view('frontend.razor_wallet.customer_package_payment_Razorpay');
            }
            elseif (Session::get('payment_type') == 'seller_package_payment') {
                return view('frontend.razor_wallet.seller_package_payment_Razorpay');
            }
        }

    }

    public function payment(Request $request)
    {
        $signatureStatus = $this->SignatureVerify(
            $request->all()['rzp_signature'],
            $request->all()['rzp_paymentid'],
            $request->all()['rzp_orderid']
        );

        if($signatureStatus == true)
        {            
            $order = Order::findOrFail(Session::get('order_id'));
            //Input items of form
            $input = $request->all();
            //get API Configuration

            $api = new Api(env('RAZOR_KEY'), env('RAZOR_SECRET'));

            // echo '<pre>';
            // print_r($api); die;

            //Fetch payment information by razorpay_payment_id
            $payment = $api->payment->fetch($input['rzp_paymentid']);

            if(count($input)  && !empty($input['rzp_paymentid'])) {
                $payment_detalis = json_encode(array(
                                                    'id' => $payment['id'],
                                                    'order_id' => $payment['order_id'],
                                                    'method' => $payment['method'], 
                                                    'status' => $payment['status'], 
                                                    'email' => $payment['email'],
                                                    'contact' => $payment['contact'],
                                                    'amount' => $payment['amount'],
                                                    'currency' => $payment['currency']));
                 $requestParams = json_encode($request);   
                LogActivity::addToPayment($requestParams, Session::get('order_id'), $payment_detalis, 'success', 'get','', 'razorpay');
           
            }

            // Do something here for store payment details in database...
            if(Session::has('payment_type')){
                if(Session::get('payment_type') == 'cart_payment'){               
                    $checkoutController = new CheckoutController;
                    return $checkoutController->checkout_done(Session::get('order_id'), $payment_detalis);
                }
            }
            }else{
                flash("something went wrong!!")->error();
            return redirect('checkout/payment_select');
        }if(Session::has('payment_type')){
            if (Session::get('payment_type') == 'wallet_payment') {
                $walletController = new WalletController;
                return $walletController->wallet_payment_done(Session::get('payment_data'), $payment_detalis);
            }
            elseif (Session::get('payment_type') == 'customer_package_payment') {
                $customer_package_controller = new CustomerPackageController;
                return $customer_package_controller->purchase_payment_done(Session::get('payment_data'), $payment);
            }
            elseif (Session::get('payment_type') == 'seller_package_payment') {
                $seller_package_controller = new SellerPackageController;
                return $seller_package_controller->purchase_payment_done(Session::get('payment_data'), $payment);
            }
        }
       
    }

      // In this function we return boolean if signature is correct
    private function SignatureVerify($_signature,$_paymentId,$_orderId)
    {
        try
        {
            $api = new Api(env('RAZOR_KEY'), env('RAZOR_SECRET'));
            $attributes  = array('razorpay_signature'  => $_signature,  'razorpay_payment_id'  => $_paymentId ,  'razorpay_order_id' => $_orderId);
            $order  = $api->utility->verifyPaymentSignature($attributes);
            return true;
        }
        catch(\Exception $e)
        {
            return false;
        }
    }
}
